/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;

public class EntityUniqueKey
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized String uniqueKeyName;
    private final @UnknownKeyFor @NonNull @Initialized String entityName;
    private final @UnknownKeyFor @NonNull @Initialized Object key;
    private final @UnknownKeyFor @NonNull @Initialized Type keyType;
    private final @UnknownKeyFor @NonNull @Initialized int hashCode;

    public EntityUniqueKey(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized String uniqueKeyName, @UnknownKeyFor @NonNull @Initialized Object key, @UnknownKeyFor @NonNull @Initialized Type keyType, @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor factory) {
        this.uniqueKeyName = uniqueKeyName;
        this.entityName = entityName;
        this.key = key;
        this.keyType = keyType;
        this.hashCode = EntityUniqueKey.generateHashCode(entityName, uniqueKeyName, keyType, key, factory);
    }

    public @UnknownKeyFor @NonNull @Initialized String getEntityName() {
        return this.entityName;
    }

    public @UnknownKeyFor @NonNull @Initialized Object getKey() {
        return this.key;
    }

    public @UnknownKeyFor @NonNull @Initialized String getUniqueKeyName() {
        return this.uniqueKeyName;
    }

    public static @UnknownKeyFor @NonNull @Initialized int generateHashCode(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized String uniqueKeyName, @UnknownKeyFor @NonNull @Initialized Type keyType, @UnknownKeyFor @NonNull @Initialized Object key, @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor factory) {
        int result = 17;
        result = 37 * result + entityName.hashCode();
        result = 37 * result + uniqueKeyName.hashCode();
        result = 37 * result + keyType.getHashCode(key, factory);
        return result;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.hashCode;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
        if (other == null || other.getClass() != EntityUniqueKey.class) {
            return false;
        }
        EntityUniqueKey that = (EntityUniqueKey)other;
        return that != null && that.entityName.equals(this.entityName) && that.uniqueKeyName.equals(this.uniqueKeyName) && this.keyType.isEqual(that.key, this.key);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "EntityUniqueKey" + MessageHelper.infoString(this.entityName, this.uniqueKeyName, this.key);
    }

    private void writeObject(@UnknownKeyFor @NonNull @Initialized ObjectOutputStream oos) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.checkAbilityToSerialize();
        oos.defaultWriteObject();
    }

    private void checkAbilityToSerialize() {
        if (this.key != null && !Serializable.class.isAssignableFrom(this.key.getClass())) {
            throw new IllegalStateException("Cannot serialize an EntityUniqueKey which represents a non serializable property value [" + this.entityName + "." + this.uniqueKeyName + "]");
        }
    }

    public void serialize(@UnknownKeyFor @NonNull @Initialized ObjectOutputStream oos) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.checkAbilityToSerialize();
        oos.writeObject(this.uniqueKeyName);
        oos.writeObject(this.entityName);
        oos.writeObject(this.key);
        oos.writeObject(this.keyType);
    }

    public static @UnknownKeyFor @NonNull @Initialized EntityUniqueKey deserialize(@UnknownKeyFor @NonNull @Initialized ObjectInputStream ois, @UnknownKeyFor @NonNull @Initialized SessionImplementor session) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
        return new EntityUniqueKey((String)ois.readObject(), (String)ois.readObject(), ois.readObject(), (Type)ois.readObject(), (SessionFactoryImplementor)session.getFactory());
    }
}

