/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.evm.gamification.rest;

import io.meeds.evm.gamification.model.BlockchainNetwork;
import io.meeds.evm.gamification.service.EvmNetworkService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.io.IOException;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/gamification/connectors/evm/networks"})
public class EvmNetworkController {
    @Autowired
    EvmNetworkService evmNetworkService;

    @GetMapping
    @Secured(value={"users"})
    @Operation(summary="Retrieves the list of networks", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Not found")})
    public Set<BlockchainNetwork> getNetworks() {
        try {
            return this.evmNetworkService.getNetworks();
        }
        catch (IOException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "No networks found");
        }
    }
}

