/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.dao;

import jakarta.persistence.TypedQuery;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.perkstore.entity.ProductOrderEntity;
import org.exoplatform.perkstore.model.OrderFilter;
import org.exoplatform.perkstore.model.constant.ProductOrderStatus;
import org.exoplatform.perkstore.model.constant.ProductOrderType;
import org.exoplatform.perkstore.service.PerkStoreService;
import org.exoplatform.perkstore.service.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;

public class PerkStoreOrderDAO
extends GenericDAOJPAImpl<ProductOrderEntity, Long> {
    private static final String TO_DATE_PARAMETER = "to";
    private static final String FROM_DATE_PARAMETER = "from";
    private static final Log LOG = ExoLogger.getLogger(PerkStoreService.class);
    private static final String IDENTITY_ID_PARAMETER = "identityId";
    private static final String AND_OPERATOR = " AND ";
    private static final String OR_OPERATOR = " OR ";
    private static final String PRODUCT_ID_PARAMETER = "productId";
    private static final String STATUS_PARAMETER = "status";

    public void deleteAll() {
        throw new UnsupportedOperationException();
    }

    public void deleteAll(List<ProductOrderEntity> entities) {
        throw new UnsupportedOperationException();
    }

    public double countOrderedQuantityByProductId(long productId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Order.countOrderedQuantityByProductId", Double.class);
        query.setParameter(PRODUCT_ID_PARAMETER, (Object)productId);
        Double result = (Double)query.getSingleResult();
        return result == null ? 0.0 : result;
    }

    public double countOrderedQuantityByProductIdAndStatus(long productId, ProductOrderStatus status) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Order.countOrderedQuantityByProductIdAndStatus", Double.class);
        query.setParameter(PRODUCT_ID_PARAMETER, (Object)productId);
        query.setParameter(STATUS_PARAMETER, (Object)status);
        Double result = (Double)query.getSingleResult();
        return result == null ? 0.0 : result;
    }

    public double countRefundedQuantityByProductId(long productId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Order.countRefundedQuantityByProductId", Double.class);
        query.setParameter(PRODUCT_ID_PARAMETER, (Object)productId);
        Double result = (Double)query.getSingleResult();
        return result == null ? 0.0 : result;
    }

    public long countRemainingOrdersToProcessByProductId(long productId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Order.countRemainingOrdersByProductId", Long.class);
        query.setParameter(PRODUCT_ID_PARAMETER, (Object)productId);
        Long result = (Long)query.getSingleResult();
        return result == null ? 0L : result;
    }

    public long countRemainingOrdersByIdentityIdAndProductId(long identityId, long productId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Order.countRemainingOrdersByIdentityIdAndProductId", Long.class);
        query.setParameter(PRODUCT_ID_PARAMETER, (Object)productId);
        query.setParameter(IDENTITY_ID_PARAMETER, (Object)identityId);
        Long result = (Long)query.getSingleResult();
        return result == null ? 0L : result;
    }

    public double countUserTotalPurchasedQuantity(long productId, long identityId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Order.countUserTotalPurchasedQuantity", Double.class);
        query.setParameter(PRODUCT_ID_PARAMETER, (Object)productId);
        query.setParameter(IDENTITY_ID_PARAMETER, (Object)identityId);
        Double result = (Double)query.getSingleResult();
        return result == null ? 0.0 : result;
    }

    public double countUserTotalRefundedQuantity(long productId, long identityId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Order.countUserTotalRefundedQuantity", Double.class);
        query.setParameter(PRODUCT_ID_PARAMETER, (Object)productId);
        query.setParameter(IDENTITY_ID_PARAMETER, (Object)identityId);
        Double result = (Double)query.getSingleResult();
        return result == null ? 0.0 : result;
    }

    public double countUserTotalOrderedQuantityByStatus(long productId, long identityId, ProductOrderStatus status) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Order.countUserTotalOrderedQuantityByStatus", Double.class);
        query.setParameter(PRODUCT_ID_PARAMETER, (Object)productId);
        query.setParameter(IDENTITY_ID_PARAMETER, (Object)identityId);
        query.setParameter(STATUS_PARAMETER, (Object)status);
        Double result = (Double)query.getSingleResult();
        return result == null ? 0.0 : result;
    }

    public double countUserPurchasedQuantityInPeriod(long productId, long identityId, long startDate, long endDate) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Order.countUserPurchasedQuantityInPeriod", Double.class);
        query.setParameter(PRODUCT_ID_PARAMETER, (Object)productId);
        query.setParameter(IDENTITY_ID_PARAMETER, (Object)identityId);
        query.setParameter(FROM_DATE_PARAMETER, (Object)startDate);
        query.setParameter(TO_DATE_PARAMETER, (Object)endDate);
        Double result = (Double)query.getSingleResult();
        return result == null ? 0.0 : result;
    }

    public double countUserRefundedQuantityInPeriod(long productId, long identityId, long startDate, long endDate) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Order.countUserRefundedQuantityInPeriod", Double.class);
        query.setParameter(PRODUCT_ID_PARAMETER, (Object)productId);
        query.setParameter(IDENTITY_ID_PARAMETER, (Object)identityId);
        query.setParameter(FROM_DATE_PARAMETER, (Object)startDate);
        query.setParameter(TO_DATE_PARAMETER, (Object)endDate);
        Double result = (Double)query.getSingleResult();
        return result == null ? 0.0 : result;
    }

    public double countUserOrderedQuantityByStatusInPeriod(long productId, long identityId, long startDate, long endDate, ProductOrderStatus status) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Order.countUserOrderedQuantityByStatusInPeriod", Double.class);
        query.setParameter(PRODUCT_ID_PARAMETER, (Object)productId);
        query.setParameter(IDENTITY_ID_PARAMETER, (Object)identityId);
        query.setParameter(FROM_DATE_PARAMETER, (Object)startDate);
        query.setParameter(TO_DATE_PARAMETER, (Object)endDate);
        query.setParameter(STATUS_PARAMETER, (Object)status);
        Double result = (Double)query.getSingleResult();
        return result == null ? 0.0 : result;
    }

    public List<ProductOrderEntity> getOrders(String username, OrderFilter filter, boolean isPerkStoreManager, boolean isProductOwner) {
        StringBuilder orderQuery = this.getOrderFilterQueryString(username, filter, isPerkStoreManager, isProductOwner);
        if (StringUtils.isEmpty((CharSequence)orderQuery.toString().trim())) {
            orderQuery.insert(0, "Select o from Order o ");
        } else {
            orderQuery.insert(0, "Select o from Order o WHERE ");
        }
        orderQuery.append(" ORDER BY createdDate DESC");
        TypedQuery query = this.getEntityManager().createQuery(orderQuery.toString(), ProductOrderEntity.class);
        query.setMaxResults(filter.getLimit());
        return query.getResultList();
    }

    public Long countOrders(String username, OrderFilter filter, boolean isPerkStoreManager, boolean isProductOwner) {
        StringBuilder orderQuery = this.getOrderFilterQueryString(username, filter, isPerkStoreManager, isProductOwner);
        if (StringUtils.isEmpty((CharSequence)orderQuery.toString().trim())) {
            orderQuery.insert(0, "Select count(o) from Order o ");
        } else {
            orderQuery.insert(0, "Select count(o) from Order o WHERE ");
        }
        TypedQuery query = this.getEntityManager().createQuery(orderQuery.toString(), Long.class);
        Long result = (Long)query.getSingleResult();
        return result == null ? 0L : result;
    }

    public ProductOrderEntity findOrderByTransactionHash(String hash) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Order.findOrderByTransactionHash", ProductOrderEntity.class);
        query.setParameter("hash", (Object)hash);
        List results = query.getResultList();
        if (results == null || results.isEmpty()) {
            return null;
        }
        if (results.size() == 1) {
            return (ProductOrderEntity)results.get(0);
        }
        LOG.warn("More than one order was found with transaction hash {}", new Object[]{hash});
        return (ProductOrderEntity)results.get(0);
    }

    public ProductOrderEntity findOrderByRefundTransactionHash(String hash) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Order.findOrderByRefundTransactionHash", ProductOrderEntity.class);
        query.setParameter("hash", (Object)hash);
        List results = query.getResultList();
        if (results == null || results.isEmpty()) {
            return null;
        }
        if (results.size() == 1) {
            return (ProductOrderEntity)results.get(0);
        }
        LOG.warn("More than one order was found with refund transaction hash {}", new Object[]{hash});
        return (ProductOrderEntity)results.get(0);
    }

    private StringBuilder getOrderFilterQueryString(String username, OrderFilter filter, boolean isPerkStoreManager, boolean isProductOwner) {
        Identity identity;
        StringBuilder query = new StringBuilder();
        boolean firstConditionAdded = false;
        if (filter.getProductId() != 0L) {
            query.append(" o.product.id = ");
            query.append(filter.getProductId());
            firstConditionAdded = true;
        }
        if (firstConditionAdded) {
            query.append(AND_OPERATOR);
        }
        query.append(" o.product.isDeleted = false");
        if (StringUtils.isNotBlank((CharSequence)username) && (identity = Utils.getIdentityByTypeAndId("user", username)) != null) {
            if (isPerkStoreManager) {
                if (filter.getOrdersType() == ProductOrderType.RECEIVED) {
                    query.append(AND_OPERATOR);
                    query.append(" o.senderId <> ");
                    query.append(identity.getId());
                } else if (filter.getOrdersType() == ProductOrderType.SENT) {
                    query.append(AND_OPERATOR);
                    query.append(" o.senderId = ");
                    query.append(identity.getId());
                }
            } else if (filter.getProductId() == 0L) {
                if (filter.getOrdersType() == ProductOrderType.ALL) {
                    query.append(AND_OPERATOR);
                    query.append("( o.senderId = ");
                    query.append(identity.getId());
                    query.append(OR_OPERATOR);
                    query.append(" o.receiverId = ");
                    query.append(identity.getId());
                    query.append(" )");
                }
                if (filter.getOrdersType() == ProductOrderType.RECEIVED) {
                    query.append(AND_OPERATOR);
                    query.append(" o.receiverId = ");
                    query.append(identity.getId());
                }
                if (filter.getOrdersType() == ProductOrderType.SENT) {
                    query.append(AND_OPERATOR);
                    query.append(" o.senderId = ");
                    query.append(identity.getId());
                }
            } else if (filter.getProductId() != 0L && !isProductOwner) {
                query.append(AND_OPERATOR);
                query.append(" o.senderId = ");
                query.append(identity.getId());
            }
        }
        if (filter.isNotProcessed()) {
            query.append(AND_OPERATOR);
            query.append(" o.remainingQuantity > 0");
        } else {
            List<Integer> statuses = this.getSelectedStatuses(filter);
            if (!statuses.isEmpty()) {
                query.append(AND_OPERATOR);
                query.append(" o.status in (");
                query.append(StringUtils.join(statuses, (String)", "));
                query.append(" )");
            }
        }
        long selectedDate = filter.getSelectedDate();
        if (filter.isSearchInDates() && selectedDate > 0L) {
            query.append(AND_OPERATOR);
            query.append(" o.createdDate > ");
            query.append(this.getStartOfDayMillis(selectedDate));
            query.append(" AND o.createdDate < ");
            query.append(this.getEndOfDayMillis(selectedDate));
        }
        return query;
    }

    private List<Integer> getSelectedStatuses(OrderFilter filter) {
        ArrayList<Integer> statuses = new ArrayList<Integer>();
        if (filter.isOrdered()) {
            statuses.add(ProductOrderStatus.ORDERED.ordinal());
        }
        if (filter.isPaid()) {
            statuses.add(ProductOrderStatus.PAID.ordinal());
        }
        if (filter.isCanceled()) {
            statuses.add(ProductOrderStatus.CANCELED.ordinal());
        }
        if (filter.isPartial()) {
            statuses.add(ProductOrderStatus.PARTIAL.ordinal());
        }
        if (filter.isError()) {
            statuses.add(ProductOrderStatus.ERROR.ordinal());
        }
        if (filter.isDelivered()) {
            statuses.add(ProductOrderStatus.DELIVERED.ordinal());
        }
        if (filter.isRefunded()) {
            statuses.add(ProductOrderStatus.REFUNDED.ordinal());
        }
        if (filter.isFraud()) {
            statuses.add(ProductOrderStatus.FRAUD.ordinal());
        }
        return statuses;
    }

    private long getStartOfDayMillis(long selectedDate) {
        Calendar selectedDateCalendar = Calendar.getInstance();
        selectedDateCalendar.setTimeInMillis(selectedDate);
        LocalDate date = LocalDate.of(selectedDateCalendar.get(1), selectedDateCalendar.get(2) + 1, selectedDateCalendar.get(5));
        long startTimeOfDay = date.atStartOfDay().toEpochSecond(ZoneOffset.UTC);
        return startTimeOfDay * 1000L;
    }

    private long getEndOfDayMillis(long selectedDate) {
        Calendar selectedDateCalendar = Calendar.getInstance();
        selectedDateCalendar.setTimeInMillis(selectedDate);
        LocalDate date = LocalDate.of(selectedDateCalendar.get(1), selectedDateCalendar.get(2) + 1, selectedDateCalendar.get(5));
        date = date.plus(1L, ChronoUnit.DAYS);
        long startTimeOfDay = date.atStartOfDay().toEpochSecond(ZoneOffset.UTC);
        return startTimeOfDay * 1000L;
    }
}

