/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.component;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ThreadContext;
import org.exoplatform.container.component.ThreadContextHolder;

public class ThreadContextHandler {
    private final ExoContainer container;
    private List<ThreadContext> contexts;

    public ThreadContextHandler(ExoContainer container) {
        this.container = container;
    }

    public void store() {
        ArrayList<ThreadContextHolder> components = new ArrayList<ThreadContextHolder>(this.container.getComponentInstancesOfType(ThreadContextHolder.class));
        for (ExoContainer current = this.container.getParent(); current != null; current = current.getParent()) {
            components.addAll(current.getComponentInstancesOfType(ThreadContextHolder.class));
        }
        this.contexts = new ArrayList<ThreadContext>(components.size());
        int length = components.size();
        for (int i = 0; i < length; ++i) {
            ThreadContextHolder holder = (ThreadContextHolder)components.get(i);
            ThreadContext tc = holder.getThreadContext();
            if (tc == null) continue;
            this.contexts.add(tc);
            tc.store();
        }
    }

    public void push() {
        if (this.contexts == null) {
            throw new IllegalStateException("No values have been set, the store method has not been called or failed");
        }
        int length = this.contexts.size();
        for (int i = 0; i < length; ++i) {
            ThreadContext tc = this.contexts.get(i);
            tc.push();
        }
    }

    public void restore() {
        if (this.contexts == null) {
            throw new IllegalStateException("No values have been set, the store method has not been called or failed");
        }
        int length = this.contexts.size();
        for (int i = 0; i < length; ++i) {
            ThreadContext tc = this.contexts.get(i);
            tc.restore();
        }
        this.contexts.clear();
    }
}

