/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.space.service;

import io.meeds.portal.security.constant.UserRegistrationType;
import io.meeds.portal.security.service.SecuritySettingService;
import io.meeds.social.category.model.Category;
import io.meeds.social.category.service.CategoryService;
import io.meeds.social.space.model.SpaceDirectorySettings;
import io.meeds.social.space.storage.SpaceDirectoryStorage;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.service.LayoutService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SpaceDirectoryService {
    @Autowired
    protected CategoryService categoryService;
    @Autowired
    protected LayoutService layoutService;
    @Autowired
    protected SpaceDirectoryStorage spaceDirectoryStorage;
    @Autowired
    protected SecuritySettingService securitySettingService;

    public void saveSpacesDirectorySettings(String settingName, SpaceDirectorySettings spaceDirectorySettings) {
        this.spaceDirectoryStorage.save(settingName, spaceDirectorySettings);
    }

    public void removeSpacesDirectorySettings(String settingName) {
        this.spaceDirectoryStorage.remove(settingName);
    }

    public boolean canAccessSpacesDirectory(String settingName, List<Long> categoryIds, List<Long> templateIds) {
        if (this.securitySettingService.getRegistrationType() == UserRegistrationType.OPEN) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)settingName)) {
            return false;
        }
        SpaceDirectorySettings spaceDirectorySettings = this.spaceDirectoryStorage.get(settingName);
        if (spaceDirectorySettings == null) {
            return false;
        }
        String pageReference = spaceDirectorySettings.getPageReference();
        if (StringUtils.isBlank((CharSequence)pageReference) || !this.isPagePublicallyAccessible(pageReference)) {
            return false;
        }
        String filterType = spaceDirectorySettings.getFilterType();
        if (StringUtils.equals((CharSequence)filterType, (CharSequence)"category")) {
            if (CollectionUtils.isEmpty((Collection)spaceDirectorySettings.getCategoryIds())) {
                return true;
            }
            if (CollectionUtils.isEmpty(categoryIds)) {
                return false;
            }
            if (CollectionUtils.isEmpty(categoryIds = categoryIds.stream().map(categoryId -> this.categoryService.getCategory(categoryId.longValue())).filter(Objects::nonNull).map(Category::getId).toList())) {
                return false;
            }
            return categoryIds.stream().allMatch(categoryId -> spaceDirectorySettings.getCategoryIds().contains(categoryId) || this.categoryService.getAncestorIds(categoryId.longValue()).stream().anyMatch(ancestorCategoryId -> spaceDirectorySettings.getCategoryIds().contains(ancestorCategoryId)));
        }
        if (StringUtils.equals((CharSequence)filterType, (CharSequence)"template")) {
            if (CollectionUtils.isEmpty((Collection)spaceDirectorySettings.getTemplateIds())) {
                return true;
            }
            if (CollectionUtils.isEmpty(templateIds)) {
                return false;
            }
            return templateIds.stream().allMatch(templateId -> spaceDirectorySettings.getTemplateIds().contains(templateId));
        }
        return true;
    }

    public boolean canAccessSpacesDirectory(String settingName) {
        if (this.securitySettingService.getRegistrationType() == UserRegistrationType.OPEN) {
            return true;
        }
        SpaceDirectorySettings spaceDirectorySettings = this.spaceDirectoryStorage.get(settingName);
        String pageReference = spaceDirectorySettings == null ? null : spaceDirectorySettings.getPageReference();
        return StringUtils.isNotBlank((CharSequence)pageReference) && this.isPagePublicallyAccessible(pageReference);
    }

    public boolean isPagePublicallyAccessible(String pageReference) {
        Page page = this.layoutService.getPage(pageReference);
        return this.isPagePublicallyAccessible(page);
    }

    public boolean isPagePublicallyAccessible(Page page) {
        return page != null && ArrayUtils.isNotEmpty((Object[])page.getAccessPermissions()) && Arrays.stream(page.getAccessPermissions()).anyMatch(permission -> StringUtils.equals((CharSequence)permission, (CharSequence)"Everyone"));
    }
}

