/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.notes.service;

import io.meeds.notes.model.NotePageData;
import io.meeds.social.cms.model.CMSSetting;
import io.meeds.social.cms.service.CMSService;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.pom.data.PageKey;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PageVersion;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.WikiService;

public class NotePageViewService {
    public static final String CMS_CONTENT_TYPE = "notePage";
    private static final Pattern NOTES_ATTACHMENT_URI_PATTERN = Pattern.compile("wikiPage/(\\d*)/(\\d*)\"");
    private static final String DEFAULT_CONTENT_LANG = "";
    private static final Log LOG = ExoLogger.getLogger(NotePageViewService.class);
    private NoteService noteService;
    private WikiService noteBookService;
    private CMSService cmsService;
    private AttachmentService attachmentService;
    private IdentityManager identityManager;
    private UserACL userACL;
    private LocaleConfigService localeConfigService;

    public NotePageViewService(NoteService noteService, WikiService noteBookService, CMSService cmsService, AttachmentService attachmentService, IdentityManager identityManager, UserACL userACL, LocaleConfigService localeConfigService) {
        this.noteService = noteService;
        this.noteBookService = noteBookService;
        this.cmsService = cmsService;
        this.attachmentService = attachmentService;
        this.identityManager = identityManager;
        this.userACL = userACL;
        this.localeConfigService = localeConfigService;
    }

    public Page getNotePage(String name, String lang, Identity currentUserAclIdentity) throws IllegalAccessException {
        CMSSetting setting = this.cmsService.getSetting(CMS_CONTENT_TYPE, name);
        if (setting == null) {
            return null;
        }
        if (!this.cmsService.hasAccessPermission(currentUserAclIdentity, CMS_CONTENT_TYPE, name)) {
            throw new IllegalAccessException("Note page isn't accessible");
        }
        return this.getNotePage(setting, lang);
    }

    public NotePageData getNotePageData(String name) {
        Map<String, Page> pages = this.getNotePages(name);
        NotePageData pageData = new NotePageData();
        pageData.setPages(new HashMap<String, String>());
        pages.entrySet().forEach(e -> pageData.getPages().put((String)e.getKey(), ((Page)e.getValue()).getContent()));
        return pageData;
    }

    public Page savePageData(String name, NotePageData pageData) {
        Map<String, String> pages = pageData.getPages();
        if (MapUtils.isEmpty(pages)) {
            return null;
        }
        String pageContent = pages.get(DEFAULT_CONTENT_LANG);
        Page page = this.saveNotePage(name, pageContent, null, this.userACL.getSuperUser());
        String pageId = page.getId();
        String pageContentReplacement = this.clonePageAttachments(pageId, pageContent);
        if (!StringUtils.equals((CharSequence)pageContentReplacement, (CharSequence)pageContent)) {
            page.setLang(null);
            page.setContent(pageContentReplacement);
            page.setUpdatedDate(new Date());
            this.noteService.updateNote(page, PageUpdateType.EDIT_PAGE_CONTENT);
        }
        pages.forEach((lang, content) -> {
            if (!StringUtils.equals((CharSequence)lang, (CharSequence)page.getLang())) {
                try {
                    page.setContent(this.clonePageAttachments(pageId, (String)content));
                    page.setLang((String)lang);
                    this.noteService.createVersionOfNote(page, this.userACL.getSuperUser());
                }
                catch (Exception e) {
                    LOG.warn("Error saving SNV {} content for lang {}", new Object[]{name, lang, e});
                }
            }
        });
        return page;
    }

    public Map<String, Page> getNotePages(String name) {
        String noteOwner;
        CMSSetting setting = this.cmsService.getSetting(CMS_CONTENT_TYPE, name);
        if (setting == null) {
            return Collections.emptyMap();
        }
        PageKey pageKey = this.getPageKey(setting);
        String noteType = pageKey.getType();
        Page page = this.noteService.getNoteOfNoteBookByName(noteType, noteOwner = pageKey.getId(), name);
        if (page == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Page> pages = new HashMap<String, Page>();
        pages.put(DEFAULT_CONTENT_LANG, page);
        long pageId = Long.parseLong(page.getId());
        List<String> languages = this.noteService.getPageAvailableTranslationLanguages(pageId, false);
        languages.forEach(lang -> {
            Page pageByLang;
            if (!pages.containsKey(lang) && (pageByLang = this.noteService.getNoteByIdAndLang(pageId, (String)lang)) != null) {
                pages.put((String)lang, pageByLang);
            }
        });
        return pages;
    }

    public Page getNotePage(String name, String lang) {
        CMSSetting setting = this.cmsService.getSetting(CMS_CONTENT_TYPE, name);
        if (setting == null) {
            return null;
        }
        return this.getNotePage(setting, lang);
    }

    public Page saveNotePage(String name, String content, String lang, Identity currentUserAclIdentity) throws IllegalAccessException, ObjectNotFoundException {
        if (!this.cmsService.isSettingNameExists(CMS_CONTENT_TYPE, name)) {
            throw new ObjectNotFoundException(String.format("CMS Setting name %s wasn't found", name));
        }
        if (!this.cmsService.hasEditPermission(currentUserAclIdentity, CMS_CONTENT_TYPE, name)) {
            throw new IllegalAccessException("Note page isn't editable");
        }
        return this.saveNotePage(name, content, lang, currentUserAclIdentity.getUserId());
    }

    private Page saveNotePage(String name, String content, String lang, String username) {
        CMSSetting setting = this.cmsService.getSetting(CMS_CONTENT_TYPE, name);
        String pageReference = setting.getPageReference();
        PageKey pageKey = PageKey.create((String)pageReference);
        try {
            Wiki noteBook = this.getNote(pageKey);
            Page page = this.getNotePage(pageKey, name, null);
            if (page == null) {
                page = new Page(name, name);
                page.setContent(content);
                page.setCreatedDate(new Date());
                page.setUpdatedDate(new Date());
                page.setOwner(IdentityConstants.SYSTEM);
                this.noteService.createNote(noteBook, noteBook.getWikiHome(), page);
            } else {
                String defaultLang = this.getDefaultLanguage();
                Page pageWithLang = this.getNotePage(pageKey, name, lang);
                if (pageWithLang == null || StringUtils.isBlank((CharSequence)pageWithLang.getLang()) || StringUtils.equals((CharSequence)defaultLang, (CharSequence)pageWithLang.getLang())) {
                    page.setLang(null);
                    page.setContent(content);
                    page.setUpdatedDate(new Date());
                    page = this.noteService.updateNote(page, PageUpdateType.EDIT_PAGE_CONTENT);
                } else {
                    page.setUpdatedDate(new Date());
                    page = this.noteService.updateNote(page, PageUpdateType.EDIT_PAGE_CONTENT);
                    page.setContent(content);
                    page.setLang(pageWithLang.getLang());
                }
                this.noteService.createVersionOfNote(page, username);
                this.noteService.removeDraftOfNote(page);
            }
            return this.getNotePage(pageKey, name, lang);
        }
        catch (WikiException e) {
            throw new IllegalStateException(String.format("Error retrieving note with name %s referenced in page %s", name, pageKey), e);
        }
    }

    private String clonePageAttachments(String pageId, String pageContent) {
        Matcher matcher = NOTES_ATTACHMENT_URI_PATTERN.matcher(pageContent);
        String pageContentReplacement = pageContent;
        while (matcher.find()) {
            String oldPageId = matcher.group(1);
            String fileId = matcher.group(2);
            try {
                this.createAttachment(pageId, fileId);
                pageContentReplacement = pageContentReplacement.replace(String.format("wikiPage/%s/%s\"", oldPageId, fileId), String.format("wikiPage/%s/%s\"", pageId, fileId));
            }
            catch (Exception e) {
                LOG.warn("Error while creating File attachment {} for page with id {}", new Object[]{fileId, pageId});
            }
        }
        return pageContentReplacement;
    }

    private Wiki getNote(PageKey pageKey) throws WikiException {
        Wiki noteBook = this.noteBookService.getWikiByTypeAndOwner(pageKey.getType(), pageKey.getId());
        if (noteBook == null) {
            return this.noteBookService.createWiki(pageKey.getType(), pageKey.getId());
        }
        return noteBook;
    }

    private Page getNotePage(CMSSetting setting, String lang) {
        PageKey pageKey = this.getPageKey(setting);
        return this.getNotePage(pageKey, setting.getName(), lang);
    }

    private Page getNotePage(PageKey pageKey, String name, String lang) {
        try {
            PageVersion publishedVersion;
            String ownerType = pageKey.getType();
            String ownerName = pageKey.getId();
            Page page = this.noteService.getNoteOfNoteBookByName(ownerType, ownerName, name);
            if (page != null && StringUtils.isNotBlank((CharSequence)lang) && !StringUtils.equals((CharSequence)lang, (CharSequence)page.getLang()) && (publishedVersion = this.noteService.getPublishedVersionByPageIdAndLang(Long.parseLong(page.getId()), lang)) != null) {
                page.setTitle(publishedVersion.getTitle());
                page.setContent(publishedVersion.getContent());
                page.setLang(publishedVersion.getLang());
            }
            return page;
        }
        catch (WikiException e) {
            throw new IllegalStateException(String.format("Error retrieving note with name %s referenced in page %s", name, pageKey), e);
        }
    }

    private PageKey getPageKey(CMSSetting setting) {
        String pageReference = setting.getPageReference();
        return PageKey.create((String)pageReference);
    }

    private String getDefaultLanguage() {
        return this.localeConfigService.getDefaultLocaleConfig().getLocale().toLanguageTag();
    }

    private void createAttachment(String pageId, String fileId) {
        if (this.attachmentService.getAttachment("wikiPage", pageId, fileId) == null) {
            this.attachmentService.createAttachment(fileId, "wikiPage", pageId, null, this.getSuperUserIdentityId(), Collections.emptyMap());
        }
    }

    private long getSuperUserIdentityId() {
        return Long.parseLong(this.identityManager.getOrCreateUserIdentity(this.userACL.getSuperUser()).getId());
    }
}

