/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.crowdin.gamification.services;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.crowdin.gamification.model.Event;
import io.meeds.crowdin.gamification.model.WebHook;
import io.meeds.crowdin.gamification.plugin.CrowdinTriggerPlugin;
import io.meeds.crowdin.gamification.services.CrowdinTriggerService$AjcClosure1;
import io.meeds.crowdin.gamification.storage.WebHookStorage;
import io.meeds.crowdin.gamification.utils.Utils;
import io.meeds.gamification.service.ConnectorService;
import io.meeds.gamification.service.TriggerService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class CrowdinTriggerService {
    private static final Log LOG;
    private final Map<String, CrowdinTriggerPlugin> triggerPlugins = new HashMap<String, CrowdinTriggerPlugin>();
    @Autowired
    private TriggerService triggerService;
    @Autowired
    private ConnectorService connectorService;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private ListenerService listenerService;
    @Autowired
    private WebHookStorage webHookStorage;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public void handleTriggerAsync(String bearerToken, String payload) {
        this.threadPoolTaskExecutor.execute(() -> this.handleTrigger(bearerToken, payload));
    }

    @ContainerTransactional
    public void handleTrigger(String bearerToken, String payload) {
        String string = bearerToken;
        String string2 = payload;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string, (Object)string2);
        Object[] objectArray = new Object[]{this, string, string2, joinPoint};
        CrowdinTriggerService$AjcClosure1 crowdinTriggerService$AjcClosure1 = new CrowdinTriggerService$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(crowdinTriggerService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public void processEvents(List<Event> events, String projectId) {
        events.stream().filter(event -> this.isTriggerEnabled(event.getName(), projectId)).forEach(this::processEvent);
    }

    private boolean isTriggerEnabled(String trigger, String projectId) {
        return this.triggerService.isTriggerEnabledForAccount(trigger, Long.parseLong(projectId));
    }

    private void processEvent(Event event) {
        String receiverId = NumberUtils.isDigits((String)event.getReceiver()) ? event.getReceiver() : this.connectorService.getAssociatedUsername("crowdin", event.getReceiver());
        String senderId = !NumberUtils.isDigits((String)event.getSender()) && event.getSender() != null && !StringUtils.equals((CharSequence)event.getReceiver(), (CharSequence)event.getSender()) ? this.connectorService.getAssociatedUsername("crowdin", event.getSender()) : receiverId;
        LOG.info((Object)("processEvent: senderId: " + senderId));
        if (StringUtils.isNotBlank((CharSequence)senderId)) {
            if (NumberUtils.isDigits((String)senderId)) {
                this.broadcastCrowdinEvent(event, senderId, receiverId);
            } else {
                Identity socialIdentity = this.identityManager.getOrCreateUserIdentity(senderId);
                LOG.info((Object)("processEvent: socialIdentity: " + String.valueOf(socialIdentity)));
                if (socialIdentity != null) {
                    this.broadcastCrowdinEvent(event, senderId, receiverId);
                }
            }
        }
    }

    private void broadcastCrowdinEvent(Event event, String senderId, String receiverId) {
        try {
            String eventDetails = "{projectId: " + event.getProjectId() + ", languageId: " + event.getLanguageId() + ", mustBeHuman: " + event.isMustBeHuman() + ", directoryId: " + event.getDirectoryId() + "}";
            HashMap<String, Object> gam = new HashMap<String, Object>();
            gam.put("senderId", senderId);
            gam.put("receiverId", receiverId);
            gam.put("objectId", event.getObjectId());
            gam.put("objectType", event.getObjectType());
            gam.put("eventDetails", eventDetails);
            gam.put("ruleTitle", event.getName());
            if (!event.isCancelling()) {
                this.listenerService.broadcast("exo.gamification.generic.action", gam, (Object)"");
                LOG.info("Crowdin action {} broadcast for user {}", new Object[]{event.getName(), senderId});
            } else {
                this.listenerService.broadcast("gamification.cancel.event.action", gam, (Object)"");
                LOG.info("Crowdin cancelling action {} broadcast for user {}", new Object[]{event.getName(), senderId});
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot broadcast crowdin event", (Throwable)e);
        }
    }

    private CrowdinTriggerPlugin getCrowdinTriggerPlugin(String trigger) {
        return this.triggerPlugins.get(trigger);
    }

    public void addPlugin(CrowdinTriggerPlugin crowdinTriggerPlugin) {
        this.triggerPlugins.put(crowdinTriggerPlugin.getEventName(), crowdinTriggerPlugin);
        this.triggerPlugins.put(crowdinTriggerPlugin.getCancellingEventName(), crowdinTriggerPlugin);
    }

    static {
        CrowdinTriggerService.ajc$preClinit();
        LOG = ExoLogger.getLogger(CrowdinTriggerService.class);
    }

    static /* synthetic */ void handleTrigger_aroundBody0(CrowdinTriggerService ajc$this, String bearerToken, String payload, JoinPoint joinPoint) {
        Map<String, Object> payloadMap = Utils.fromJsonStringToMap(payload);
        Object eventsObj = payloadMap.get("events");
        List eventsListMap = (List)eventsObj;
        LOG.info((Object)("Total Events: " + eventsListMap.size()));
        for (Map eventMap : eventsListMap) {
            String trigger = Utils.extractSubItem(eventMap, "event");
            CrowdinTriggerPlugin triggerPlugin = ajc$this.getCrowdinTriggerPlugin(trigger);
            if (triggerPlugin == null) {
                LOG.error((Object)("Trigger plugin for trigger : " + trigger + " wasn't found"));
                continue;
            }
            String projectId = triggerPlugin.getProjectId(eventMap);
            if (projectId == null) {
                LOG.error((Object)"Project id is not found in the payload");
                continue;
            }
            WebHook webHook = ajc$this.webHookStorage.getWebhookByProjectId(Long.parseLong(projectId));
            if (webHook == null) {
                LOG.error((Object)("Crowdin hook for project id : " + projectId + " wasn't found"));
                continue;
            }
            if (!Utils.verifyWebhookSecret(bearerToken.substring(7), webHook.getSecret())) {
                LOG.error((Object)"Verifying Crowdin webhook secret failed");
                continue;
            }
            ajc$this.processEvents(triggerPlugin.getEvents(trigger, eventMap), projectId);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CrowdinTriggerService.java", CrowdinTriggerService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "handleTrigger", "io.meeds.crowdin.gamification.services.CrowdinTriggerService", "java.lang.String:java.lang.String", "bearerToken:payload", "", "void"), 78);
    }
}

