/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.crowdin.gamification.plugin;

import io.meeds.crowdin.gamification.plugin.CrowdinEventPlugin;
import java.util.HashMap;
import java.util.List;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.springframework.boot.test.context.SpringBootTest;

@SpringBootTest(classes={CrowdinEventPlugin.class})
public class CrowdinEventPluginTest {
    @Test
    public void testIsValidEvent() {
        CrowdinEventPlugin crowdinEventPlugin = new CrowdinEventPlugin();
        Assertions.assertEquals((Object)"crowdin", (Object)crowdinEventPlugin.getEventType());
        Assertions.assertEquals(List.of("stringCommentCreated", "suggestionAdded", "suggestionApproved", "approveSuggestion"), (Object)crowdinEventPlugin.getTriggers());
        HashMap<String, String> eventProperties = new HashMap<String, String>();
        eventProperties.put("projectId", "132452");
        eventProperties.put("directoryIds", "1115454,2225454");
        eventProperties.put("mustBeHuman", "true");
        Assertions.assertFalse((boolean)crowdinEventPlugin.isValidEvent(eventProperties, "{projectId: 132452, directoryId: 221545, mustBeHuman: true}"));
        Assertions.assertFalse((boolean)crowdinEventPlugin.isValidEvent(eventProperties, "{projectId: 132453, directoryId: 221545, mustBeHuman: true}"));
        Assertions.assertFalse((boolean)crowdinEventPlugin.isValidEvent(eventProperties, "{projectId: 132452, directoryId: 2225454, mustBeHuman: false}"));
        Assertions.assertTrue((boolean)crowdinEventPlugin.isValidEvent(eventProperties, "{projectId: 132452, directoryId: 1115454, mustBeHuman: true}"));
    }
}

