/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.crowdin.gamification.storage;

import io.meeds.crowdin.gamification.dao.WebHookDAO;
import io.meeds.crowdin.gamification.entity.WebhookEntity;
import io.meeds.crowdin.gamification.model.WebHook;
import io.meeds.crowdin.gamification.storage.WebHookStorage;
import java.util.Optional;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={WebHookStorage.class})
@ExtendWith(value={MockitoExtension.class})
public class WebHookStorageTest {
    private static final Long ID = 2L;
    private static final Long PROJECT_ID = 1232L;
    @Autowired
    private WebHookStorage webHookStorage;
    @MockBean
    private WebHookDAO webHookDAO;

    @BeforeEach
    void setup() {
        Mockito.when((Object)this.webHookDAO.save((Object)((WebhookEntity)Mockito.any()))).thenAnswer(invocation -> {
            WebhookEntity entity = (WebhookEntity)invocation.getArgument(0);
            if (entity.getId() == null) {
                entity.setId(ID);
            }
            Mockito.when((Object)this.webHookDAO.findById((Object)ID)).thenReturn(Optional.of(entity));
            Mockito.when((Object)this.webHookDAO.findWebhookEntityByProjectId(PROJECT_ID.longValue())).thenReturn((Object)entity);
            return entity;
        });
        ((WebHookDAO)Mockito.doAnswer(invocation -> {
            WebhookEntity entity = (WebhookEntity)invocation.getArgument(0);
            Mockito.when((Object)this.webHookDAO.findById((Object)entity.getId())).thenReturn(Optional.empty());
            return null;
        }).when((Object)this.webHookDAO)).delete((Object)((WebhookEntity)Mockito.any()));
    }

    @Test
    public void testSaveWebHook() throws Exception {
        WebHook webHook = this.createWebHookInstance();
        WebHook createdWebhook = this.webHookStorage.saveWebHook(webHook);
        Assertions.assertNotNull((Object)createdWebhook);
        Assertions.assertEquals((long)webHook.getProjectId(), (long)createdWebhook.getProjectId());
        Assertions.assertEquals((Object)webHook.getProjectName(), (Object)createdWebhook.getProjectName());
        Assertions.assertEquals((Object)webHook.getEnabled(), (Object)createdWebhook.getEnabled());
        Assertions.assertEquals((long)webHook.getWebhookId(), (long)createdWebhook.getWebhookId());
        Assert.assertThrows(ObjectAlreadyExistsException.class, () -> this.webHookStorage.saveWebHook(createdWebhook));
    }

    @Test
    public void testGetWebHookById() throws Exception {
        WebHook createdWebHook = this.webHookStorage.saveWebHook(this.createWebHookInstance());
        WebHook webHook = this.webHookStorage.getWebHookById(Long.valueOf(createdWebHook.getId()));
        Assertions.assertNotNull((Object)webHook);
        Assertions.assertEquals((long)createdWebHook.getId(), (long)webHook.getId());
        Assertions.assertEquals((Object)createdWebHook.getProjectName(), (Object)webHook.getProjectName());
        Assertions.assertEquals((Object)createdWebHook.getEnabled(), (Object)webHook.getEnabled());
        Assertions.assertEquals((long)createdWebHook.getWebhookId(), (long)webHook.getWebhookId());
    }

    @Test
    public void testDeleteWebHook() throws Exception {
        WebHook createdWebHook = this.webHookStorage.saveWebHook(this.createWebHookInstance());
        WebHook webHook = this.webHookStorage.deleteWebHook(createdWebHook.getProjectId());
        Assertions.assertNotNull((Object)webHook);
    }

    @Test
    public void testGetWebHookByProjectId() throws Exception {
        WebHook createdWebHook = this.webHookStorage.saveWebHook(this.createWebHookInstance());
        WebHook webHook = this.webHookStorage.getWebhookByProjectId(createdWebHook.getProjectId());
        Assertions.assertNotNull((Object)webHook);
        Assertions.assertEquals((long)createdWebHook.getId(), (long)webHook.getId());
        Assertions.assertEquals((Object)createdWebHook.getProjectName(), (Object)webHook.getProjectName());
        Assertions.assertEquals((Object)createdWebHook.getEnabled(), (Object)webHook.getEnabled());
        Assertions.assertEquals((long)createdWebHook.getWebhookId(), (long)webHook.getWebhookId());
    }

    protected WebHook createWebHookInstance() {
        WebHook webHook = new WebHook();
        webHook.setProjectId(PROJECT_ID.longValue());
        webHook.setProjectName("projectName");
        webHook.setWebhookId(1444L);
        webHook.setEnabled(Boolean.valueOf(true));
        webHook.setToken("token");
        webHook.setSecret("secret");
        return webHook;
    }
}

