/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.crowdin.gamification.rest;

import io.meeds.crowdin.gamification.services.CrowdinTriggerService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/crowdin/webhooks"})
@Tag(name="webhooks", description="An endpoint to receive crowdin webhooks")
public class CrowdinWebhookController {
    @Autowired
    private CrowdinTriggerService crowdinTriggerService;

    @PostMapping
    @Operation(summary="Project webhook for Remote Crowdin connector.", description="Project webhook for Remote Crowdin connector.", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok"), @ApiResponse(responseCode="509", description="Internal Server Error")})
    public ResponseEntity<Object> crowdinEvent(@RequestHeader(value="authorization") String bearerToken, @RequestBody String payload) {
        try {
            this.crowdinTriggerService.handleTriggerAsync(bearerToken, payload);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).build();
        }
        catch (Exception e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }
}

