/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.evm.gamification.rest;

import io.meeds.evm.gamification.model.EvmContract;
import io.meeds.evm.gamification.service.EvmBlockchainService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/gamification/connectors/evm/tokens"})
public class EvmTokenController {
    @Autowired
    EvmBlockchainService evmBlockchainService;

    @GetMapping
    @Secured(value={"users"})
    @Operation(summary="Retrieves Token details", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="503", description="Service unavailable")})
    public EvmContract getTokenDetails(@RequestParam(name="contractAddress") String contractAddress, @RequestParam(name="blockchainNetwork") String blockchainNetwork) {
        if (contractAddress == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Contract address is missing");
        }
        if (blockchainNetwork == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Network url is missing");
        }
        return this.evmBlockchainService.getTokenDetails(contractAddress, blockchainNetwork);
    }

    @GetMapping(value={"/type"})
    @Secured(value={"users"})
    @Operation(summary="Retrieves Token type", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="503", description="Service unavailable")})
    public String getTokenType(@RequestParam(name="contractAddress") String contractAddress, @RequestParam(name="blockchainNetwork") String blockchainNetwork) {
        if (contractAddress == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Contract address is missing");
        }
        if (blockchainNetwork == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Network url is missing");
        }
        return this.evmBlockchainService.detectTokenType(blockchainNetwork, contractAddress);
    }
}

