/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.github.services.impl;

import io.meeds.gamification.github.model.RemoteOrganization;
import io.meeds.gamification.github.model.RemoteRepository;
import io.meeds.gamification.github.model.TokenStatus;
import io.meeds.gamification.github.model.WebHook;
import io.meeds.gamification.github.services.GithubConsumerService;
import io.meeds.gamification.github.services.WebhookService;
import io.meeds.gamification.github.storage.WebHookStorage;
import io.meeds.gamification.model.filter.RuleFilter;
import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONObject;

public class WebhookServiceImpl
implements WebhookService {
    private static final Log LOG = ExoLogger.getLogger(WebhookServiceImpl.class);
    private static final Context GITHUB_WEBHOOK_CONTEXT = Context.GLOBAL.id("githubWebhook");
    private static final Scope WATCH_LIMITED_SCOPE = Scope.APPLICATION.id("watchLimited");
    private static final Scope DISABLED_REPOS_SCOPE = Scope.APPLICATION.id("disabledRepos");
    private final SettingService settingService;
    private final WebHookStorage webHookStorage;
    private final GithubConsumerService githubServiceConsumer;
    private final RuleService ruleService;

    public WebhookServiceImpl(SettingService settingService, WebHookStorage webHookStorage, GithubConsumerService githubServiceConsumer, RuleService ruleService) {
        this.settingService = settingService;
        this.webHookStorage = webHookStorage;
        this.githubServiceConsumer = githubServiceConsumer;
        this.ruleService = ruleService;
    }

    @Override
    public List<WebHook> getWebhooks(String currentUser, int offset, int limit, boolean forceUpdate) throws IllegalAccessException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to access gitHub Hooks");
        }
        return this.getWebhooks(offset, limit, forceUpdate);
    }

    @Override
    public WebHook getWebhookId(long webhookId, String username) throws IllegalAccessException, ObjectNotFoundException {
        if (!Utils.isRewardingManager((String)username)) {
            throw new IllegalAccessException("The user is not authorized to access gitHub Hooks");
        }
        WebHook webHook = this.getWebhookId(webhookId);
        if (webHook == null) {
            throw new ObjectNotFoundException("Webhook doesn't exist");
        }
        return webHook;
    }

    @Override
    public WebHook getWebhookId(long webhookId) {
        if (webhookId <= 0L) {
            throw new IllegalArgumentException("Webhook id is mandatory");
        }
        return this.webHookStorage.getWebHookById(webhookId);
    }

    @Override
    public List<WebHook> getWebhooks(int offset, int limit, boolean forceUpdate) {
        if (forceUpdate) {
            this.forceUpdateWebhooks();
        }
        return this.getWebhooks(offset, limit);
    }

    public List<WebHook> getWebhooks(int offset, int limit) {
        List<Long> hooksIds = this.webHookStorage.getWebhookIds(offset, limit);
        return hooksIds.stream().map(this.webHookStorage::getWebHookById).toList();
    }

    @Override
    public int countWebhooks(String currentUser, boolean forceUpdate) throws IllegalAccessException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to access gitHub Hooks");
        }
        if (forceUpdate) {
            this.forceUpdateWebhooks();
        }
        return this.webHookStorage.countWebhooks();
    }

    @Override
    public WebHook createWebhook(String organizationName, String accessToken, String currentUser) throws ObjectAlreadyExistsException, IllegalAccessException, ObjectNotFoundException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to create GitHub hook");
        }
        TokenStatus tokenStatus = this.githubServiceConsumer.checkGitHubTokenStatus(accessToken);
        if (!tokenStatus.isValid()) {
            throw new IllegalAccessException("github.tokenExpiredOrInvalid");
        }
        if (tokenStatus.getRemaining() == 0L) {
            throw new IllegalAccessException("github.tokenRateLimitReached");
        }
        RemoteOrganization remoteOrganization = this.githubServiceConsumer.retrieveRemoteOrganization(organizationName, accessToken);
        WebHook existsWebHook = this.webHookStorage.getWebhookByOrganizationId(remoteOrganization.getId());
        if (existsWebHook != null) {
            throw new ObjectAlreadyExistsException((Object)existsWebHook);
        }
        WebHook webHook = this.githubServiceConsumer.createWebhook(organizationName, io.meeds.gamification.github.utils.Utils.GITHUB_TRIGGERS, accessToken);
        if (webHook != null) {
            webHook.setOrganizationId(remoteOrganization.getId());
            webHook.setWatchedBy(currentUser);
            return this.webHookStorage.saveWebHook(webHook);
        }
        return null;
    }

    @Override
    public void updateWebHookAccessToken(long webHookId, String accessToken, String currentUser) throws IllegalAccessException, ObjectNotFoundException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to access gitHub Hooks");
        }
        if (webHookId <= 0L) {
            throw new IllegalArgumentException("webHook id must be positive");
        }
        WebHook webHook = this.webHookStorage.getWebHookById(webHookId);
        if (webHook == null) {
            throw new ObjectNotFoundException("webhook with id : " + webHookId + " wasn't found");
        }
        this.webHookStorage.updateWebHookAccessToken(webHookId, io.meeds.gamification.github.utils.Utils.encode(accessToken));
    }

    @Override
    public void deleteWebhook(long organizationId, String currentUser) throws IllegalAccessException, ObjectNotFoundException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to delete GitHub hook");
        }
        WebHook webHook = this.webHookStorage.getWebhookByOrganizationId(organizationId);
        if (webHook == null) {
            throw new ObjectNotFoundException("Github hook for organization id : " + organizationId + " wasn't found");
        }
        String response = this.githubServiceConsumer.deleteWebhook(webHook);
        if (response != null) {
            this.deleteWebhook(organizationId);
        }
    }

    public void deleteWebhook(long organizationId) {
        this.webHookStorage.deleteWebHook(organizationId);
        RuleFilter ruleFilter = new RuleFilter(true);
        ruleFilter.setEventType("github");
        ruleFilter.setIncludeDeleted(true);
        List rules = this.ruleService.getRules(ruleFilter, 0, -1);
        rules.stream().filter(r -> !r.getEvent().getProperties().isEmpty() && ((String)r.getEvent().getProperties().get("organizationId")).equals(String.valueOf(organizationId))).forEach(rule -> {
            try {
                rule.setEnabled(false);
                this.ruleService.updateRule(rule);
            }
            catch (ObjectNotFoundException e) {
                LOG.warn("Error while automatically switching rule status. Rule = {} ", new Object[]{rule, e});
            }
        });
    }

    @Override
    public void forceUpdateWebhooks() {
        this.githubServiceConsumer.clearCache();
        List<WebHook> webHook = this.getWebhooks(0, -1);
        webHook.forEach(this::forceUpdateWebhook);
    }

    @Override
    public boolean verifyWebhookSecret(String payload, String signature) {
        JSONObject jsonPayload = new JSONObject(payload);
        JSONObject organization = jsonPayload.getJSONObject("organization");
        long organizationId = organization.getLong("id");
        WebHook webHook = this.webHookStorage.getWebhookByOrganizationId(organizationId);
        if (webHook != null) {
            return io.meeds.gamification.github.utils.Utils.verifySignature(webHook.getSecret(), payload, signature);
        }
        return false;
    }

    @Override
    public boolean isWebHookRepositoryEnabled(String payload) {
        Map<String, Object> payloadMap = io.meeds.gamification.github.utils.Utils.fromJsonStringToMap(payload);
        String organizationId = io.meeds.gamification.github.utils.Utils.extractSubItem(payloadMap, "organization", "id");
        String repositoryId = io.meeds.gamification.github.utils.Utils.extractSubItem(payloadMap, "repository", "id");
        if (organizationId != null && repositoryId != null) {
            return this.isWebHookRepositoryEnabled(Long.parseLong(organizationId), Long.parseLong(repositoryId));
        }
        return true;
    }

    @Override
    public boolean isWebHookRepositoryEnabled(long organizationId, long repositoryId) {
        List<Object> disabledRepositoryList = new ArrayList();
        SettingValue settingValue = this.settingService.get(GITHUB_WEBHOOK_CONTEXT, DISABLED_REPOS_SCOPE, String.valueOf(organizationId));
        if (settingValue != null && settingValue.getValue() != null && StringUtils.isNotBlank((CharSequence)settingValue.getValue().toString())) {
            disabledRepositoryList = Arrays.stream(settingValue.getValue().toString().split(":")).map(Long::parseLong).toList();
        }
        return !disabledRepositoryList.contains(repositoryId);
    }

    @Override
    public void setWebHookRepositoryEnabled(long organizationId, long repositoryId, boolean enabled, String currentUser) throws IllegalAccessException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to update repository status");
        }
        List<Long> disabledRepositoryList = new ArrayList<Long>();
        SettingValue settingValue = this.settingService.get(GITHUB_WEBHOOK_CONTEXT, DISABLED_REPOS_SCOPE, String.valueOf(organizationId));
        if (settingValue != null && settingValue.getValue() != null && StringUtils.isNotBlank((CharSequence)settingValue.getValue().toString())) {
            disabledRepositoryList = Arrays.stream(settingValue.getValue().toString().split(":")).map(Long::parseLong).collect(Collectors.toList());
        }
        if (!enabled) {
            if (!disabledRepositoryList.contains(repositoryId)) {
                disabledRepositoryList.add(repositoryId);
            }
        } else {
            disabledRepositoryList.remove(repositoryId);
        }
        String disabledRepositories = disabledRepositoryList.stream().map(String::valueOf).collect(Collectors.joining(":"));
        this.settingService.set(GITHUB_WEBHOOK_CONTEXT, DISABLED_REPOS_SCOPE, String.valueOf(organizationId), SettingValue.create((String)disabledRepositories));
    }

    @Override
    public boolean isWebHookWatchLimitEnabled(long organizationId) {
        SettingValue settingValue = this.settingService.get(GITHUB_WEBHOOK_CONTEXT, WATCH_LIMITED_SCOPE, String.valueOf(organizationId));
        if (settingValue != null && settingValue.getValue() != null && StringUtils.isNotBlank((CharSequence)settingValue.getValue().toString())) {
            return Boolean.parseBoolean(settingValue.getValue().toString());
        }
        return true;
    }

    @Override
    public void setWebHookWatchLimitEnabled(long organizationId, boolean enabled, String currentUser) throws IllegalAccessException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to update webHook watch limit status");
        }
        this.settingService.set(GITHUB_WEBHOOK_CONTEXT, WATCH_LIMITED_SCOPE, String.valueOf(organizationId), SettingValue.create((Boolean)enabled));
    }

    @Override
    public List<RemoteRepository> retrieveOrganizationRepos(long organizationRemoteId, String currentUser, int page, int perPage, String keyword) throws IllegalAccessException, ObjectNotFoundException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to access organization repositories");
        }
        WebHook webHook = this.webHookStorage.getWebhookByOrganizationId(organizationRemoteId);
        if (webHook == null) {
            throw new ObjectNotFoundException("webhook with organization id '" + organizationRemoteId + "' doesn't exist");
        }
        List<RemoteRepository> remoteRepositories = this.githubServiceConsumer.retrieveOrganizationRepos(webHook, page, perPage, keyword);
        remoteRepositories.forEach(remoteRepository -> remoteRepository.setEnabled(this.isWebHookRepositoryEnabled(webHook.getOrganizationId(), remoteRepository.getId())));
        return remoteRepositories;
    }

    private void forceUpdateWebhook(WebHook webHook) {
        TokenStatus tokenStatus = this.githubServiceConsumer.checkGitHubTokenStatus(webHook.getToken());
        if (!tokenStatus.isValid() || tokenStatus.getRemaining() == 0L) {
            return;
        }
        String response = this.githubServiceConsumer.forceUpdateWebhook(webHook);
        if (response == null) {
            this.webHookStorage.deleteWebHook(webHook.getOrganizationId());
        } else {
            Map<String, Object> resultMap = io.meeds.gamification.github.utils.Utils.fromJsonStringToMap(response);
            List events = (List)resultMap.get("events");
            if (!CollectionUtils.isEqualCollection((Collection)events, webHook.getTriggers())) {
                webHook.setTriggers(events);
                this.webHookStorage.updateWebHook(webHook, true);
            }
        }
    }
}

