/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.github.gamification.services.impl;

import io.meeds.github.gamification.model.RemoteOrganization;
import io.meeds.github.gamification.model.RemoteRepository;
import io.meeds.github.gamification.model.TokenStatus;
import io.meeds.github.gamification.model.WebHook;
import io.meeds.github.gamification.services.GithubConsumerService;
import io.meeds.github.gamification.storage.GithubConsumerStorage;
import java.util.List;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class GithubConsumerServiceImpl
implements GithubConsumerService {
    @Autowired
    private GithubConsumerStorage githubConsumerStorage;

    @Override
    public WebHook createWebhook(String organizationName, String[] triggers, String accessToken) throws IllegalAccessException {
        return this.githubConsumerStorage.createWebhook(organizationName, triggers, accessToken);
    }

    @Override
    public String deleteWebhook(WebHook webHook) {
        return this.githubConsumerStorage.deleteWebhookHook(webHook);
    }

    @Override
    public String forceUpdateWebhook(WebHook webHook) {
        return this.githubConsumerStorage.forceUpdateWebhook(webHook);
    }

    @Override
    public RemoteOrganization retrieveRemoteOrganization(String organizationName, String accessToken) throws ObjectNotFoundException {
        return this.githubConsumerStorage.retrieveRemoteOrganization(organizationName, accessToken);
    }

    @Override
    public List<RemoteRepository> retrieveOrganizationRepos(WebHook webHook, int page, int perPage, String keyword) {
        return this.githubConsumerStorage.retrieveOrganizationRepos(webHook.getOrganizationName(), webHook.getToken(), page, perPage, keyword);
    }

    @Override
    public RemoteOrganization retrieveRemoteOrganization(long organizationId, String accessToken) {
        return this.githubConsumerStorage.retrieveRemoteOrganization(organizationId, accessToken);
    }

    @Override
    public TokenStatus checkGitHubTokenStatus(String token) {
        return this.githubConsumerStorage.checkGitHubTokenStatus(token);
    }
}

