/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.github.gamification.plugin;

import io.meeds.github.gamification.model.Event;
import io.meeds.github.gamification.plugin.GithubTriggerPlugin;
import io.meeds.github.gamification.services.GithubTriggerService;
import io.meeds.github.gamification.utils.Utils;
import jakarta.annotation.PostConstruct;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PullRequestTriggerPlugin
extends GithubTriggerPlugin {
    private static final String NAME = "pull_request";
    @Autowired
    private GithubTriggerService githubTriggerService;

    @PostConstruct
    public void init() {
        this.githubTriggerService.addPlugin(this);
    }

    public String getName() {
        return NAME;
    }

    @Override
    public List<Event> getEvents(Map<String, Object> payload) {
        String userId = Utils.extractSubItem(payload, "sender", "login");
        Object objectId = Utils.extractSubItem(payload, NAME, "html_url");
        if (Objects.equals(Utils.extractSubItem(payload, "action"), "opened")) {
            return Collections.singletonList(new Event("creatPullRequest", null, userId, (String)objectId, "githubPR", Utils.extractSubItem(payload, "organization", "id"), Utils.extractSubItem(payload, "repository", "id")));
        }
        if (Objects.equals(Utils.extractSubItem(payload, "action"), "closed") && !Boolean.parseBoolean(Utils.extractSubItem(payload, NAME, "merged"))) {
            return Collections.singletonList(new Event("closePullRequest", null, userId, (String)objectId, "githubPR", Utils.extractSubItem(payload, "organization", "id"), Utils.extractSubItem(payload, "repository", "id")));
        }
        if (Objects.equals(Utils.extractSubItem(payload, "action"), "review_requested")) {
            String requestedReviewer = Utils.extractSubItem(payload, "requested_reviewer", "login");
            objectId = (String)objectId + "?requestedReviewer=" + requestedReviewer;
            return Collections.singletonList(new Event("requestReviewForPullRequest", null, userId, (String)objectId, "githubPR", Utils.extractSubItem(payload, "organization", "id"), Utils.extractSubItem(payload, "repository", "id")));
        }
        if (Objects.equals(Utils.extractSubItem(payload, "action"), "review_request_removed")) {
            String requestedReviewer = Utils.extractSubItem(payload, "requested_reviewer", "login");
            objectId = (String)objectId + "?requestedReviewer=" + requestedReviewer;
            return Collections.singletonList(new Event("reviewRequestRemoved", null, userId, (String)objectId, "githubPR", Utils.extractSubItem(payload, "organization", "id"), Utils.extractSubItem(payload, "repository", "id")));
        }
        return Collections.emptyList();
    }
}

