/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.github.gamification.plugin;

import io.meeds.github.gamification.model.Event;
import io.meeds.github.gamification.plugin.GithubTriggerPlugin;
import io.meeds.github.gamification.services.GithubTriggerService;
import io.meeds.github.gamification.utils.Utils;
import jakarta.annotation.PostConstruct;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PushCodeTriggerPlugin
extends GithubTriggerPlugin {
    private static final String NAME = "push";
    @Autowired
    private GithubTriggerService githubTriggerService;

    @PostConstruct
    public void init() {
        this.githubTriggerService.addPlugin(this);
    }

    public String getName() {
        return NAME;
    }

    @Override
    public List<Event> getEvents(Map<String, Object> payload) {
        return Collections.singletonList(new Event("pushCode", null, Utils.extractSubItem(payload, "pusher", "name"), Utils.extractSubItem(payload, "head_commit", "url"), null, Utils.extractSubItem(payload, "organization", "id"), Utils.extractSubItem(payload, "repository", "id")));
    }
}

