/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.github.service;

import io.meeds.gamification.github.BaseGithubTest;
import io.meeds.gamification.github.model.RemoteOrganization;
import io.meeds.gamification.github.model.TokenStatus;
import io.meeds.gamification.github.model.WebHook;
import io.meeds.gamification.github.utils.Utils;
import java.util.Arrays;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class WebhookServiceTest
extends BaseGithubTest {
    private static final String ADMIN_USER = "root1";
    private static final String USER = "root";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.registerAdministratorUser(ADMIN_USER);
        this.registerInternalUser(USER);
    }

    @Test
    public void testCreateWebhook() throws Exception {
        Throwable exception = Assert.assertThrows(IllegalAccessException.class, () -> this.webhookService.createWebhook("organizationName", "accessToken", USER));
        WebhookServiceTest.assertEquals((String)"The user is not authorized to create GitHub hook", (String)exception.getMessage());
        TokenStatus tokenStatus = new TokenStatus();
        tokenStatus.setValid(false);
        Mockito.when((Object)this.githubConsumerService.checkGitHubTokenStatus("tokenExpiredOrInvalid")).thenReturn((Object)tokenStatus);
        exception = Assert.assertThrows(IllegalAccessException.class, () -> this.webhookService.createWebhook("organizationName", "tokenExpiredOrInvalid", ADMIN_USER));
        WebhookServiceTest.assertEquals((String)"github.tokenExpiredOrInvalid", (String)exception.getMessage());
        tokenStatus = new TokenStatus();
        tokenStatus.setValid(true);
        tokenStatus.setRemaining(Long.valueOf(0L));
        Mockito.when((Object)this.githubConsumerService.checkGitHubTokenStatus("tokenRateLimitReached")).thenReturn((Object)tokenStatus);
        exception = Assert.assertThrows(IllegalAccessException.class, () -> this.webhookService.createWebhook("organizationName", "tokenRateLimitReached", ADMIN_USER));
        WebhookServiceTest.assertEquals((String)"github.tokenRateLimitReached", (String)exception.getMessage());
        tokenStatus = new TokenStatus();
        tokenStatus.setValid(true);
        tokenStatus.setRemaining(Long.valueOf(0xABBB11L));
        Mockito.when((Object)this.githubConsumerService.checkGitHubTokenStatus("accessToken")).thenReturn((Object)tokenStatus);
        RemoteOrganization remoteOrganization = new RemoteOrganization(1L, "organizationName", "organizationTitle", "description", "avatarUrl");
        Mockito.when((Object)this.githubConsumerService.retrieveRemoteOrganization("organizationName", "accessToken")).thenReturn((Object)remoteOrganization);
        WebHook webhook = new WebHook();
        webhook.setWebhookId(1245L);
        webhook.setOrganizationId(11245L);
        webhook.setOrganizationName("organizationName");
        webhook.setTriggers(Arrays.asList(Utils.GITHUB_TRIGGERS));
        webhook.setEnabled(Boolean.valueOf(true));
        webhook.setToken("accessToken");
        webhook.setSecret("secret");
        Mockito.when((Object)this.githubConsumerService.createWebhook("organizationName", Utils.GITHUB_TRIGGERS, "accessToken")).thenReturn((Object)webhook);
        WebHook createdWebHook = this.webhookService.createWebhook("organizationName", "accessToken", ADMIN_USER);
        WebhookServiceTest.assertNotNull((Object)this.webhookService.getWebhookId(createdWebHook.getId(), ADMIN_USER));
        exception = Assert.assertThrows(IllegalAccessException.class, () -> this.webhookService.getWebhookId(createdWebHook.getId(), USER));
        WebhookServiceTest.assertEquals((String)"The user is not authorized to access gitHub Hooks", (String)exception.getMessage());
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.webhookService.getWebhookId(10L, ADMIN_USER));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.webhookService.getWebhookId(-10L, ADMIN_USER));
        Assert.assertThrows(ObjectAlreadyExistsException.class, () -> this.webhookService.createWebhook("organizationName", "accessToken", ADMIN_USER));
        exception = Assert.assertThrows(IllegalAccessException.class, () -> this.webhookService.updateWebHookAccessToken(createdWebHook.getId(), "newAccessToken", USER));
        WebhookServiceTest.assertEquals((String)"The user is not authorized to access gitHub Hooks", (String)exception.getMessage());
        Assert.assertThrows(IllegalArgumentException.class, () -> this.webhookService.updateWebHookAccessToken(-10L, "newAccessToken", ADMIN_USER));
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.webhookService.updateWebHookAccessToken(10L, "newAccessToken", ADMIN_USER));
        this.webhookService.updateWebHookAccessToken(createdWebHook.getId(), "newAccessToken", ADMIN_USER);
        WebhookServiceTest.assertEquals((String)"newAccessToken", (String)this.webhookService.getWebhookId(createdWebHook.getId(), ADMIN_USER).getToken());
    }

    @Test
    public void testGetWebhooks() throws Exception {
        Throwable exception = Assert.assertThrows(IllegalAccessException.class, () -> this.webhookService.getWebhooks(USER, 0, -1, false));
        WebhookServiceTest.assertEquals((String)"The user is not authorized to access gitHub Hooks", (String)exception.getMessage());
        exception = Assert.assertThrows(IllegalAccessException.class, () -> this.webhookService.countWebhooks(USER, false));
        WebhookServiceTest.assertEquals((String)"The user is not authorized to access gitHub Hooks", (String)exception.getMessage());
        TokenStatus tokenStatus = new TokenStatus();
        tokenStatus.setValid(true);
        tokenStatus.setRemaining(Long.valueOf(0xABBB11L));
        Mockito.when((Object)this.githubConsumerService.checkGitHubTokenStatus("accessToken")).thenReturn((Object)tokenStatus);
        RemoteOrganization remoteOrganization = new RemoteOrganization(1L, "organizationName", "organizationTitle", "description", "avatarUrl");
        RemoteOrganization remoteOrganization1 = new RemoteOrganization(2L, "organizationName1", "organizationTitle1", "description1", "avatarUrl1");
        Mockito.when((Object)this.githubConsumerService.retrieveRemoteOrganization("organizationName", "accessToken")).thenReturn((Object)remoteOrganization);
        Mockito.when((Object)this.githubConsumerService.retrieveRemoteOrganization("organizationName1", "accessToken")).thenReturn((Object)remoteOrganization1);
        WebHook webhook = new WebHook();
        webhook.setWebhookId(1245L);
        webhook.setOrganizationId(11245L);
        webhook.setOrganizationName("organizationName");
        webhook.setTriggers(Arrays.asList(Utils.GITHUB_TRIGGERS));
        webhook.setEnabled(Boolean.valueOf(true));
        webhook.setToken("accessToken");
        webhook.setSecret("secret");
        WebHook webhook1 = new WebHook();
        webhook1.setWebhookId(222545L);
        webhook1.setOrganizationId(888655L);
        webhook1.setOrganizationName("organizationName1");
        webhook1.setTriggers(Arrays.asList(Utils.GITHUB_TRIGGERS));
        webhook1.setEnabled(Boolean.valueOf(true));
        webhook1.setToken("accessToken");
        webhook1.setSecret("secret");
        Mockito.when((Object)this.githubConsumerService.createWebhook("organizationName", Utils.GITHUB_TRIGGERS, "accessToken")).thenReturn((Object)webhook);
        Mockito.when((Object)this.githubConsumerService.createWebhook("organizationName1", Utils.GITHUB_TRIGGERS, "accessToken")).thenReturn((Object)webhook1);
        WebHook webHook = this.webhookService.createWebhook("organizationName", "accessToken", ADMIN_USER);
        this.webhookService.createWebhook("organizationName1", "accessToken", ADMIN_USER);
        WebhookServiceTest.assertNotNull((Object)this.webhookService.getWebhooks(ADMIN_USER, 0, 10, false));
        WebhookServiceTest.assertEquals((int)2, (int)this.webhookService.countWebhooks(ADMIN_USER, false));
        exception = Assert.assertThrows(IllegalAccessException.class, () -> this.webhookService.deleteWebhook(webHook.getOrganizationId(), USER));
        WebhookServiceTest.assertEquals((String)"The user is not authorized to delete GitHub hook", (String)exception.getMessage());
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.webhookService.deleteWebhook(1000L, ADMIN_USER));
        Mockito.when((Object)this.githubConsumerService.deleteWebhook(webHook)).thenReturn((Object)"response");
        this.webhookService.deleteWebhook(webHook.getOrganizationId(), ADMIN_USER);
        WebhookServiceTest.assertNotNull((Object)this.webhookService.getWebhooks(ADMIN_USER, 0, 10, false));
        WebhookServiceTest.assertEquals((int)1, (int)this.webhookService.countWebhooks(ADMIN_USER, false));
    }

    @Test
    public void testIsWebHookRepositoryEnabled() throws Exception {
        String payload = "{\"organization\":{\"id\":\"14524\"},\"repository\":{\"id\":\"555564545\"}}";
        WebhookServiceTest.assertTrue((boolean)this.webhookService.isWebHookRepositoryEnabled(payload));
        Exception exception = (Exception)Assert.assertThrows(IllegalAccessException.class, () -> this.webhookService.setWebHookRepositoryEnabled(14524L, 555564545L, false, USER));
        WebhookServiceTest.assertEquals((String)"The user is not authorized to update repository status", (String)exception.getMessage());
        this.webhookService.setWebHookRepositoryEnabled(14524L, 555564545L, false, ADMIN_USER);
        WebhookServiceTest.assertFalse((boolean)this.webhookService.isWebHookRepositoryEnabled(payload));
        this.webhookService.setWebHookRepositoryEnabled(14524L, 555564545L, true, ADMIN_USER);
        WebhookServiceTest.assertTrue((boolean)this.webhookService.isWebHookRepositoryEnabled(payload));
    }
}

