/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.github.dao;

import io.meeds.gamification.github.entity.WebhookEntity;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.List;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;

public class WebHookDAO
extends GenericDAOJPAImpl<WebhookEntity, Long> {
    public static final String ORGANIZATION_ID = "organizationId";

    public WebhookEntity getWebhookByOrganizationId(long organizationId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GitHubWebhooks.getWebhookByOrganizationId", WebhookEntity.class);
        query.setParameter(ORGANIZATION_ID, (Object)organizationId);
        try {
            return (WebhookEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<Long> getWebhookIds(int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GitHubWebhooks.getWebhookIds", Long.class);
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }
}

