/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.github.gamification.service;

import io.meeds.gamification.model.filter.RuleFilter;
import io.meeds.gamification.service.RuleService;
import io.meeds.github.gamification.model.RemoteOrganization;
import io.meeds.github.gamification.model.TokenStatus;
import io.meeds.github.gamification.model.WebHook;
import io.meeds.github.gamification.services.GithubConsumerService;
import io.meeds.github.gamification.services.WebhookService;
import io.meeds.github.gamification.services.impl.WebhookServiceImpl;
import io.meeds.github.gamification.storage.WebHookStorage;
import io.meeds.github.gamification.utils.Utils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.domain.Pageable;

@SpringBootTest(classes={WebhookServiceImpl.class})
class WebhookServiceTest {
    private static final String ADMIN_USER = "root";
    private static final String USER = "user";
    private static final Pageable PAGEABLE = Pageable.ofSize((int)2);
    @MockBean
    private GithubConsumerService githubConsumerService;
    @MockBean
    private WebHookStorage webHookStorage;
    @MockBean
    private RuleService ruleService;
    @MockBean
    private SettingService settingService;
    @Autowired
    private WebhookService webhookService;

    WebhookServiceTest() {
    }

    @Test
    void testGetWebhooks() throws Exception {
        Throwable exception = Assertions.assertThrows(IllegalAccessException.class, () -> this.webhookService.getWebhooks(USER, PAGEABLE));
        Assertions.assertEquals((Object)"The user is not authorized to access gitHub Hooks", (Object)exception.getMessage());
        this.webhookService.getWebhooks(ADMIN_USER, PAGEABLE);
        ((WebHookStorage)Mockito.verify((Object)this.webHookStorage, (VerificationMode)Mockito.times((int)1))).getWebhooks(PAGEABLE);
    }

    @Test
    void testGetWebhookId() throws Exception {
        Throwable exception = Assertions.assertThrows(IllegalAccessException.class, () -> this.webhookService.getWebhookId(1L, USER));
        Assertions.assertEquals((Object)"The user is not authorized to access gitHub Hooks", (Object)exception.getMessage());
        exception = Assertions.assertThrows(IllegalArgumentException.class, () -> this.webhookService.getWebhookId(0L, ADMIN_USER));
        Assertions.assertEquals((Object)"Webhook id is mandatory", (Object)exception.getMessage());
        Mockito.when((Object)this.webHookStorage.getWebHookById(Long.valueOf(2L))).thenReturn((Object)new WebHook());
        this.webhookService.getWebhookId(2L, ADMIN_USER);
        ((WebHookStorage)Mockito.verify((Object)this.webHookStorage, (VerificationMode)Mockito.times((int)1))).getWebHookById(Long.valueOf(2L));
        Mockito.when((Object)this.webHookStorage.getWebHookById(Long.valueOf(1L))).thenReturn(null);
        exception = Assertions.assertThrows(ObjectNotFoundException.class, () -> this.webhookService.getWebhookId(1L, ADMIN_USER));
        Assertions.assertEquals((Object)"Webhook doesn't exist", (Object)exception.getMessage());
    }

    @Test
    void testCreateWebhook() throws Exception {
        Throwable exception = Assertions.assertThrows(IllegalAccessException.class, () -> this.webhookService.createWebhook("organizationName", "accessToken", USER));
        Assertions.assertEquals((Object)"The user is not authorized to create GitHub hook", (Object)exception.getMessage());
        TokenStatus tokenStatus = new TokenStatus(false, Long.valueOf(12L), Long.valueOf(15454L));
        Mockito.when((Object)this.githubConsumerService.checkGitHubTokenStatus((String)Mockito.any())).thenReturn((Object)tokenStatus);
        exception = Assertions.assertThrows(IllegalAccessException.class, () -> this.webhookService.createWebhook("organizationName", "accessToken", ADMIN_USER));
        Assertions.assertEquals((Object)"github.tokenExpiredOrInvalid", (Object)exception.getMessage());
        tokenStatus.setValid(true);
        tokenStatus.setRemaining(Long.valueOf(0L));
        Mockito.when((Object)this.githubConsumerService.checkGitHubTokenStatus((String)Mockito.any())).thenReturn((Object)tokenStatus);
        exception = Assertions.assertThrows(IllegalAccessException.class, () -> this.webhookService.createWebhook("organizationName", "accessToken", ADMIN_USER));
        Assertions.assertEquals((Object)"github.tokenRateLimitReached", (Object)exception.getMessage());
        RemoteOrganization remoteOrganization = new RemoteOrganization(12345L, "name", "title", "description", "avatarUrl");
        WebHook existsWebHook = new WebHook();
        Mockito.when((Object)this.githubConsumerService.retrieveRemoteOrganization("organizationName", "accessToken")).thenReturn((Object)remoteOrganization);
        Mockito.when((Object)this.webHookStorage.getWebhookByOrganizationId(12345L)).thenReturn((Object)existsWebHook);
        tokenStatus.setRemaining(Long.valueOf(1221544L));
        Mockito.when((Object)this.githubConsumerService.checkGitHubTokenStatus((String)Mockito.any())).thenReturn((Object)tokenStatus);
        Assertions.assertThrows(ObjectAlreadyExistsException.class, () -> this.webhookService.createWebhook("organizationName", "accessToken", ADMIN_USER));
        Mockito.when((Object)this.webHookStorage.getWebhookByOrganizationId(12345L)).thenReturn(null);
        WebHook webHook = new WebHook();
        Mockito.when((Object)this.githubConsumerService.createWebhook("organizationName", Utils.GITHUB_TRIGGERS, "accessToken")).thenReturn((Object)webHook);
        webHook.setOrganizationId(remoteOrganization.getId());
        webHook.setWatchedBy(ADMIN_USER);
        this.webhookService.createWebhook("organizationName", "accessToken", ADMIN_USER);
        ((WebHookStorage)Mockito.verify((Object)this.webHookStorage, (VerificationMode)Mockito.times((int)1))).saveWebHook(webHook);
    }

    @Test
    void testUpdateWebHookAccessToken() throws Exception {
        Throwable exception = Assertions.assertThrows(IllegalAccessException.class, () -> this.webhookService.updateWebHookAccessToken(124L, "accessToken", USER));
        Assertions.assertEquals((Object)"The user is not authorized to access gitHub Hooks", (Object)exception.getMessage());
        exception = Assertions.assertThrows(IllegalArgumentException.class, () -> this.webhookService.updateWebHookAccessToken(0L, "accessToken", ADMIN_USER));
        Assertions.assertEquals((Object)"webHook id must be positive", (Object)exception.getMessage());
        Mockito.when((Object)this.webHookStorage.getWebHookById(Long.valueOf(2L))).thenReturn((Object)new WebHook());
        this.webhookService.updateWebHookAccessToken(2L, "accessToken", ADMIN_USER);
        ((WebHookStorage)Mockito.verify((Object)this.webHookStorage, (VerificationMode)Mockito.times((int)1))).updateWebHookAccessToken(Mockito.anyLong(), Mockito.anyString());
        Mockito.when((Object)this.webHookStorage.getWebHookById(Long.valueOf(1L))).thenReturn(null);
        exception = Assertions.assertThrows(ObjectNotFoundException.class, () -> this.webhookService.updateWebHookAccessToken(1L, "accessToken", ADMIN_USER));
        Assertions.assertEquals((Object)"webhook with id : 1 wasn't found", (Object)exception.getMessage());
    }

    @Test
    void testDeleteWebhook() throws ObjectNotFoundException, IllegalAccessException {
        Throwable exception = Assertions.assertThrows(IllegalAccessException.class, () -> this.webhookService.deleteWebhook(124L, USER));
        Assertions.assertEquals((Object)"The user is not authorized to delete GitHub hook", (Object)exception.getMessage());
        Mockito.when((Object)this.webHookStorage.getWebhookByOrganizationId(124L)).thenReturn(null);
        exception = Assertions.assertThrows(ObjectNotFoundException.class, () -> this.webhookService.deleteWebhook(124L, ADMIN_USER));
        Assertions.assertEquals((Object)"Github hook for organization id : 124 wasn't found", (Object)exception.getMessage());
        WebHook webHook = new WebHook();
        Mockito.when((Object)this.webHookStorage.getWebhookByOrganizationId(124L)).thenReturn((Object)webHook);
        Mockito.when((Object)this.githubConsumerService.deleteWebhook(webHook)).thenReturn((Object)"Deleted");
        this.webhookService.deleteWebhook(124L, ADMIN_USER);
        ((WebHookStorage)Mockito.verify((Object)this.webHookStorage, (VerificationMode)Mockito.times((int)1))).deleteWebHook(124L);
        RuleFilter ruleFilter = new RuleFilter(true);
        ruleFilter.setEventType("github");
        ruleFilter.setIncludeDeleted(true);
        ((RuleService)Mockito.verify((Object)this.ruleService, (VerificationMode)Mockito.times((int)1))).getRules(ruleFilter, 0, -1);
    }

    @Test
    void testVerifyWebhookSecret() {
        String payload = "{\"organization\":{\"id\":\"14524\"},\"repository\":{\"id\":\"555564545\"}}";
        Mockito.when((Object)this.webHookStorage.getWebhookByOrganizationId(14524L)).thenReturn(null);
        Assertions.assertFalse((boolean)this.webhookService.verifyWebhookSecret(payload, "signature"));
    }

    @Test
    void testIsWebHookRepositoryEnabled() throws Exception {
        String payload = "{\"organization\":{\"id\":\"14524\"},\"repository\":{\"id\":\"555564545\"}}";
        Assertions.assertTrue((boolean)this.webhookService.isWebHookRepositoryEnabled(payload));
        Exception exception = (Exception)Assertions.assertThrows(IllegalAccessException.class, () -> this.webhookService.setWebHookRepositoryEnabled(14525L, 555564545L, false, USER));
        Assertions.assertEquals((Object)"The user is not authorized to update repository status", (Object)exception.getMessage());
        this.webhookService.setWebHookRepositoryEnabled(14524L, 555564545L, false, ADMIN_USER);
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)2))).get(Context.GLOBAL.id("githubWebhook"), Scope.APPLICATION.id("disabledRepos"), "14524");
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)1))).set((Context)Mockito.any(), (Scope)Mockito.any(), Mockito.anyString(), (SettingValue)Mockito.any());
        this.webhookService.isWebHookRepositoryEnabled(payload);
        this.webhookService.setWebHookRepositoryEnabled(145211L, 555564545L, true, ADMIN_USER);
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)1))).get(Context.GLOBAL.id("githubWebhook"), Scope.APPLICATION.id("disabledRepos"), "145211");
    }
}

