/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.github.gamification.storage;

import io.meeds.github.gamification.dao.WebHookDAO;
import io.meeds.github.gamification.entity.WebhookEntity;
import io.meeds.github.gamification.model.WebHook;
import io.meeds.github.gamification.storage.mapper.WebHookMapper;
import java.util.Date;
import java.util.List;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository
public class WebHookStorage {
    @Autowired
    private WebHookDAO webHookDAO;

    public WebHook saveWebHook(WebHook webHook) throws ObjectAlreadyExistsException {
        WebHook existsWebHook = this.getWebhookByOrganizationId(webHook.getOrganizationId());
        if (existsWebHook == null) {
            WebhookEntity webhookEntity = WebHookMapper.toEntity(webHook);
            webhookEntity.setWatchedDate(new Date());
            webhookEntity.setUpdatedDate(new Date());
            webhookEntity.setRefreshDate(new Date());
            webhookEntity.setEnabled(true);
            webhookEntity = (WebhookEntity)this.webHookDAO.save(webhookEntity);
            return WebHookMapper.fromEntity(webhookEntity);
        }
        throw new ObjectAlreadyExistsException((Object)existsWebHook);
    }

    public WebHook updateWebHook(WebHook webHook, boolean forceUpdate) {
        WebhookEntity webhookEntity = this.webHookDAO.findById(webHook.getId()).orElse(null);
        if (webhookEntity == null) {
            return null;
        }
        if (forceUpdate) {
            webhookEntity.setRefreshDate(new Date());
            webhookEntity.setTriggers(webHook.getTriggers());
        }
        webhookEntity.setUpdatedDate(new Date());
        return WebHookMapper.fromEntity((WebhookEntity)this.webHookDAO.save(webhookEntity));
    }

    public WebHook updateWebHookAccessToken(long webhookId, String accessToken) {
        WebhookEntity webhookEntity = this.webHookDAO.findById(webhookId).orElse(null);
        if (webhookEntity == null) {
            return null;
        }
        webhookEntity.setToken(accessToken);
        return WebHookMapper.fromEntity((WebhookEntity)this.webHookDAO.save(webhookEntity));
    }

    public WebHook getWebHookById(Long id) {
        return WebHookMapper.fromEntity(this.webHookDAO.findById(id).orElse(null));
    }

    public List<WebHook> getWebhooks() {
        List webhookEntities = this.webHookDAO.findAll();
        return webhookEntities.stream().map(WebHookMapper::fromEntity).toList();
    }

    public Page<WebHook> getWebhooks(Pageable pageable) {
        Page page = this.webHookDAO.findAll(pageable);
        return page.map(WebHookMapper::fromEntity);
    }

    public long countWebhooks() {
        return this.webHookDAO.count();
    }

    public WebHook getWebhookByOrganizationId(long organizationId) {
        WebhookEntity connectorHookEntity = this.webHookDAO.findWebhookEntityByOrganizationId(organizationId);
        return WebHookMapper.fromEntity(connectorHookEntity);
    }

    public WebHook deleteWebHook(long organizationId) {
        WebhookEntity webhookEntity = this.webHookDAO.findWebhookEntityByOrganizationId(organizationId);
        if (webhookEntity != null) {
            this.webHookDAO.delete(webhookEntity);
        }
        return WebHookMapper.fromEntity(webhookEntity);
    }
}

