/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.twitter.gamification.service.impl;

import io.meeds.gamification.model.filter.RuleFilter;
import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.utils.Utils;
import io.meeds.twitter.gamification.model.RemoteTwitterAccount;
import io.meeds.twitter.gamification.model.Tweet;
import io.meeds.twitter.gamification.model.TwitterAccount;
import io.meeds.twitter.gamification.model.TwitterTrigger;
import io.meeds.twitter.gamification.service.TwitterConsumerService;
import io.meeds.twitter.gamification.service.TwitterService;
import io.meeds.twitter.gamification.storage.TwitterAccountStorage;
import io.meeds.twitter.gamification.storage.TwitterTweetStorage;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Primary
@Service
public class TwitterServiceImpl
implements TwitterService {
    private static final Log LOG = ExoLogger.getLogger(TwitterServiceImpl.class);
    public static final String NOT_FOUND = " wasn't found";
    @Autowired
    private TwitterConsumerService twitterConsumerService;
    @Autowired
    private TwitterAccountStorage twitterAccountStorage;
    @Autowired
    private TwitterTweetStorage twitterTweetStorage;
    @Autowired
    private RuleService ruleService;

    @Override
    public Page<TwitterAccount> getTwitterAccounts(String currentUser, Pageable pageable) throws IllegalAccessException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to access Twitter watched accounts");
        }
        return this.getTwitterAccounts(pageable);
    }

    @Override
    public TwitterAccount getTwitterAccountById(long accountId) {
        if (accountId <= 0L) {
            throw new IllegalArgumentException("Twitter account id is mandatory");
        }
        return this.twitterAccountStorage.getTwitterAccountById(accountId);
    }

    @Override
    public TwitterAccount getTwitterAccountById(long accountId, String username) throws IllegalAccessException, ObjectNotFoundException {
        if (!Utils.isRewardingManager((String)username)) {
            throw new IllegalAccessException("The user is not authorized to access Twitter watched account");
        }
        TwitterAccount twitterAccount = this.getTwitterAccountById(accountId);
        if (twitterAccount == null) {
            throw new ObjectNotFoundException("Twitter account doesn't exist");
        }
        return twitterAccount;
    }

    @Override
    public Page<TwitterAccount> getTwitterAccounts(Pageable pageable) {
        return this.twitterAccountStorage.getTwitterAccounts(pageable);
    }

    @Override
    public List<TwitterAccount> getTwitterAccounts() {
        return this.twitterAccountStorage.getTwitterAccounts();
    }

    @Override
    public long countTwitterAccounts(String currentUser) throws IllegalAccessException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to access Twitter watched accounts");
        }
        return this.twitterAccountStorage.countTwitterAccounts();
    }

    @Override
    public TwitterAccount addTwitterAccount(String twitterUsername, String currentUser) throws ObjectAlreadyExistsException, IllegalAccessException, ObjectNotFoundException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to add a twitter watched account");
        }
        if (this.twitterAccountStorage.countTwitterAccounts() >= 2L) {
            throw new IllegalStateException("The maximum number of watched twitter accounts has been reached");
        }
        RemoteTwitterAccount remoteTwitterAccount = this.twitterConsumerService.retrieveTwitterAccount(twitterUsername, this.getTwitterBearerToken(currentUser));
        if (remoteTwitterAccount != null) {
            TwitterAccount existsAccount = this.twitterAccountStorage.getTwitterAccountByRemoteId(remoteTwitterAccount.getId());
            if (existsAccount != null) {
                throw new ObjectAlreadyExistsException((Object)existsAccount);
            }
            TwitterAccount twitterAccount = new TwitterAccount();
            twitterAccount.setIdentifier(remoteTwitterAccount.getUsername());
            twitterAccount.setRemoteId(remoteTwitterAccount.getId());
            twitterAccount.setName(remoteTwitterAccount.getName());
            twitterAccount.setIdentifier(remoteTwitterAccount.getUsername());
            twitterAccount.setWatchedBy(currentUser);
            List<TwitterTrigger> mentionTriggers = this.twitterConsumerService.getMentionEvents(twitterAccount, 0L, this.getTwitterBearerToken());
            if (CollectionUtils.isNotEmpty(mentionTriggers)) {
                twitterAccount.setLastMentionTweetId(mentionTriggers.get(0).getTweetId());
            }
            return this.twitterAccountStorage.addTwitterAccount(twitterAccount);
        }
        return null;
    }

    @Override
    public void deleteTwitterAccount(long twitterAccountId, String currentUser) throws IllegalAccessException, ObjectNotFoundException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to delete Twitter account");
        }
        TwitterAccount twitterAccount = this.twitterAccountStorage.getTwitterAccountById(twitterAccountId);
        if (twitterAccount == null) {
            throw new ObjectNotFoundException("Twitter account with remote id : " + twitterAccountId + NOT_FOUND);
        }
        this.twitterAccountStorage.deleteTwitterAccount(twitterAccountId);
        RuleFilter ruleFilter = new RuleFilter(true);
        ruleFilter.setEventType("twitter");
        ruleFilter.setIncludeDeleted(true);
        List rules = this.ruleService.getRules(ruleFilter, 0, -1);
        rules.stream().filter(r -> !r.getEvent().getProperties().isEmpty() && r.getEvent().getProperties().get("accountId") != null && ((String)r.getEvent().getProperties().get("accountId")).equals(String.valueOf(twitterAccount.getRemoteId()))).forEach(rule -> {
            try {
                rule.setEnabled(false);
                this.ruleService.updateRule(rule);
            }
            catch (ObjectNotFoundException e) {
                LOG.warn("Error while automatically switching rule status. Rule = {} ", new Object[]{rule, e});
            }
        });
    }

    @Override
    public Tweet addTweetToWatch(String tweetLink) {
        Tweet existsTweet = this.twitterTweetStorage.getTweetByLink(tweetLink);
        if (existsTweet != null) {
            return null;
        }
        Tweet tweet = new Tweet();
        tweet.setTweetLink(tweetLink);
        Set<String> tweetLikers = this.twitterConsumerService.retrieveTweetLikers(tweetLink, this.getTwitterBearerToken());
        if (CollectionUtils.isNotEmpty(tweetLikers)) {
            tweet.setLikers(tweetLikers);
        }
        Set<String> tweetRetweeters = this.twitterConsumerService.retrieveTweetRetweeters(tweetLink, this.getTwitterBearerToken());
        if (CollectionUtils.isNotEmpty(tweetLikers)) {
            tweet.setRetweeters(tweetRetweeters);
        }
        return this.twitterTweetStorage.addTweetToWatch(tweet);
    }

    @Override
    public Page<Tweet> getTweets(Pageable pageable) {
        return this.twitterTweetStorage.getTweets(pageable);
    }

    @Override
    public List<Tweet> getTweets() {
        return this.twitterTweetStorage.getTweets();
    }

    @Override
    public long countTweets() {
        return this.twitterTweetStorage.countTweets();
    }

    @Override
    public Tweet getTweetByLink(String tweetLink) {
        if (StringUtils.isBlank((CharSequence)tweetLink)) {
            throw new IllegalArgumentException("Tweet link is mandatory");
        }
        return this.twitterTweetStorage.getTweetByLink(tweetLink);
    }

    @Override
    public void deleteTweet(long tweetId) throws ObjectNotFoundException {
        Tweet tweet = this.twitterTweetStorage.getTweetById(tweetId);
        if (tweet == null) {
            throw new ObjectNotFoundException("Tweet with id : " + tweetId + NOT_FOUND);
        }
        this.twitterTweetStorage.deleteTweet(tweetId);
    }

    @Override
    public void deleteTweetById(long tweetId) {
        try {
            this.deleteTweet(tweetId);
        }
        catch (ObjectNotFoundException e) {
            LOG.debug("Tweet with id {} not found. Continue processing without interrupting current operation.", new Object[]{tweetId, e});
        }
    }

    @Override
    public void saveTwitterBearerToken(String bearerToken, String currentUser) throws IllegalAccessException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to save or update Twitter Bearer Token");
        }
        this.twitterAccountStorage.saveTwitterBearerToken(bearerToken);
    }

    @Override
    public void deleteTwitterBearerToken(String currentUser) throws IllegalAccessException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to delete Twitter Bearer Token");
        }
        this.twitterAccountStorage.deleteTwitterBearerToken();
    }

    @Override
    public String getTwitterBearerToken(String currentUser) throws IllegalAccessException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to check Twitter Bearer Token status");
        }
        return this.getTwitterBearerToken();
    }

    @Override
    public String getTwitterBearerToken() {
        return this.twitterAccountStorage.getTwitterBearerToken();
    }

    @Override
    public void updateAccountLastMentionTweetId(long accountId, long lastMentionTweetId) throws ObjectNotFoundException {
        if (accountId <= 0L) {
            throw new IllegalArgumentException("Account id must be positive");
        }
        TwitterAccount account = this.twitterAccountStorage.getTwitterAccountById(accountId);
        if (account == null) {
            throw new ObjectNotFoundException("Twitter account with id : " + accountId + NOT_FOUND);
        }
        this.twitterAccountStorage.updateAccountLastMentionTweetId(accountId, lastMentionTweetId);
    }

    @Override
    public void updateTweetReactions(long tweetId, Set<String> likers, Set<String> retweeters) throws ObjectNotFoundException {
        if (tweetId <= 0L) {
            throw new IllegalArgumentException("Tweet id must be positive");
        }
        Tweet tweet = this.twitterTweetStorage.getTweetById(tweetId);
        if (tweet == null) {
            throw new ObjectNotFoundException("Tweet with id : " + tweetId + NOT_FOUND);
        }
        this.twitterTweetStorage.updateTweetReactions(tweetId, likers, retweeters);
    }
}

