/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.twitter.gamification.storage;

import io.meeds.twitter.gamification.dao.TwitterAccountDAO;
import io.meeds.twitter.gamification.entity.TwitterAccountEntity;
import io.meeds.twitter.gamification.model.TwitterAccount;
import io.meeds.twitter.gamification.storage.TwitterAccountStorage;
import java.util.List;
import java.util.Optional;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

@SpringBootTest(classes={TwitterAccountStorage.class})
@ExtendWith(value={MockitoExtension.class})
class TwitterAccountStorageTest {
    private static final Long ID = 2L;
    private static final Long REMOTE_ID = 1232L;
    private static final Pageable PAGEABLE = Pageable.ofSize((int)2);
    @Autowired
    private TwitterAccountStorage twitterAccountStorage;
    @MockBean
    private TwitterAccountDAO twitterAccountDAO;
    @MockBean
    private SettingService settingService;
    @MockBean
    private CodecInitializer codecInitializer;

    TwitterAccountStorageTest() {
    }

    @BeforeEach
    void setup() {
        Mockito.when((Object)this.twitterAccountDAO.save((Object)((TwitterAccountEntity)Mockito.any()))).thenAnswer(invocation -> {
            TwitterAccountEntity entity = (TwitterAccountEntity)invocation.getArgument(0);
            if (entity.getId() == null) {
                entity.setId(ID);
            }
            Mockito.when((Object)this.twitterAccountDAO.findById((Object)ID)).thenReturn(Optional.of(entity));
            Mockito.when((Object)this.twitterAccountDAO.findTwitterAccountEntityByRemoteId(REMOTE_ID.longValue())).thenReturn((Object)entity);
            Mockito.when((Object)this.twitterAccountDAO.findAll(PAGEABLE)).thenReturn((Object)new PageImpl(List.of(entity)));
            Mockito.when((Object)this.twitterAccountDAO.count()).thenReturn((Object)1L);
            return entity;
        });
        ((TwitterAccountDAO)Mockito.doAnswer(invocation -> {
            TwitterAccountEntity entity = (TwitterAccountEntity)invocation.getArgument(0);
            Mockito.when((Object)this.twitterAccountDAO.findById((Object)entity.getId())).thenReturn(Optional.empty());
            return null;
        }).when((Object)this.twitterAccountDAO)).delete((Object)((TwitterAccountEntity)Mockito.any()));
    }

    @Test
    void testAddTwitterAccount() throws Exception {
        TwitterAccount twitterAccount = this.createTwitterAccountInstance();
        TwitterAccount createdTwitterAccount = this.twitterAccountStorage.addTwitterAccount(twitterAccount);
        Assertions.assertNotNull((Object)createdTwitterAccount);
        Assertions.assertEquals((Object)twitterAccount.getName(), (Object)createdTwitterAccount.getName());
        Assertions.assertEquals((Object)twitterAccount.getIdentifier(), (Object)createdTwitterAccount.getIdentifier());
        Assertions.assertEquals((long)twitterAccount.getRemoteId(), (long)createdTwitterAccount.getRemoteId());
        Assert.assertThrows(ObjectAlreadyExistsException.class, () -> this.twitterAccountStorage.addTwitterAccount(twitterAccount));
    }

    @Test
    void testGetTwitterAccounts() throws Exception {
        TwitterAccount twitterAccount = this.createTwitterAccountInstance();
        TwitterAccount createdTwitterAccount = this.twitterAccountStorage.addTwitterAccount(twitterAccount);
        Assertions.assertNotNull((Object)createdTwitterAccount);
        Assertions.assertEquals((Object)new PageImpl(List.of(createdTwitterAccount)), (Object)this.twitterAccountStorage.getTwitterAccounts(PAGEABLE));
        Assertions.assertEquals((long)1L, (long)this.twitterAccountStorage.countTwitterAccounts());
    }

    @Test
    void testUpdateAccountLastMentionTweetId() throws Exception {
        TwitterAccount twitterAccount = this.createTwitterAccountInstance();
        TwitterAccount account = this.twitterAccountStorage.updateAccountLastMentionTweetId(10L, 122121L);
        Assertions.assertNull((Object)account);
        TwitterAccount createdTwitterAccount = this.twitterAccountStorage.addTwitterAccount(twitterAccount);
        account = this.twitterAccountStorage.updateAccountLastMentionTweetId(createdTwitterAccount.getId(), 122121L);
        Assertions.assertNotNull((Object)account);
        Assertions.assertEquals((Object)createdTwitterAccount.getIdentifier(), (Object)account.getIdentifier());
        Assertions.assertEquals((long)createdTwitterAccount.getRemoteId(), (long)account.getRemoteId());
        Assertions.assertEquals((long)122121L, (long)account.getLastMentionTweetId());
    }

    @Test
    void testGetTwitterAccountById() throws Exception {
        TwitterAccount createdTwitterAccount = this.twitterAccountStorage.addTwitterAccount(this.createTwitterAccountInstance());
        TwitterAccount twitterAccount = this.twitterAccountStorage.getTwitterAccountById(Long.valueOf(createdTwitterAccount.getId()));
        Assertions.assertNotNull((Object)twitterAccount);
        Assertions.assertEquals((Object)createdTwitterAccount.getName(), (Object)twitterAccount.getName());
        Assertions.assertEquals((Object)createdTwitterAccount.getIdentifier(), (Object)twitterAccount.getIdentifier());
        Assertions.assertEquals((long)createdTwitterAccount.getRemoteId(), (long)twitterAccount.getRemoteId());
    }

    @Test
    void testDeleteTwitterAccount() throws Exception {
        TwitterAccount createdTwitterAccount = this.twitterAccountStorage.addTwitterAccount(this.createTwitterAccountInstance());
        TwitterAccount twitterAccount = this.twitterAccountStorage.deleteTwitterAccount(createdTwitterAccount.getId());
        Assertions.assertNotNull((Object)twitterAccount);
    }

    @Test
    void testGetTwitterAccountByRemoteId() throws Exception {
        TwitterAccount createdTwitterAccount = this.twitterAccountStorage.addTwitterAccount(this.createTwitterAccountInstance());
        TwitterAccount twitterAccount = this.twitterAccountStorage.getTwitterAccountByRemoteId(createdTwitterAccount.getRemoteId());
        Assertions.assertNotNull((Object)twitterAccount);
        Assertions.assertEquals((Object)createdTwitterAccount.getName(), (Object)twitterAccount.getName());
        Assertions.assertEquals((Object)createdTwitterAccount.getIdentifier(), (Object)twitterAccount.getIdentifier());
        Assertions.assertEquals((long)createdTwitterAccount.getRemoteId(), (long)twitterAccount.getRemoteId());
    }

    protected TwitterAccount createTwitterAccountInstance() {
        TwitterAccount twitterAccount = new TwitterAccount();
        twitterAccount.setIdentifier("twitterIdentifier");
        twitterAccount.setName("twitterName");
        twitterAccount.setRemoteId(REMOTE_ID.longValue());
        return twitterAccount;
    }
}

