/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.twitter.gamification.web;

import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.github.scribejava.core.pkce.PKCE;
import com.github.scribejava.core.pkce.PKCECodeChallengeMethod;
import io.meeds.gamification.model.RemoteConnectorSettings;
import io.meeds.gamification.service.ConnectorSettingService;
import io.meeds.twitter.gamification.model.TwitterOAuth20Api;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/"})
public class TwitterConnectionFilter {
    private OAuth20Service oAuthService;
    private long remoteConnectorId;

    @GetMapping(value={"/oauth"})
    public ModelAndView redirectToAuthorization() {
        ConnectorSettingService connectorSettingService = (ConnectorSettingService)CommonsUtils.getService(ConnectorSettingService.class);
        RemoteConnectorSettings remoteConnectorSettings = connectorSettingService.getConnectorSettings("twitter");
        remoteConnectorSettings.setSecretKey(connectorSettingService.getConnectorSecretKey("twitter"));
        if (StringUtils.isBlank((CharSequence)remoteConnectorSettings.getApiKey()) || StringUtils.isBlank((CharSequence)remoteConnectorSettings.getSecretKey())) {
            return new ModelAndView("errorPage");
        }
        String authorizationUrl = this.getAuthorizationUrl(remoteConnectorSettings);
        return new ModelAndView("redirect:" + authorizationUrl);
    }

    private OAuth20Service getOAuthService(RemoteConnectorSettings remoteConnectorSettings) {
        if (this.oAuthService == null || (long)remoteConnectorSettings.hashCode() != this.remoteConnectorId) {
            this.remoteConnectorId = remoteConnectorSettings.hashCode();
            this.oAuthService = new ServiceBuilder(remoteConnectorSettings.getApiKey()).apiSecret(remoteConnectorSettings.getSecretKey()).callback(remoteConnectorSettings.getRedirectUrl()).defaultScope("users.read tweet.read").build((DefaultApi20)TwitterOAuth20Api.instance());
        }
        return this.oAuthService;
    }

    private String getAuthorizationUrl(RemoteConnectorSettings remoteConnectorSettings) {
        String secretState = "state";
        PKCE pkce = new PKCE();
        pkce.setCodeChallenge("challenge");
        pkce.setCodeChallengeMethod(PKCECodeChallengeMethod.PLAIN);
        pkce.setCodeVerifier("challenge");
        return this.getOAuthService(remoteConnectorSettings).createAuthorizationUrlBuilder().pkce(pkce).state(secretState).build();
    }
}

