/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.twitter.gamification.listener;

import io.meeds.gamification.model.EventDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.filter.RuleFilter;
import io.meeds.gamification.service.RuleService;
import io.meeds.twitter.gamification.listener.RuleUpdateTwitterListener;
import io.meeds.twitter.gamification.model.Tweet;
import io.meeds.twitter.gamification.service.TwitterService;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.domain.PageImpl;

@SpringBootTest(classes={RuleUpdateTwitterListener.class})
class RuleUpdateTwitterListenerTest {
    @MockBean
    private TwitterService twitterAccountService;
    @MockBean
    private RuleService ruleService;
    @MockBean
    private ListenerService listenerService;
    @MockBean
    private RuleDTO rule;
    @MockBean
    private Tweet tweet;
    @MockBean
    private Event<RuleDTO, String> event;
    @Autowired
    private RuleUpdateTwitterListener ruleUpdateTwitterListener;

    RuleUpdateTwitterListenerTest() {
    }

    @Test
    void createEvent() {
        EventDTO eventDTO = new EventDTO();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("tweetLink", "tweetLink");
        eventDTO.setProperties(properties);
        Mockito.when((Object)this.rule.getEvent()).thenReturn((Object)eventDTO);
        Mockito.when((Object)this.ruleService.getRules((RuleFilter)Mockito.any(RuleFilter.class), Mockito.anyInt(), Mockito.anyInt())).thenReturn(List.of(this.rule));
        Mockito.when((Object)this.twitterAccountService.getTweets(null)).thenReturn((Object)new PageImpl(List.of(this.tweet)));
        Mockito.when((Object)this.twitterAccountService.getTwitterBearerToken()).thenReturn((Object)"bearerToken");
        this.ruleUpdateTwitterListener.onEvent(this.event);
        ((TwitterService)Mockito.verify((Object)this.twitterAccountService, (VerificationMode)Mockito.times((int)1))).addTweetToWatch("tweetLink");
    }
}

