/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.twitter.gamification.service;

import io.meeds.gamification.model.filter.RuleFilter;
import io.meeds.gamification.service.RuleService;
import io.meeds.twitter.gamification.model.RemoteTwitterAccount;
import io.meeds.twitter.gamification.model.Tweet;
import io.meeds.twitter.gamification.model.TwitterAccount;
import io.meeds.twitter.gamification.model.TwitterTrigger;
import io.meeds.twitter.gamification.service.TwitterConsumerService;
import io.meeds.twitter.gamification.service.TwitterService;
import io.meeds.twitter.gamification.service.impl.TwitterServiceImpl;
import io.meeds.twitter.gamification.storage.TwitterAccountStorage;
import io.meeds.twitter.gamification.storage.TwitterTweetStorage;
import java.util.ArrayList;
import java.util.Set;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.gatein.common.util.Tools;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.domain.Pageable;

@SpringBootTest(classes={TwitterServiceImpl.class})
class TwitterServiceTest {
    private static final String ADMIN_USER = "root";
    private static final String USER = "user";
    private static final Pageable PAGEABLE = Pageable.ofSize((int)2);
    @MockBean
    private TwitterConsumerService twitterConsumerService;
    @MockBean
    private TwitterAccountStorage twitterAccountStorage;
    @MockBean
    private TwitterTweetStorage twitterTweetStorage;
    @MockBean
    private RuleService ruleService;
    @Autowired
    private TwitterService twitterService;

    TwitterServiceTest() {
    }

    @Test
    void testAddTwitterAccount() throws Exception {
        Throwable exception = Assertions.assertThrows(IllegalAccessException.class, () -> this.twitterService.addTwitterAccount("twitterUsername", USER));
        Assertions.assertEquals((Object)"The user is not authorized to add a twitter watched account", (Object)exception.getMessage());
        Mockito.when((Object)this.twitterAccountStorage.countTwitterAccounts()).thenReturn((Object)2L);
        exception = Assertions.assertThrows(IllegalStateException.class, () -> this.twitterService.addTwitterAccount("twitterUsername", ADMIN_USER));
        Assertions.assertEquals((Object)"The maximum number of watched twitter accounts has been reached", (Object)exception.getMessage());
        RemoteTwitterAccount remoteTwitterAccount = new RemoteTwitterAccount(1L, "username", "name", "description", "avatarUrl");
        Mockito.when((Object)this.twitterConsumerService.retrieveTwitterAccount(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)remoteTwitterAccount);
        ArrayList<TwitterTrigger> twitterTriggers = new ArrayList<TwitterTrigger>();
        TwitterTrigger twitterTrigger = new TwitterTrigger("mentionAccount", "user1", 1254555L, "tweet", 11222121L);
        TwitterTrigger twitterTrigger1 = new TwitterTrigger("mentionAccount", "user2", 12548855L, "tweet", 11222121L);
        twitterTriggers.add(twitterTrigger);
        twitterTriggers.add(twitterTrigger1);
        Mockito.when((Object)this.twitterConsumerService.getMentionEvents((TwitterAccount)Mockito.any(), Mockito.anyLong(), Mockito.anyString())).thenReturn(twitterTriggers);
        Mockito.when((Object)this.twitterAccountStorage.countTwitterAccounts()).thenReturn((Object)0L);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.twitterService.getTwitterAccounts(USER, PAGEABLE));
        Assertions.assertThrows(IllegalAccessException.class, () -> this.twitterService.countTwitterAccounts(USER));
        ((TwitterAccountStorage)Mockito.verify((Object)this.twitterAccountStorage, (VerificationMode)Mockito.times((int)1))).countTwitterAccounts();
        this.twitterService.getTwitterAccountById(1L);
        ((TwitterAccountStorage)Mockito.verify((Object)this.twitterAccountStorage, (VerificationMode)Mockito.times((int)1))).getTwitterAccountById(Long.valueOf(1L));
        Assertions.assertThrows(IllegalAccessException.class, () -> this.twitterService.getTwitterAccountById(1L, USER));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.twitterService.getTwitterAccountById(-10L));
        Mockito.when((Object)this.twitterAccountStorage.getTwitterAccountById(Long.valueOf(10L))).thenReturn(null);
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.twitterService.getTwitterAccountById(10L, ADMIN_USER));
        TwitterAccount twitterAccount = new TwitterAccount();
        Mockito.when((Object)this.twitterAccountStorage.getTwitterAccountById(Long.valueOf(20L))).thenReturn((Object)twitterAccount);
        Assertions.assertNotNull((Object)this.twitterService.getTwitterAccountById(20L, ADMIN_USER));
    }

    @Test
    void testDeleteTwitterAccount() throws Exception {
        Throwable exception = Assertions.assertThrows(IllegalAccessException.class, () -> this.twitterService.deleteTwitterAccount(1L, USER));
        Assertions.assertEquals((Object)"The user is not authorized to delete Twitter account", (Object)exception.getMessage());
        Mockito.when((Object)this.twitterAccountStorage.getTwitterAccountById(Long.valueOf(1L))).thenReturn(null);
        exception = Assertions.assertThrows(ObjectNotFoundException.class, () -> this.twitterService.deleteTwitterAccount(1L, ADMIN_USER));
        Assertions.assertEquals((Object)"Twitter account with remote id : 1 wasn't found", (Object)exception.getMessage());
        Mockito.when((Object)this.twitterAccountStorage.getTwitterAccountById(Long.valueOf(2L))).thenReturn((Object)new TwitterAccount());
        this.twitterService.deleteTwitterAccount(2L, ADMIN_USER);
        ((TwitterAccountStorage)Mockito.verify((Object)this.twitterAccountStorage, (VerificationMode)Mockito.times((int)1))).deleteTwitterAccount(2L);
        RuleFilter ruleFilter = new RuleFilter(true);
        ruleFilter.setEventType("twitter");
        ruleFilter.setIncludeDeleted(true);
        ((RuleService)Mockito.verify((Object)this.ruleService, (VerificationMode)Mockito.times((int)1))).getRules(ruleFilter, 0, -1);
    }

    @Test
    void testSaveTwitterBearerToken() throws Exception {
        Throwable exception = Assertions.assertThrows(IllegalAccessException.class, () -> this.twitterService.saveTwitterBearerToken("bearerToken", USER));
        Assertions.assertEquals((Object)"The user is not authorized to save or update Twitter Bearer Token", (Object)exception.getMessage());
        this.twitterService.saveTwitterBearerToken("bearerToken", ADMIN_USER);
        ((TwitterAccountStorage)Mockito.verify((Object)this.twitterAccountStorage, (VerificationMode)Mockito.times((int)1))).saveTwitterBearerToken("bearerToken");
    }

    @Test
    void testAddTweetToWatch() {
        Set tweetLikers = Tools.toSet((Object[])new String[]{"user1", "user2", "user3"});
        Set tweetRetweeters = Tools.toSet((Object[])new String[]{"user1", "user2"});
        Tweet tweet = new Tweet();
        Mockito.when((Object)this.twitterTweetStorage.getTweetByLink("existTweetLink")).thenReturn((Object)tweet);
        Assertions.assertNull((Object)this.twitterService.addTweetToWatch("existTweetLink"));
        Mockito.when((Object)this.twitterTweetStorage.getTweetByLink("tweetLink")).thenReturn(null);
        Mockito.when((Object)this.twitterConsumerService.retrieveTweetLikers("tweetLink", "bearerToken")).thenReturn((Object)tweetLikers);
        Mockito.when((Object)this.twitterConsumerService.retrieveTweetRetweeters("tweetLink", "bearerToken")).thenReturn((Object)tweetRetweeters);
        this.twitterService.addTweetToWatch("tweetLink");
        ((TwitterTweetStorage)Mockito.verify((Object)this.twitterTweetStorage, (VerificationMode)Mockito.times((int)1))).addTweetToWatch((Tweet)Mockito.any());
    }
}

