/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.twitter.gamification.storage.mapper;

import io.meeds.gamification.utils.Utils;
import io.meeds.twitter.gamification.entity.TwitterAccountEntity;
import io.meeds.twitter.gamification.model.TwitterAccount;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.social.core.manager.IdentityManager;

public class TwitterAccountMapper {
    private TwitterAccountMapper() {
    }

    public static TwitterAccountEntity toEntity(TwitterAccount twitterAccount) {
        if (twitterAccount == null) {
            return null;
        }
        TwitterAccountEntity twitterAccountEntity = new TwitterAccountEntity();
        if (twitterAccount.getId() > 0L) {
            twitterAccountEntity.setId(twitterAccount.getId());
        }
        if (twitterAccount.getRemoteId() > 0L) {
            twitterAccountEntity.setRemoteId(twitterAccount.getRemoteId());
        }
        if (StringUtils.isNotEmpty((CharSequence)twitterAccount.getIdentifier())) {
            twitterAccountEntity.setIdentifier(twitterAccount.getIdentifier());
        }
        if (StringUtils.isNotEmpty((CharSequence)twitterAccount.getName())) {
            twitterAccountEntity.setName(twitterAccount.getName());
        }
        if (twitterAccount.getWatchedBy() != null) {
            IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
            String userIdentityId = identityManager.getOrCreateUserIdentity(twitterAccount.getWatchedBy()).getId();
            twitterAccountEntity.setWatchedBy(Long.parseLong(userIdentityId));
        }
        if (twitterAccount.getLastMentionTweetId() > 0L) {
            twitterAccountEntity.setLastMentionTweetId(twitterAccount.getLastMentionTweetId());
        }
        return twitterAccountEntity;
    }

    public static TwitterAccount fromEntity(TwitterAccountEntity twitterAccountEntity) {
        if (twitterAccountEntity == null) {
            return null;
        }
        String watchedBy = null;
        if (twitterAccountEntity.getWatchedBy() != null) {
            IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
            watchedBy = identityManager.getIdentity(String.valueOf(twitterAccountEntity.getWatchedBy())).getRemoteId();
        }
        return new TwitterAccount(twitterAccountEntity.getId(), twitterAccountEntity.getRemoteId(), twitterAccountEntity.getIdentifier(), twitterAccountEntity.getName(), twitterAccountEntity.getWatchedDate() != null ? Utils.toSimpleDateFormat((Date)twitterAccountEntity.getWatchedDate()) : null, watchedBy, twitterAccountEntity.getUpdatedDate() != null ? Utils.toSimpleDateFormat((Date)twitterAccountEntity.getUpdatedDate()) : null, twitterAccountEntity.getRefreshDate() != null ? Utils.toSimpleDateFormat((Date)twitterAccountEntity.getRefreshDate()) : null, twitterAccountEntity.getLastMentionTweetId() != null ? twitterAccountEntity.getLastMentionTweetId() : 0L);
    }
}

