/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.rest;

import io.meeds.gamification.constant.IdentityType;
import io.meeds.gamification.constant.Period;
import io.meeds.gamification.constant.PeriodType;
import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.model.filter.RealizationFilter;
import io.meeds.gamification.rest.builder.RealizationBuilder;
import io.meeds.gamification.rest.model.RealizationList;
import io.meeds.gamification.rest.model.RealizationRestEntity;
import io.meeds.gamification.service.ProgramService;
import io.meeds.gamification.service.RealizationService;
import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.utils.Utils;
import io.meeds.portal.security.service.SecuritySettingService;
import io.meeds.social.translation.service.TranslationService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.rest.http.PATCH;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.common.xmlprocessor.XMLProcessor;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.rest.api.RestUtils;

@Path(value="/gamification/realizations")
@Tag(name="/gamification/realizations", description="Manages users realizations")
public class RealizationRest
implements ResourceContainer {
    private ProgramService programService;
    private RuleService ruleService;
    private RealizationService realizationService;
    private IdentityManager identityManager;
    private TranslationService translationService;
    private SecuritySettingService securitySettingService;
    private XMLProcessor xmlProcessor;
    private UserACL userAcl;

    public RealizationRest(ProgramService programService, RuleService ruleService, TranslationService translationService, RealizationService realizationService, IdentityManager identityManager, SecuritySettingService securitySettingService, XMLProcessor xmlProcessor, UserACL userAcl) {
        this.programService = programService;
        this.ruleService = ruleService;
        this.translationService = translationService;
        this.realizationService = realizationService;
        this.identityManager = identityManager;
        this.securitySettingService = securitySettingService;
        this.xmlProcessor = xmlProcessor;
        this.userAcl = userAcl;
    }

    @GET
    @Produces(value={"application/json", "application/vnd.ms-excel", "text/plain"})
    @Operation(summary="Retrieves the list of achievements switch a filter. The returned format can be of type JSON or XLSX", method="GET", description="Retrieves the list of achievements switch a filter. The returned format can be of type JSON or XLSX")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getRealizations(@Context HttpServletRequest request, @Parameter(description="result fromDate", required=true) @QueryParam(value="fromDate") String fromDateRfc3339, @Parameter(description="result toDate", required=true) @QueryParam(value="toDate") String toDateRfc3339, @Parameter(description="Sort field. Possible values: date or actionType.") @QueryParam(value="sortBy") @DefaultValue(value="date") String sortField, @Parameter(description="Whether to retrieve results sorted descending or not") @QueryParam(value="sortDescending") @DefaultValue(value="true") boolean sortDescending, @Parameter(description="earnerIds, that will be used to filter achievements", required=false) @QueryParam(value="earnerIds") List<String> earnerIds, @Parameter(description="Offset of result") @DefaultValue(value="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit of result") @QueryParam(value="limit") int limit, @Parameter(description="Response content Type. Either xlsx or json. Default value: json") @DefaultValue(value="json") @QueryParam(value="returnType") String returnType, @Parameter(description="Earner type, either USER or SPACE. Default: USER", required=false) @DefaultValue(value="USER") @QueryParam(value="identityType") IdentityType identityType, @Parameter(description="Realization status. Possible values: ACCEPTED, PENDING, REJECTED, CANCELED, DELETED", required=false) @QueryParam(value="status") RealizationStatus status, @Parameter(description="Program technical identifiers. that will be used to filter achievements", required=false) @QueryParam(value="programIds") List<Long> programIds, @Parameter(description="Rule technical identifiers that will be used to filter achievements", required=false) @QueryParam(value="ruleIds") List<Long> ruleIds, @Parameter(description="reviewerIds, that will be used to filter achievements") @QueryParam(value="reviewerIds") List<Long> reviewerIds, @Parameter(description="If true, this will return the list of realizations, the current user can manage. Possible values = true or false. Default value = false.", required=false) @QueryParam(value="owned") @DefaultValue(value="false") boolean owned, @Parameter(description="If true, this will return all realizations, even the ones where user can't access, will be retrieved by anonymizing the associated program and rule", required=false) @QueryParam(value="allPrograms") @DefaultValue(value="false") boolean allPrograms, @Parameter(description="If true, this will return the total count of filtered realizations. Possible values = true or false. Default value = false.", required=false) @QueryParam(value="returnSize") @DefaultValue(value="false") boolean returnSize) {
        boolean isXlsx;
        if (!Utils.canAccessAnonymousResources(this.securitySettingService)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (limit == 0 && (StringUtils.isBlank((CharSequence)fromDateRfc3339) || StringUtils.isBlank((CharSequence)toDateRfc3339))) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Either use limit or dates to limit returned results").build();
        }
        ConversationState conversationState = ConversationState.getCurrent();
        Identity identity = conversationState == null ? null : conversationState.getIdentity();
        Date fromDate = Utils.parseRFC3339Date(fromDateRfc3339);
        Date toDate = Utils.parseRFC3339Date(toDateRfc3339);
        RealizationFilter filter = new RealizationFilter(earnerIds, sortField, sortDescending, owned, fromDate, toDate, status, identityType, programIds, ruleIds, reviewerIds, allPrograms);
        boolean bl = isXlsx = StringUtils.isNotBlank((CharSequence)returnType) && returnType.equals("xlsx");
        if (StringUtils.isNotBlank((CharSequence)returnType) && !returnType.equals("json") && !isXlsx) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Unsupported returnType, possible values: xlsx or json").build();
        }
        if (!isXlsx && limit <= 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Limit must be positive").build();
        }
        if (offset < 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Offset must be 0 or positive").build();
        }
        try {
            if (isXlsx) {
                if (RestUtils.isAnonymous()) {
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Must be authenticated to export XLS file").build();
                }
                if (allPrograms) {
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"'allPrograms' not allowed when exporting XLS file").build();
                }
                String filename = "report_Actions";
                InputStream xlsxInputStream = this.realizationService.exportXlsx(filter, identity, filename, request.getLocale());
                return Response.ok((Object)xlsxInputStream).header("Content-Disposition", (Object)("attachment; filename=" + filename + ".xlsx")).header("Content-Type", (Object)"application/vnd.ms-excel").build();
            }
            List<RealizationDTO> realizations = this.realizationService.getRealizationsByFilter(filter, identity, offset, limit);
            List<RealizationRestEntity> realizationRestEntities = RealizationBuilder.toRestEntities(this.programService, this.ruleService, this.translationService, this.identityManager, this.xmlProcessor, this.userAcl, realizations, Utils.getCurrentUser(), this.getLocale(request));
            RealizationList realizationList = new RealizationList();
            realizationList.setRealizations(realizationRestEntities);
            realizationList.setOffset(offset);
            realizationList.setLimit(limit);
            if (returnSize) {
                realizationList.setSize(this.realizationService.countRealizationsByFilter(filter, identity));
            }
            return Response.ok((Object)realizationList).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).type("text/plain").build();
        }
    }

    @Operation(summary="Retrieves the points of a given user in last period type")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad Request")})
    @Path(value="points")
    @GET
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"users"})
    public Response getAllPointsByUserId(@Parameter(description="Username to retrieve its points.", required=true) @QueryParam(value="userId") String userId, @Parameter(description="Period Type. Possible values: WEEK or MONTH. Default: WEEK.", required=false) @QueryParam(value="period") @DefaultValue(value="WEEK") String period) {
        long points;
        Set<String> validPeriods = Set.of(PeriodType.WEEK.name(), PeriodType.MONTH.name(), PeriodType.YEAR.name());
        if (StringUtils.isBlank((CharSequence)userId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"missingUserIdParameter").build();
        }
        if (!validPeriods.contains(StringUtils.upperCase((String)period))) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"badPeriodParameterValue").build();
        }
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", userId);
        if (period == null || StringUtils.equalsIgnoreCase((CharSequence)Period.ALL.name(), (CharSequence)period)) {
            points = this.realizationService.getScoreByIdentityId(identity.getId());
        } else {
            PeriodType periodType = PeriodType.valueOf(period);
            Date fromDate = periodType.getFromDate();
            Date toDate = periodType.getToDate();
            points = this.realizationService.getScoreByIdentityIdAndBetweenDates(identity.getId(), fromDate, toDate);
        }
        return Response.ok((Object)String.valueOf(points)).build();
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json", "text/plain"})
    @Operation(summary="Retrieves an achievement identified by its id", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation")})
    public Response getRealization(@Context HttpServletRequest request, @Parameter(description="Achievement id", required=true) @PathParam(value="id") long id) {
        if (!Utils.canAccessAnonymousResources(this.securitySettingService)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            RealizationDTO realization = this.realizationService.getRealizationById(id, ConversationState.getCurrent().getIdentity());
            RealizationRestEntity realizationRestEntity = RealizationBuilder.toRestEntity(this.programService, this.ruleService, this.translationService, this.identityManager, this.xmlProcessor, this.userAcl, realization, Utils.getCurrentUser(), this.getLocale(request));
            return Response.ok((Object)realizationRestEntity).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="manager")
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Return 'true' if the current user can manage some realizations, else return 'false'", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public Response isRealizationManager() {
        String username = ConversationState.getCurrent().getIdentity().getUserId();
        return Response.ok((Object)String.valueOf(this.realizationService.isRealizationManager(username))).build();
    }

    @PATCH
    @Consumes(value={"application/x-www-form-urlencoded"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Updates an existing realization", method="POST", description="Updates an existing realization status")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Object not found"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized operation")})
    public Response updateRealizationStatus(@Parameter(description="Realization technical identifier", required=true) @FormParam(value="id") String realizationId, @Parameter(description="Realization technical identifier", required=true) @FormParam(value="status") String status) {
        if (status == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"status is mandatory").build();
        }
        String username = ConversationState.getCurrent().getIdentity().getUserId();
        try {
            this.realizationService.updateRealizationStatus(Long.parseLong(realizationId), RealizationStatus.valueOf(status), username);
            return Response.noContent().build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    private Locale getLocale(HttpServletRequest request) {
        return request == null ? null : request.getLocale();
    }
}

