/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.notification.plugin;

import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.utils.Utils;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class NewActionAvailableNotificationPlugin
extends BaseNotificationPlugin {
    private SpaceService spaceService;

    public NewActionAvailableNotificationPlugin(SpaceService spaceService, InitParams initParams) {
        super(initParams);
        this.spaceService = spaceService;
    }

    public String getId() {
        return "GamificationNewActionAvailableNotification";
    }

    public boolean isValid(NotificationContext ctx) {
        RuleDTO rule = (RuleDTO)ctx.value(Utils.RULE_NOTIFICATION_PARAMETER);
        return rule != null && rule.getActivityId() > 0L && rule.getSpaceId() > 0L;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        RuleDTO rule = (RuleDTO)ctx.value(Utils.RULE_NOTIFICATION_PARAMETER);
        String username = (String)ctx.value(Utils.RULE_CREATOR_NOTIFICATION_PARAMETER);
        Space space = this.spaceService.getSpaceById(String.valueOf(rule.getSpaceId()));
        if (space == null) {
            return null;
        }
        List<String> targetUsers = Arrays.stream(space.getMembers()).filter(targetUser -> !StringUtils.equals((CharSequence)targetUser, (CharSequence)username)).toList();
        if (targetUsers.isEmpty()) {
            return null;
        }
        return NotificationInfo.instance().to(targetUsers).setSpaceId(rule.getSpaceId()).with("RULE_ID", String.valueOf(rule.getId())).with("CREATOR", username).with(SocialNotificationUtils.ACTIVITY_ID.getKey(), String.valueOf(rule.getActivityId())).key(this.getId()).end();
    }
}

