/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.storage.cached;

import io.meeds.gamification.dao.RealizationDAO;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.storage.ProgramStorage;
import io.meeds.gamification.storage.RealizationStorage;
import io.meeds.gamification.storage.RuleStorage;
import java.io.Serializable;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;

public class RealizationCachedStorage
extends RealizationStorage {
    public static final String REALIZATION_CACHE_NAME = "gamification.realization";
    public static final int REALIZATION_ID_CONTEXT = 0;
    public static final int REALIZATION_SCORE_CONTEXT = 1;
    private FutureExoCache<Serializable, Object, Object> realizationFutureCache;

    public RealizationCachedStorage(ProgramStorage programStorage, RuleStorage ruleStorage, RealizationDAO gamificationHistoryDAO, CacheService cacheService) {
        super(programStorage, ruleStorage, gamificationHistoryDAO);
        ExoCache realizationCache = cacheService.getCacheInstance(REALIZATION_CACHE_NAME);
        Loader<Serializable, Object, Object> realizationLoader = new Loader<Serializable, Object, Object>(){

            public Object retrieve(Object context, Serializable key) throws Exception {
                if ((Integer)context == 1) {
                    return RealizationCachedStorage.super.getScoreByIdentityId((String)((Object)key));
                }
                if ((Integer)context == 0) {
                    return RealizationCachedStorage.super.getRealizationById((Long)key);
                }
                throw new IllegalStateException("Unknown context id " + String.valueOf(context));
            }
        };
        this.realizationFutureCache = new FutureExoCache((Loader)realizationLoader, realizationCache);
    }

    @Override
    public long getScoreByIdentityId(String earnerIdentityId) {
        return (Long)this.realizationFutureCache.get((Object)1, (Object)earnerIdentityId);
    }

    @Override
    public RealizationDTO getRealizationById(long id) {
        return (RealizationDTO)this.realizationFutureCache.get((Object)0, (Object)id);
    }

    @Override
    public RealizationDTO updateRealization(RealizationDTO realization) {
        if ((realization = super.updateRealization(realization)) != null) {
            this.realizationFutureCache.remove((Serializable)((Object)realization.getEarnerId()));
            this.realizationFutureCache.remove((Serializable)realization.getId());
        }
        return realization;
    }

    @Override
    public RealizationDTO createRealization(RealizationDTO realization) {
        if ((realization = super.createRealization(realization)) != null) {
            this.realizationFutureCache.remove((Serializable)((Object)realization.getEarnerId()));
        }
        return realization;
    }
}

