/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service.impl;

import io.meeds.gamification.constant.DateFilterType;
import io.meeds.gamification.constant.EntityFilterType;
import io.meeds.gamification.constant.EntityStatusType;
import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.constant.IdentityType;
import io.meeds.gamification.constant.Period;
import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.constant.RecurrenceType;
import io.meeds.gamification.model.EventDTO;
import io.meeds.gamification.model.PiechartLeaderboard;
import io.meeds.gamification.model.ProfileReputation;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.StandardLeaderboard;
import io.meeds.gamification.model.filter.LeaderboardFilter;
import io.meeds.gamification.model.filter.ProgramFilter;
import io.meeds.gamification.model.filter.RealizationFilter;
import io.meeds.gamification.model.filter.RuleFilter;
import io.meeds.gamification.plugin.EventPlugin;
import io.meeds.gamification.rest.model.RealizationValidityContext;
import io.meeds.gamification.service.EventService;
import io.meeds.gamification.service.ProgramService;
import io.meeds.gamification.service.RealizationService;
import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.service.impl.RealizationServiceImpl$AjcClosure1;
import io.meeds.gamification.storage.RealizationStorage;
import io.meeds.gamification.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.picocontainer.Startable;

public class RealizationServiceImpl
implements RealizationService,
Startable {
    private static final String REALIZATION_NOT_EXIST_MESSAGE = "Realization with id %s doesn't exist";
    private static final Log LOG;
    private static final String[] COLUMNS;
    private static final String SHEETNAME = "Achivements Report";
    private ExecutorService executorService;
    private ProgramService programService;
    private RuleService ruleService;
    private EventService eventService;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private ResourceBundleService resourceBundleService;
    private ListenerService listenerService;
    private RealizationStorage realizationStorage;
    private String blacklistMembershipExpression = "/leaderboard-blacklist-users";
    private MembershipEntry blacklistMembership;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public RealizationServiceImpl(ProgramService programService, RuleService ruleService, ResourceBundleService resourceBundleService, EventService eventService, IdentityManager identityManager, SpaceService spaceService, RealizationStorage realizationStorage, ListenerService listenerService, InitParams initParams) {
        this.programService = programService;
        this.ruleService = ruleService;
        this.resourceBundleService = resourceBundleService;
        this.eventService = eventService;
        this.spaceService = spaceService;
        this.realizationStorage = realizationStorage;
        this.identityManager = identityManager;
        this.listenerService = listenerService;
        if (initParams != null && initParams.containsKey((Object)"blacklist.group")) {
            this.blacklistMembershipExpression = initParams.getValueParam("blacklist.group").getValue();
        }
        this.blacklistMembership = MembershipEntry.parse((String)this.blacklistMembershipExpression);
        if (this.blacklistMembership == null) {
            this.blacklistMembership = new MembershipEntry(this.blacklistMembershipExpression);
        }
    }

    public void start() {
        QueuedThreadPool threadFactory = new QueuedThreadPool(5, 1, 1);
        threadFactory.setName("Gamification - Realization");
        this.executorService = Executors.newCachedThreadPool((ThreadFactory)threadFactory);
    }

    public void stop() {
        this.executorService.shutdown();
    }

    @Override
    public List<RealizationDTO> getRealizationsByFilter(RealizationFilter realizationFilter, Identity userAclIdentity, int offset, int limit) throws IllegalAccessException {
        if ((realizationFilter = this.computeProgramFilter(realizationFilter, userAclIdentity)) == null) {
            return Collections.emptyList();
        }
        return this.getRealizationsByFilter(realizationFilter, offset, limit);
    }

    @Override
    public List<RealizationDTO> getRealizationsByFilter(RealizationFilter realizationFilter, int offset, int limit) {
        return this.realizationStorage.getRealizationsByFilter(realizationFilter, offset, limit);
    }

    @Override
    public int countRealizationsByFilter(RealizationFilter realizationFilter, Identity userAclIdentity) throws IllegalAccessException {
        if ((realizationFilter = this.computeProgramFilter(realizationFilter, userAclIdentity)) == null) {
            return 0;
        }
        return this.countRealizationsByFilter(realizationFilter);
    }

    @Override
    public int countRealizationsByFilter(RealizationFilter realizationFilter) {
        return this.realizationStorage.countRealizationsByFilter(realizationFilter);
    }

    @Override
    public int getLeaderboardRank(String earnerIdentityId, Date fromDate, Date toDate, Long spaceId, Long programId) {
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getIdentity(earnerIdentityId);
        IdentityType identityType = IdentityType.getType(identity.getProviderId());
        if (programId != null && programId > 0L || spaceId != null && spaceId > 0L) {
            List<Long> programIds;
            List<Long> list = programIds = programId != null && programId > 0L ? Collections.singletonList(programId) : this.getSpaceProgramIds(spaceId);
            if (programIds.isEmpty()) {
                return 0;
            }
            if (fromDate != null && toDate != null) {
                return this.realizationStorage.getLeaderboardRankByDatesAndProgramIds(identityType, earnerIdentityId, fromDate, toDate, programIds.toArray(new Long[programIds.size()]));
            }
            return this.realizationStorage.getLeaderboardRankByProgramIds(identityType, earnerIdentityId, programIds.toArray(new Long[programIds.size()]));
        }
        if (fromDate != null && toDate != null) {
            return this.realizationStorage.getLeaderboardRankByDates(identityType, earnerIdentityId, fromDate, toDate);
        }
        return this.realizationStorage.getLeaderboardRank(identityType, earnerIdentityId);
    }

    @Override
    public long getScoreByIdentityId(String earnerIdentityId) {
        return this.realizationStorage.getScoreByIdentityId(earnerIdentityId);
    }

    @Override
    public List<ProfileReputation> getScorePerProgramByIdentityId(String earnerIdentityId) {
        return this.realizationStorage.getScorePerProgramByIdentityId(earnerIdentityId);
    }

    @Override
    public void createRealizationsAsync(String event, String eventDetails, String earnerIdentityId, String receiverIdentityId, String objectId, String objectType) {
        this.executorService.execute(() -> this.createRealizationsAsyncInternal(event, eventDetails, earnerIdentityId, receiverIdentityId, objectId, objectType));
    }

    @Override
    public List<RealizationDTO> createRealizations(String event, String eventDetails, String earnerIdentityId, String receiverIdentityId, String objectId, String objectType) {
        org.exoplatform.social.core.identity.model.Identity earnerIdentity = this.identityManager.getIdentity(earnerIdentityId);
        if (earnerIdentity == null || earnerIdentity.isDeleted() || !earnerIdentity.isEnable()) {
            return Collections.emptyList();
        }
        List<RuleDTO> rules = this.findActiveRulesByEventAndEarner(event, earnerIdentity);
        if (CollectionUtils.isEmpty(rules)) {
            return Collections.emptyList();
        }
        EventPlugin eventPlugin = this.eventService.getEventPlugin(event);
        if (eventPlugin != null) {
            rules = rules.stream().filter(ruleDTO -> MapUtils.isEmpty(ruleDTO.getEvent().getProperties()) || eventPlugin.isValidEvent(ruleDTO.getEvent().getProperties(), eventDetails)).toList();
        }
        return rules.stream().distinct().filter(rule -> this.getRealizationValidityContext((RuleDTO)rule, earnerIdentity.getId()).isValidForIdentity()).map(rule -> this.toRealization((RuleDTO)rule, earnerIdentity, receiverIdentityId, objectId, objectType, eventDetails)).map(r -> {
            r = this.realizationStorage.createRealization((RealizationDTO)r);
            Utils.broadcastEvent(this.listenerService, "realization.created", r, null);
            return r;
        }).toList();
    }

    @Override
    public void updateRealizationStatus(long realizationId, RealizationStatus status) throws ObjectNotFoundException {
        RealizationDTO realization = this.getRealizationById(realizationId);
        if (realization == null) {
            throw new ObjectNotFoundException(String.format(REALIZATION_NOT_EXIST_MESSAGE, realizationId));
        }
        if (status == null) {
            throw new IllegalArgumentException("status is mandatory");
        }
        realization.setStatus(status.name());
        this.updateRealizationStatus(realization, status);
    }

    @Override
    public void updateRealizationStatus(long realizationId, RealizationStatus status, String username) throws IllegalAccessException, ObjectNotFoundException {
        org.exoplatform.social.core.identity.model.Identity reviewerIdentity;
        boolean reviewed;
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalAccessException("username is mandatory");
        }
        if (status == null) {
            throw new IllegalArgumentException("status is mandatory");
        }
        Set<RealizationStatus> allowedStatus = Set.of(RealizationStatus.ACCEPTED, RealizationStatus.REJECTED, RealizationStatus.PENDING);
        if (!allowedStatus.contains((Object)status)) {
            throw new IllegalArgumentException("Allowed manual status can be either ACCEPTED or REJECTED");
        }
        RealizationDTO realization = this.getRealizationById(realizationId);
        if (realization == null) {
            throw new ObjectNotFoundException(String.format(REALIZATION_NOT_EXIST_MESSAGE, realizationId));
        }
        if (!Utils.isRewardingManager(username) && !this.programService.isProgramOwner(realization.getProgram().getId(), username)) {
            throw new IllegalAccessException("User doesn't have enough privileges to update achievements of user" + realization.getEarnerId());
        }
        if (RealizationStatus.CANCELED.name().equals(realization.getStatus()) || RealizationStatus.DELETED.name().equals(realization.getStatus())) {
            throw new IllegalArgumentException("Canceled achievement cannot be updated");
        }
        boolean bl = reviewed = realization.getReviewerId() != null;
        if (RealizationStatus.PENDING.name().equals(realization.getStatus())) {
            if (realization.getSendingDate() == null) {
                realization.setSendingDate(realization.getCreatedDate());
            }
            realization.setCreatedDate(Utils.toRFC3339Date(new Date(System.currentTimeMillis())));
        }
        if ((reviewerIdentity = this.identityManager.getOrCreateUserIdentity(username)) != null) {
            realization.setReviewerId(Long.valueOf(reviewerIdentity.getId()));
        }
        realization.setStatus(status.name());
        this.updateRealizationStatus(realization, status);
        if (!RealizationStatus.PENDING.equals((Object)status) && reviewerIdentity != null && !reviewed) {
            RuleDTO rule = this.ruleService.findRuleById(realization.getRuleId());
            String eventDetails = null;
            if (rule != null) {
                String eventReviewed = rule.getEvent() != null ? rule.getEvent().getTrigger() : null;
                eventDetails = "{ruleId: " + rule.getId() + ", programId: " + rule.getProgram().getId() + ", eventReviewed: " + eventReviewed + "}";
            }
            this.createRealizations("reviewContribution", eventDetails, reviewerIdentity.getId(), reviewerIdentity.getId(), realization.getActivityId() != null ? String.valueOf(realization.getActivityId()) : null, null);
        }
    }

    @Override
    public List<RealizationDTO> cancelRealizations(String event, String earnerIdentityId, String receiverIdentityId, String objectId, String objectType) {
        List<RuleDTO> rules = this.findActiveRulesByEvent(event);
        if (CollectionUtils.isEmpty(rules)) {
            return Collections.emptyList();
        }
        return rules.stream().map(rule -> this.realizationStorage.findLastRealizationByRuleIdAndEarnerIdAndReceiverAndObjectId(rule.getId(), earnerIdentityId, receiverIdentityId, objectId, objectType)).filter(Objects::nonNull).filter(realization -> !RealizationStatus.CANCELED.name().equals(realization.getStatus())).map(realization -> {
            realization.setStatus(RealizationStatus.CANCELED.name());
            realization.setActivityId(null);
            realization.setObjectId(null);
            try {
                RealizationDTO realizationDTO = this.realizationStorage.updateRealization((RealizationDTO)realization);
                return realizationDTO;
            }
            catch (Exception e) {
                LOG.warn("Error canceling realization with id {}", new Object[]{realization.getId(), e});
                RealizationDTO realizationDTO = null;
                return realizationDTO;
            }
            finally {
                Utils.broadcastEvent(this.listenerService, "realization.canceled", realization, null);
            }
        }).filter(Objects::nonNull).toList();
    }

    @Override
    public List<RealizationDTO> deleteRealizations(String objectId, String objectType) {
        List<RealizationDTO> realizations = this.findRealizationsByObjectIdAndObjectType(objectId, objectType);
        realizations.forEach(realization -> {
            if (!RealizationStatus.DELETED.name().equals(realization.getStatus()) && !RealizationStatus.CANCELED.name().equals(realization.getStatus())) {
                realization.setStatus(RealizationStatus.DELETED.name());
                realization.setActivityId(null);
                realization.setObjectId(null);
                try {
                    this.realizationStorage.updateRealization((RealizationDTO)realization);
                }
                catch (Exception e) {
                    LOG.warn("Error deleting realization with id {}", new Object[]{realization.getId(), e});
                }
                finally {
                    Utils.broadcastEvent(this.listenerService, "realization.canceled", realization, null);
                }
            }
        });
        return realizations;
    }

    @Override
    public RealizationValidityContext getRealizationValidityContext(RuleDTO rule, String earnerIdentityId) {
        boolean anonymous;
        RealizationValidityContext realizationRestriction = new RealizationValidityContext();
        if (rule == null || rule.isDeleted() || !rule.isEnabled()) {
            realizationRestriction.setValidRule(false);
            return realizationRestriction;
        }
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getIdentity(earnerIdentityId);
        boolean bl = anonymous = identity == null || identity.isDeleted() || !identity.isEnable();
        if (anonymous || identity.isUser() && !this.programService.isProgramMember(rule.getProgram().getId(), identity.getRemoteId()) || identity.isSpace() && !rule.isOpen() && rule.getSpaceId() != this.getSpaceId(identity.getRemoteId())) {
            realizationRestriction.setValidIdentity(false);
        }
        if (!this.isValidProgram(rule.getProgram())) {
            realizationRestriction.setValidProgram(false);
            return realizationRestriction;
        }
        if (!this.isValidDates(rule)) {
            realizationRestriction.setValidDates(false);
        }
        if (!anonymous && !this.isRecurrenceValid(rule, earnerIdentityId)) {
            realizationRestriction.setValidRecurrence(false);
            RecurrenceType recurrence = rule.getRecurrence();
            if (recurrence == RecurrenceType.DAILY || recurrence == RecurrenceType.WEEKLY || recurrence == RecurrenceType.MONTHLY) {
                Date endDate = Utils.parseSimpleDate(rule.getEndDate());
                Instant nextDate = recurrence.getNextPeriodStartDate().toInstant();
                if (endDate == null || endDate.toInstant().isAfter(nextDate)) {
                    Instant now = Instant.now();
                    realizationRestriction.setNextOccurenceMillis(ChronoUnit.MILLIS.between(now, nextDate));
                }
            }
        }
        if (!anonymous && CollectionUtils.isNotEmpty(rule.getPrerequisiteRuleIds())) {
            realizationRestriction.setValidPrerequisites(new HashMap<String, Boolean>());
            rule.getPrerequisiteRuleIds().forEach(prerequisiteRuleId -> {
                boolean prerequisiteRealized = this.realizationStorage.countRealizationsByRuleIdAndEarnerId(earnerIdentityId, (long)prerequisiteRuleId) > 0;
                realizationRestriction.getValidPrerequisites().put(String.valueOf(prerequisiteRuleId), prerequisiteRealized);
            });
        }
        if (!anonymous && realizationRestriction.isValidForIdentity()) {
            Space space;
            if (!rule.isOpen() && (space = this.spaceService.getSpaceById(String.valueOf(rule.getSpaceId()))) == null) {
                realizationRestriction.setValidAudience(false);
            }
            if (identity.isUser() && this.isUserBlacklisted(identity.getRemoteId())) {
                realizationRestriction.setValidWhitelist(false);
            }
        }
        return realizationRestriction;
    }

    @Override
    public List<StandardLeaderboard> getLeaderboard(LeaderboardFilter filter, String currentUser) throws IllegalAccessException {
        List<Object> leaderboardItems;
        int limit = filter.getLimit();
        IdentityType identityType = filter.getIdentityType();
        if (identityType.isSpace()) {
            if (StringUtils.isBlank((CharSequence)currentUser)) {
                throw new IllegalAccessException("Anonymous user can't access spaces board");
            }
            limit *= 3;
        }
        String period = filter.getPeriod();
        long programId = filter.getProgramId() == null ? 0L : filter.getProgramId();
        long spaceId = filter.getSpaceId() == null ? 0L : filter.getSpaceId();
        Date fromDate = Utils.getFromDate(period, filter.getMedianDateInSeconds());
        Date toDate = Utils.getToDate(period, filter.getMedianDateInSeconds());
        if (programId > 0L || spaceId > 0L) {
            List<Long> programIds;
            List<Long> list = programIds = programId > 0L ? Collections.singletonList(programId) : this.getSpaceProgramIds(spaceId);
            leaderboardItems = programIds.isEmpty() ? Collections.emptyList() : (period.equals(Period.ALL.name()) ? this.realizationStorage.getLeaderboardByProgramIds(identityType, filter.getOffset(), limit, programIds.toArray(new Long[programIds.size()])) : this.realizationStorage.getLeaderboardByDatesByProgramIds(fromDate, new Date(), identityType, filter.getOffset(), limit, programIds.toArray(new Long[programIds.size()])));
        } else {
            leaderboardItems = period.equals(Period.ALL.name()) ? this.realizationStorage.getLeaderboard(identityType, filter.getOffset(), limit) : this.realizationStorage.getLeaderboardByDates(fromDate, toDate, identityType, filter.getOffset(), limit);
        }
        if (identityType.isSpace() && leaderboardItems != null && !leaderboardItems.isEmpty()) {
            leaderboardItems = this.filterAuthorizedSpaces(leaderboardItems, currentUser, filter.getLimit());
        }
        return leaderboardItems;
    }

    @Override
    public List<PiechartLeaderboard> getLeaderboardStatsByIdentityId(String earnerIdentityId, Long spaceId, String period, Date startDate, Date endDate) {
        if (Period.ALL.name().equals(period)) {
            return this.realizationStorage.getLeaderboardStatsByIdentityId(earnerIdentityId, spaceId);
        }
        return this.realizationStorage.getLeaderboardStatsByIdentityIdAndDates(earnerIdentityId, spaceId, startDate, endDate);
    }

    @Override
    public long getScoreByIdentityIdAndBetweenDates(String earnerIdentityId, Date fromDate, Date toDate, Long spaceId, Long programId) {
        spaceId = spaceId == null ? 0L : spaceId;
        programId = programId == null ? 0L : programId;
        List<Long> programIds = programId > 0L ? Collections.singletonList(programId) : this.getSpaceProgramIds(spaceId);
        return this.realizationStorage.getScoreByIdentityIdAndBetweenDates(earnerIdentityId, fromDate, toDate, programIds.toArray(new Long[programIds.size()]));
    }

    @Override
    public Map<Long, Long> getScoresByIdentityIdsAndBetweenDates(List<String> earnersId, Date fromDate, Date toDate) {
        return this.realizationStorage.getScoresByIdentityIdsAndBetweenDates(earnersId, fromDate, toDate);
    }

    @Override
    public List<Long> getParticipantsBetweenDates(Date fromDate, Date toDate) {
        return this.realizationStorage.getParticipantsBetweenDates(fromDate, toDate);
    }

    @Override
    public long countParticipantsBetweenDates(Date fromDate, Date toDate) {
        return this.realizationStorage.countParticipantsBetweenDates(fromDate, toDate);
    }

    @Override
    public RealizationDTO getRealizationById(long realizationId) {
        if (realizationId <= 0L) {
            throw new IllegalArgumentException("realization id is mandatory");
        }
        return this.realizationStorage.getRealizationById(realizationId);
    }

    @Override
    public boolean isRealizationManager(String username) {
        if (Utils.isRewardingManager(username)) {
            return true;
        }
        return this.programService.countOwnedPrograms(username) > 0;
    }

    @Override
    public RealizationDTO getRealizationById(long realizationId, Identity userAclIdentity) throws IllegalAccessException, ObjectNotFoundException {
        if (realizationId <= 0L) {
            throw new IllegalArgumentException("realization id is mandatory");
        }
        if (userAclIdentity == null) {
            throw new IllegalArgumentException("identity is mandatory");
        }
        String username = userAclIdentity.getUserId();
        org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getOrCreateUserIdentity(username);
        RealizationDTO realization = this.realizationStorage.getRealizationById(realizationId);
        if (realization == null) {
            throw new ObjectNotFoundException(String.format(REALIZATION_NOT_EXIST_MESSAGE, realizationId));
        }
        if (this.programService.canViewProgram(realization.getProgram().getId(), userAclIdentity.getUserId()) || realization.getEarnerId().equals(userIdentity.getId())) {
            return realization;
        }
        throw new IllegalAccessException("User doesn't have enough privileges to access achievement");
    }

    @Override
    public List<RealizationDTO> findRealizationsByObjectIdAndObjectType(String objectId, String objectType) {
        return this.realizationStorage.findRealizationsByObjectIdAndObjectType(objectId, objectType);
    }

    @Override
    public boolean hasPendingRealization(long ruleId, String earnerIdentityId) {
        return this.realizationStorage.hasPendingRealization(ruleId, earnerIdentityId);
    }

    @Override
    public InputStream exportXlsx(RealizationFilter filter, Identity identity, String fileName, Locale locale) throws IllegalAccessException {
        File temp = null;
        try {
            temp = this.createTempFile(fileName);
            List<RealizationDTO> realizations = this.getRealizationsByFilter(filter, identity, 0, -1);
            try (XSSFWorkbook workbook = new XSSFWorkbook();
                 FileOutputStream outputStream = new FileOutputStream(temp);){
                int rowIndex = 0;
                XSSFCreationHelper helper = workbook.getCreationHelper();
                XSSFSheet sheet = workbook.createSheet(SHEETNAME);
                this.appendRealizationHeaderRow((Sheet)sheet, rowIndex++, (CreationHelper)helper, locale);
                for (RealizationDTO realization : realizations) {
                    this.appendRealizationRow((Sheet)sheet, rowIndex++, (CreationHelper)helper, realization);
                }
                workbook.write((OutputStream)outputStream);
            }
            FileInputStream fileInputStream = new FileInputStream(temp);
            return fileInputStream;
        }
        catch (IOException e) {
            throw new IllegalStateException("Error exporting XLSX file for achievements with filter " + String.valueOf(filter), e);
        }
        finally {
            if (temp != null && temp.exists()) {
                temp.deleteOnExit();
            }
        }
    }

    @ExoTransactional
    public void createRealizationsAsyncInternal(String event, String eventDetails, String earnerIdentityId, String receiverIdentityId, String objectId, String objectType) {
        String string = event;
        String string2 = eventDetails;
        String string3 = earnerIdentityId;
        String string4 = receiverIdentityId;
        String string5 = objectId;
        String string6 = objectType;
        Object[] objectArray = new Object[]{string, string2, string3, string4, string5, string6};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, string2, string3, string4, string5, string6, joinPoint};
        RealizationServiceImpl$AjcClosure1 realizationServiceImpl$AjcClosure1 = new RealizationServiceImpl$AjcClosure1(objectArray2);
        ExoTransactionalAspect.aspectOf().around(realizationServiceImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private RealizationFilter computeProgramFilter(RealizationFilter realizationFilter, Identity userAclIdentity) throws IllegalAccessException {
        String username;
        if (realizationFilter == null) {
            throw new IllegalArgumentException("filter is mandatory");
        }
        realizationFilter = realizationFilter.clone();
        this.checkDates(realizationFilter.getFromDate(), realizationFilter.getToDate());
        String string = username = userAclIdentity == null ? null : userAclIdentity.getUserId();
        if (Utils.isRewardingManager(username) || realizationFilter.isAllPrograms()) {
            return realizationFilter;
        }
        List<Long> filterProgramIds = this.computeFilteredPrograms(realizationFilter);
        boolean isFilterByPrograms = CollectionUtils.isNotEmpty(filterProgramIds);
        if (realizationFilter.isOwned()) {
            if (isFilterByPrograms && !this.isProgramsOwner(filterProgramIds, username)) {
                throw new IllegalAccessException("User is not owner of one or several selected programs :" + String.valueOf(filterProgramIds));
            }
            if (!isFilterByPrograms) {
                List<Long> ownedProgramIds = this.programService.getOwnedProgramIds(username, 0, -1);
                if (CollectionUtils.isEmpty(ownedProgramIds)) {
                    return null;
                }
                realizationFilter.setProgramIds(ownedProgramIds);
            }
        } else {
            if (isFilterByPrograms && !this.canViewPrograms(filterProgramIds, username)) {
                throw new IllegalAccessException("User is not member of one or several selected programs :" + String.valueOf(filterProgramIds));
            }
            if (!isFilterByPrograms && !this.isSelfFilter(realizationFilter, username)) {
                List<Long> memberProgramIds = this.programService.getMemberProgramIds(username, 0, -1);
                if (CollectionUtils.isEmpty(memberProgramIds)) {
                    return null;
                }
                realizationFilter.setProgramIds(memberProgramIds);
            }
        }
        return realizationFilter;
    }

    private boolean isSelfFilter(RealizationFilter realizationFilter, String username) {
        org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getOrCreateUserIdentity(username);
        boolean filterByEarner = CollectionUtils.isNotEmpty(realizationFilter.getEarnerIds());
        return filterByEarner && realizationFilter.getEarnerIds().size() == 1 && userIdentity != null && realizationFilter.getEarnerIds().get(0).equals(userIdentity.getId());
    }

    private List<Long> computeFilteredPrograms(RealizationFilter realizationFilter) {
        List<Long> filterProgramIds = realizationFilter.getProgramIds();
        List<Long> ruleIds = realizationFilter.getRuleIds();
        if (CollectionUtils.isNotEmpty(ruleIds)) {
            Set programIds = ruleIds.stream().map(ruleId -> {
                RuleDTO rule = this.ruleService.findRuleById((long)ruleId);
                return rule == null || rule.getProgramId() == 0L ? null : Long.valueOf(rule.getProgramId());
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(filterProgramIds)) {
                return programIds.stream().toList();
            }
            return CollectionUtils.intersection(filterProgramIds, programIds).stream().toList();
        }
        return filterProgramIds;
    }

    private boolean isProgramsOwner(List<Long> programIds, String username) {
        return programIds.stream().allMatch(programId -> this.programService.isProgramOwner((long)programId, username));
    }

    private boolean canViewPrograms(List<Long> programIds, String username) {
        return programIds.stream().allMatch(programId -> this.programService.canViewProgram((long)programId, username));
    }

    private List<StandardLeaderboard> filterAuthorizedSpaces(List<StandardLeaderboard> result, String currentUser, int limit) {
        result = result.stream().filter(spacePoint -> {
            String spaceIdentityId = spacePoint.getEarnerId();
            org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getIdentity(spaceIdentityId);
            if (identity == null) {
                LOG.debug("Space Identity with id {} was deleted, ignore it", new Object[]{spaceIdentityId});
                return false;
            }
            Space space = this.spaceService.getSpaceByPrettyName(identity.getRemoteId());
            return space != null && (!"hidden".equals(space.getVisibility()) || this.spaceService.isMember(space, currentUser));
        }).limit(limit).toList();
        return result;
    }

    private void checkDates(Date fromDate, Date toDate) {
        if (fromDate != null && toDate != null && fromDate.after(toDate)) {
            throw new IllegalArgumentException("Dates parameters are not set correctly");
        }
    }

    private boolean isRecurrenceValid(RuleDTO rule, String earnerIdentityId) {
        return rule.getRecurrence() == null || rule.getRecurrence() == RecurrenceType.NONE || this.hasNoRealizationInPeriod(earnerIdentityId, rule.getId(), rule.getRecurrence().getPeriodStartDate());
    }

    private boolean hasNoRealizationInPeriod(String earnerIdentityId, Long ruleId, Date sinceDate) {
        return this.realizationStorage.countRealizationsInPeriod(earnerIdentityId, ruleId, sinceDate) == 0;
    }

    private RealizationDTO toRealization(RuleDTO ruleDto, org.exoplatform.social.core.identity.model.Identity earnerIdentity, String receiverIdentityId, String objectId, String objectType, String eventDetails) {
        String eventTrigger;
        RealizationDTO realization = new RealizationDTO();
        EventDTO event = ruleDto.getEvent();
        String eventType = event.getType();
        if (this.eventService.canVariableRewarding(eventType, eventTrigger = event.getTrigger()) && MapUtils.isNotEmpty(event.getProperties()) && StringUtils.isNotBlank((CharSequence)event.getProperties().get("totalTargetItem"))) {
            this.computeRealizationScore(realization, event, eventDetails, ruleDto.getScore());
        } else {
            realization.setActionScore(ruleDto.getScore());
        }
        realization.setGlobalScore(this.getScoreByIdentityId(earnerIdentity.getId()) + (long)ruleDto.getScore());
        realization.setEarnerId(earnerIdentity.getId());
        realization.setEarnerType(earnerIdentity.getProviderId());
        realization.setActionTitle(ruleDto.getTitle());
        realization.setRuleId(ruleDto.getId());
        realization.setProgram(ruleDto.getProgram());
        realization.setReceiver(receiverIdentityId);
        realization.setObjectId(objectId);
        realization.setObjectType(objectType);
        realization.setStatus(String.valueOf((Object)ruleDto.getDefaultRealizationStatus()));
        realization.setType(ruleDto.getType());
        return realization;
    }

    private boolean isValidProgram(ProgramDTO program) {
        return program != null && program.isEnabled() && !program.isDeleted();
    }

    private boolean isValidDates(RuleDTO rule) {
        Date startDate = Utils.parseSimpleDate(rule.getStartDate());
        Date endDate = Utils.parseSimpleDate(rule.getEndDate());
        return !(startDate != null && startDate.getTime() >= System.currentTimeMillis() || endDate != null && endDate.getTime() <= System.currentTimeMillis());
    }

    private List<RuleDTO> findActiveRulesByEvent(String eventName) {
        return this.findActiveRulesByEventAndEarner(eventName, null);
    }

    private List<RuleDTO> findActiveRulesByEventAndEarner(String eventName, org.exoplatform.social.core.identity.model.Identity earnerIdentity) {
        RuleFilter ruleFilter = new RuleFilter();
        ruleFilter.setDateFilterType(DateFilterType.STARTED);
        ruleFilter.setType(EntityFilterType.AUTOMATIC);
        ruleFilter.setStatus(EntityStatusType.ENABLED);
        ruleFilter.setProgramStatus(EntityStatusType.ENABLED);
        ruleFilter.setEventName(eventName);
        if (earnerIdentity != null && earnerIdentity.isUser()) {
            return this.ruleService.getRules(ruleFilter, earnerIdentity.getRemoteId(), 0, -1);
        }
        ruleFilter.setAllSpaces(true);
        return this.ruleService.getRules(ruleFilter, 0, -1);
    }

    private boolean isUserBlacklisted(String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            return false;
        }
        Identity identity = Utils.getUserAclIdentity(username);
        if (identity == null) {
            return false;
        }
        return identity.isMemberOf(this.blacklistMembership);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRealizationStatus(RealizationDTO realization, RealizationStatus status) {
        block13: {
            try {
                realization.setLastModifiedDate(Utils.toRFC3339Date(new Date(System.currentTimeMillis())));
                this.realizationStorage.updateRealization(realization);
                if (!RealizationStatus.ACCEPTED.name().equals(realization.getStatus()) && !RealizationStatus.REJECTED.name().equals(realization.getStatus())) break block13;
                String notificationPluginKey = RealizationStatus.ACCEPTED.name().equals(realization.getStatus()) ? "GamificationContributionAcceptedNotification" : "GamificationContributionRejectedNotification";
                NotificationContext ctx = NotificationContextImpl.cloneInstance();
                ctx.append(Utils.REALIZATION_NOTIFICATION_PARAMETER, (Object)realization).getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)notificationPluginKey))).execute(ctx);
            }
            catch (Exception e) {
                try {
                    LOG.warn("Error deleting realization with id {}", new Object[]{realization.getId(), e});
                }
                catch (Throwable throwable) {
                    String eventName = switch (status) {
                        case RealizationStatus.CANCELED, RealizationStatus.DELETED, RealizationStatus.REJECTED -> "realization.canceled";
                        default -> "realization.updated";
                    };
                    Utils.broadcastEvent(this.listenerService, eventName, realization, null);
                    throw throwable;
                }
                String eventName = switch (status) {
                    case RealizationStatus.CANCELED, RealizationStatus.DELETED, RealizationStatus.REJECTED -> "realization.canceled";
                    default -> "realization.updated";
                };
                Utils.broadcastEvent(this.listenerService, eventName, realization, null);
            }
        }
        String eventName = switch (status) {
            case RealizationStatus.CANCELED, RealizationStatus.DELETED, RealizationStatus.REJECTED -> "realization.canceled";
            default -> "realization.updated";
        };
        Utils.broadcastEvent(this.listenerService, eventName, realization, null);
    }

    private void appendRealizationHeaderRow(Sheet sheet, int rowIndex, CreationHelper helper, Locale locale) {
        Row row = sheet.createRow(rowIndex);
        ResourceBundle resourceBundle = this.resourceBundleService.getResourceBundle("locale.addon.Gamification", locale);
        for (int i = 0; i < COLUMNS.length; ++i) {
            row.createCell(i).setCellValue(helper.createRichTextString(resourceBundle.getString("realization.label." + COLUMNS[i])));
        }
    }

    private void appendRealizationRow(Sheet sheet, int rowIndex, CreationHelper helper, RealizationDTO realization) {
        Row row = sheet.createRow(rowIndex);
        try {
            RuleDTO rule = realization.getRuleId() != null && realization.getRuleId() != 0L ? this.ruleService.findRuleById(realization.getRuleId()) : this.ruleService.findRuleByTitle(realization.getActionTitle());
            String eventTitle = rule == null || rule.getEvent() == null ? null : rule.getEvent().getTitle();
            String eventTrigger = rule == null || rule.getEvent() == null ? null : rule.getEvent().getTrigger();
            String actionLabel = realization.getActionTitle() != null ? realization.getActionTitle() : eventTitle;
            String programTitle = Utils.escapeIllegalCharacterInMessage(realization.getProgramLabel());
            int cellIndex = 0;
            row.createCell(cellIndex++).setCellValue(helper.createRichTextString(realization.getCreatedDate()));
            row.createCell(cellIndex++).setCellValue(Utils.getUserFullName(realization.getEarnerId()));
            row.createCell(cellIndex++).setCellValue(rule != null ? rule.getType().name() : "-");
            row.createCell(cellIndex++).setCellValue(programTitle);
            row.createCell(cellIndex++).setCellValue(actionLabel);
            this.appendContributionCells(row, cellIndex++, helper, realization, eventTrigger);
            row.createCell(cellIndex++).setCellValue((double)realization.getActionScore());
            row.createCell(cellIndex).setCellValue(realization.getStatus());
        }
        catch (Exception e) {
            LOG.error((Object)"Error when computing to XLSX ", (Throwable)e);
        }
    }

    private void appendContributionCells(Row row, int cellIndex, CreationHelper helper, RealizationDTO realization, String eventTrigger) {
        Cell hashCell = row.createCell(cellIndex);
        Object contributionURL = null;
        if (realization.getType() == EntityType.MANUAL) {
            Long activityId = realization.getActivityId();
            if (activityId != null && activityId > 0L) {
                contributionURL = Utils.getBaseUrl() + LinkProvider.getRedirectUri((String)("activity?id=" + activityId));
            }
            hashCell.setCellValue(TemplateUtils.cleanHtmlTags((String)realization.getComment()));
        } else {
            EventPlugin eventPlugin = this.eventService.getEventPlugin(eventTrigger);
            if (eventPlugin != null) {
                contributionURL = eventPlugin.getLink(realization);
            }
            hashCell.setCellValue((String)(contributionURL != null ? contributionURL : ""));
        }
        if (contributionURL != null && (((String)contributionURL).startsWith("http://") || ((String)contributionURL).startsWith("https://"))) {
            Hyperlink link = helper.createHyperlink(HyperlinkType.URL);
            link.setAddress((String)contributionURL);
            hashCell.setHyperlink(link);
        }
    }

    private File createTempFile(String fileName) throws IOException {
        SimpleDateFormat formatter = new SimpleDateFormat("yy-MM-dd_HH-mm-ss");
        fileName = (String)fileName + formatter.format(new Date());
        if (SystemUtils.IS_OS_UNIX) {
            FileAttribute<Set<PosixFilePermission>> tempFileAttributes = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-------"));
            return Files.createTempFile((String)fileName, ".xlsx", tempFileAttributes).toFile();
        }
        File temp = Files.createTempFile((String)fileName, ".xlsx", new FileAttribute[0]).toFile();
        if (!temp.setReadable(true, true) || !temp.setWritable(true, true)) {
            throw new IllegalStateException("Can't write a temp file to export XLS achievements file");
        }
        return temp;
    }

    private long getSpaceId(String spacePrettyName) {
        Space space = this.spaceService.getSpaceByPrettyName(spacePrettyName);
        return space == null ? 0L : Long.parseLong(space.getId());
    }

    private void computeRealizationScore(RealizationDTO realizationDTO, EventDTO event, String eventDetails, int score) {
        EventPlugin eventPlugin = this.eventService.getEventPlugin(event.getTrigger());
        if (eventPlugin != null) {
            realizationDTO.setActionScore((long)Math.ceil(eventPlugin.getPointsRatio(event.getProperties(), eventDetails) * (double)score));
        }
    }

    private List<Long> getSpaceProgramIds(long spaceId) {
        if (spaceId <= 0L) {
            return Collections.emptyList();
        }
        ProgramFilter programFilter = new ProgramFilter();
        programFilter.setSpacesIds(Collections.singletonList(spaceId));
        programFilter.setExcludeOpen(true);
        return this.programService.getProgramIds(programFilter, 0, 100);
    }

    static {
        RealizationServiceImpl.ajc$preClinit();
        LOG = ExoLogger.getLogger(RealizationServiceImpl.class);
        COLUMNS = new String[]{"date", "grantee", "actionType", "programLabel", "actionLabel", "contribution", "points", "status"};
    }

    static final /* synthetic */ void createRealizationsAsyncInternal_aroundBody0(RealizationServiceImpl ajc$this, String event, String eventDetails, String earnerIdentityId, String receiverIdentityId, String objectId, String objectType, JoinPoint joinPoint) {
        ajc$this.createRealizations(event, eventDetails, earnerIdentityId, receiverIdentityId, objectId, objectType);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RealizationServiceImpl.java", RealizationServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createRealizationsAsyncInternal", "io.meeds.gamification.service.impl.RealizationServiceImpl", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String", "event:eventDetails:earnerIdentityId:receiverIdentityId:objectId:objectType", "", "void"), 626);
    }
}

