/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.rest;

import io.meeds.gamification.model.BadgeDTO;
import io.meeds.gamification.model.PiechartLeaderboard;
import io.meeds.gamification.model.ProfileReputation;
import io.meeds.gamification.service.BadgeService;
import io.meeds.gamification.service.RealizationService;
import io.meeds.gamification.utils.GamificationUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="/gamification/reputation")
@Produces(value={"application/json"})
@RolesAllowed(value={"users"})
public class UserReputationEndpoint
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(UserReputationEndpoint.class);
    private final CacheControl cacheControl = new CacheControl();
    protected final RealizationService realizationService;
    protected final IdentityManager identityManager;
    protected final BadgeService badgeService;
    protected final FileService fileService;

    public UserReputationEndpoint(RealizationService realizationService, IdentityManager identityManager, BadgeService badgeService, FileService fileService) {
        this.cacheControl.setNoCache(true);
        this.cacheControl.setNoStore(true);
        this.realizationService = realizationService;
        this.identityManager = identityManager;
        this.badgeService = badgeService;
        this.fileService = fileService;
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="status")
    public Response getReputationStatus(@Context UriInfo uriInfo, @Context HttpServletRequest request, @QueryParam(value="username") String username, @QueryParam(value="url") String url) {
        String profileOwner;
        long userReputationScore = 0L;
        int userRank = 0;
        String string = profileOwner = StringUtils.isBlank((CharSequence)username) ? GamificationUtils.extractProfileOwnerFromUrl(url, "/") : username;
        if (profileOwner.equals("profile") || StringUtils.isBlank((CharSequence)profileOwner)) {
            Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (StringUtils.isNotBlank((CharSequence)profileOwner)) {
            try {
                Identity id = this.identityManager.getOrCreateIdentity("organization", profileOwner);
                if (id == null) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("User " + profileOwner + " not found")).build();
                }
                String actorId = id.getId();
                JSONObject reputation = new JSONObject();
                userReputationScore = this.realizationService.getScoreByIdentityId(actorId);
                userRank = this.realizationService.getLeaderboardRank(actorId, Date.from(LocalDate.now().with(DayOfWeek.MONDAY).atStartOfDay(ZoneId.systemDefault()).toInstant()), null, null, null);
                reputation.put("score", userReputationScore);
                reputation.put("rank", userRank);
                return Response.ok().cacheControl(this.cacheControl).entity((Object)reputation.toString()).build();
            }
            catch (Exception e) {
                LOG.error("Error to calculate repuation score for user {} ", new Object[]{profileOwner, e});
                return Response.serverError().build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @GET
    @Path(value="badges/{identityId}")
    @RolesAllowed(value={"users"})
    public Response getUserBadges(@PathParam(value="identityId") long identityId) {
        String earnerId = String.valueOf(identityId);
        Identity identity = this.identityManager.getIdentity(earnerId);
        if (identity == null) {
            return Response.status((int)400).entity((Object)("Identity not found with id " + identityId)).build();
        }
        List<ProfileReputation> badgesByProgram = this.realizationService.getScorePerProgramByIdentityId(earnerId);
        JSONArray profileBadges = this.buildProfileBadges(badgesByProgram);
        return Response.ok().cacheControl(this.cacheControl).entity((Object)profileBadges.toString()).build();
    }

    @GET
    @Path(value="badges")
    public Response getUserBadges(@Context UriInfo uriInfo, @Context HttpServletRequest request, @QueryParam(value="url") String url) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            String profilePageOwner = conversationState.getIdentity().getUserId();
            if (url != null && (profilePageOwner = GamificationUtils.extractProfileOwnerFromUrl(url, "/")).equals("profile")) {
                profilePageOwner = conversationState.getIdentity().getUserId();
            }
            JSONArray allBadges = new JSONArray();
            Identity id = this.identityManager.getOrCreateIdentity("organization", profilePageOwner);
            if (id == null) {
                profilePageOwner = conversationState.getIdentity().getUserId();
                id = this.identityManager.getOrCreateIdentity("organization", profilePageOwner);
            }
            String actorId = id.getId();
            List<ProfileReputation> badgesByProgram = this.realizationService.getScorePerProgramByIdentityId(actorId);
            allBadges = this.buildProfileBadges(badgesByProgram);
            return Response.ok().cacheControl(this.cacheControl).entity((Object)allBadges.toString()).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="badge/{badge}/avatar")
    public Response getBadgeAvatarById(@Context UriInfo uriInfo, @Context Request request, @PathParam(value="badge") Long id) throws IOException {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            InputStream stream = null;
            try {
                Response.ResponseBuilder builder;
                BadgeDTO badgeDTO = this.badgeService.findBadgeById(id);
                Long lastUpdated = null;
                if (badgeDTO != null) {
                    lastUpdated = new SimpleDateFormat("yyyy-MM-dd").parse(badgeDTO.getLastModifiedDate()).getTime();
                } else {
                    stream = UserReputationEndpoint.class.getClassLoader().getResourceAsStream("medias/images/default_badge.png");
                }
                EntityTag eTag = null;
                if (lastUpdated != null) {
                    eTag = new EntityTag(Integer.toString(lastUpdated.hashCode()));
                }
                Response.ResponseBuilder responseBuilder = builder = eTag == null ? null : request.evaluatePreconditions(eTag);
                if (builder == null) {
                    if (stream == null && (stream = this.getBadgeAvatarInputStream(badgeDTO)) == null) {
                        throw new WebApplicationException(Response.Status.NOT_FOUND);
                    }
                    builder = Response.ok((Object)stream, (String)"image/png");
                    builder.tag(eTag);
                }
                CacheControl cc = new CacheControl();
                cc.setMaxAge(86400);
                builder.cacheControl(cc);
                return builder.cacheControl(cc).build();
            }
            catch (Exception e) {
                LOG.error((Object)"Error getting badge's avatar", (Throwable)e);
                return Response.serverError().build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    private InputStream getBadgeAvatarInputStream(BadgeDTO badgeDTO) throws IOException {
        FileItem file = null;
        if (badgeDTO == null) {
            return null;
        }
        Long avatarId = badgeDTO.getIconFileId();
        if (avatarId == 0L) {
            return null;
        }
        try {
            file = this.fileService.getFile(avatarId.longValue());
        }
        catch (FileStorageException e) {
            return null;
        }
        return file == null ? null : file.getAsStream();
    }

    private JSONArray buildProfileBadges(List<ProfileReputation> reputationLis) {
        JSONArray allBadges = new JSONArray();
        if (reputationLis != null && !reputationLis.isEmpty()) {
            for (ProfileReputation rep : reputationLis) {
                this.buildLatestWonBadge(rep.getProgramId(), rep.getScore(), allBadges);
            }
        }
        return allBadges;
    }

    private void buildLatestWonBadge(long programId, long score, JSONArray userBadges) {
        try {
            List<BadgeDTO> allBadges = this.badgeService.findEnabledBadgesByProgramId(programId);
            BadgeDTO badgeDTO2 = null;
            JSONObject reputation = null;
            int index = 0;
            for (BadgeDTO badgeDTO2 : allBadges) {
                if ((long)badgeDTO2.getNeededScore() > score) continue;
                ++index;
            }
            if (index > 0) {
                badgeDTO2 = allBadges.get(index - 1);
                reputation = new JSONObject();
                String iconUrl = "/portal/rest/gamification/reputation/badge/" + badgeDTO2.getId() + "/avatar";
                reputation.put("url", (Object)iconUrl);
                reputation.put("description", (Object)badgeDTO2.getDescription());
                reputation.put("id", (Object)badgeDTO2.getId());
                reputation.put("title", (Object)badgeDTO2.getTitle());
                reputation.put("zone", (Object)badgeDTO2.getProgram().getTitle());
                reputation.put("programId", badgeDTO2.getProgram().getId());
                reputation.put("programLabel", (Object)badgeDTO2.getProgram().getTitle());
                reputation.put("level", index);
                reputation.put("startScore", badgeDTO2.getNeededScore());
                reputation.put("score", score);
                reputation.put("endScore", (Object)this.computeBadgeNextLevel(allBadges, index));
                userBadges.put((Object)reputation);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String computeBadgeNextLevel(List<BadgeDTO> allBadges, int index) {
        if (index >= 0 && index < allBadges.size()) {
            return String.valueOf(allBadges.get(index).getNeededScore());
        }
        return "";
    }

    private String computeLevel(List<BadgeDTO> allBadges, int index) {
        if (index >= 0 && index < allBadges.size()) {
            return String.valueOf(allBadges.get(index).getNeededScore());
        }
        return "";
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="won")
    public Response getallBadges(@Context UriInfo uriInfo, @Context HttpServletRequest request, @QueryParam(value="url") String url) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            String profilePageOwner = conversationState.getIdentity().getUserId();
            try {
                if (url != null && (profilePageOwner = GamificationUtils.extractProfileOwnerFromUrl(url, "/")).equals("profile")) {
                    profilePageOwner = conversationState.getIdentity().getUserId();
                }
                JSONArray allBadges = new JSONArray();
                Identity id = this.identityManager.getOrCreateIdentity("organization", profilePageOwner);
                if (id == null) {
                    profilePageOwner = conversationState.getIdentity().getUserId();
                    id = this.identityManager.getOrCreateIdentity("organization", profilePageOwner);
                }
                String actorId = id.getId();
                List<ProfileReputation> badgesByProgram = this.realizationService.getScorePerProgramByIdentityId(actorId);
                allBadges = this.buildProfilBadges(badgesByProgram);
                return Response.ok().cacheControl(this.cacheControl).entity((Object)allBadges.toString()).build();
            }
            catch (Exception e) {
                LOG.error("Error loading badges belong to user : {} ", new Object[]{profilePageOwner, e});
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error loading user's badges").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="stats")
    public Response stat(@Context UriInfo uriInfo, @Context HttpServletRequest request, @QueryParam(value="url") String url) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            String profilePageOwner = conversationState.getIdentity().getUserId();
            try {
                Identity id;
                if (url != null && (profilePageOwner = GamificationUtils.extractProfileOwnerFromUrl(url, "/")).equals("profile")) {
                    profilePageOwner = conversationState.getIdentity().getUserId();
                }
                if ((id = this.identityManager.getOrCreateIdentity("organization", profilePageOwner)) == null) {
                    profilePageOwner = conversationState.getIdentity().getUserId();
                    id = this.identityManager.getOrCreateIdentity("organization", profilePageOwner);
                }
                String actorId = id.getId();
                List<PiechartLeaderboard> userStats = this.realizationService.getLeaderboardStatsByIdentityId(actorId, null, null, null);
                return Response.ok(userStats, (String)"application/json").cacheControl(this.cacheControl).build();
            }
            catch (Exception e) {
                LOG.error("Error building statistics for user {} ", new Object[]{profilePageOwner, e});
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error building statistics").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="otherBadges")
    public Response getOtherBadges(@Context UriInfo uriInfo, @Context HttpServletRequest request, @QueryParam(value="url") String url) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            String profilePageOwner = conversationState.getIdentity().getUserId();
            try {
                if (url != null && (profilePageOwner = GamificationUtils.extractProfileOwnerFromUrl(url, "/")).equals("profile")) {
                    profilePageOwner = conversationState.getIdentity().getUserId();
                }
                JSONArray allBadges = new JSONArray();
                Identity id = this.identityManager.getOrCreateIdentity("organization", profilePageOwner);
                if (id == null) {
                    profilePageOwner = conversationState.getIdentity().getUserId();
                    id = this.identityManager.getOrCreateIdentity("organization", profilePageOwner);
                }
                String actorId = id.getId();
                List<ProfileReputation> badgesByProgram = this.realizationService.getScorePerProgramByIdentityId(actorId);
                allBadges = this.buildProfileNextBadges(badgesByProgram);
                return Response.ok().cacheControl(this.cacheControl).entity((Object)allBadges.toString()).build();
            }
            catch (Exception e) {
                LOG.error("Error loading badges belong to user : {} ", new Object[]{profilePageOwner, e});
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error loading user's badges").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    private void buildWonBadges(long programId, long score, JSONArray userBadges) {
        List<BadgeDTO> allBadges = this.badgeService.findEnabledBadgesByProgramId(programId);
        JSONObject reputation = null;
        int i = 0;
        int k = 0;
        for (BadgeDTO badgeDTO : allBadges) {
            reputation = new JSONObject();
            try {
                String iconUrl = "/portal/rest/gamification/reputation/badge/" + badgeDTO.getId() + "/avatar";
                reputation.put("url", (Object)iconUrl);
                reputation.put("description", (Object)badgeDTO.getDescription());
                reputation.put("id", (Object)badgeDTO.getId());
                reputation.put("title", (Object)badgeDTO.getTitle());
                reputation.put("zone", (Object)badgeDTO.getProgram().getTitle());
                reputation.put("level", ++k);
                reputation.put("startScore", badgeDTO.getNeededScore());
                reputation.put("endScore", (Object)this.computeBadgeNextLevel(allBadges, i + 1));
                userBadges.put((Object)reputation);
                ++i;
            }
            catch (Exception e) {
                LOG.error((Object)"Error while building badges", (Throwable)e);
            }
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="AllofBadges")
    public Response getAllOfBadges(@Context UriInfo uriInfo, @Context HttpServletRequest request, @QueryParam(value="url") String url) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            String profilePageOwner = conversationState.getIdentity().getUserId();
            try {
                if (url != null && (profilePageOwner = GamificationUtils.extractProfileOwnerFromUrl(url, "/")).equals("profile")) {
                    profilePageOwner = conversationState.getIdentity().getUserId();
                }
                JSONArray allBadges = new JSONArray();
                Identity id = this.identityManager.getOrCreateIdentity("organization", profilePageOwner);
                if (id == null) {
                    profilePageOwner = conversationState.getIdentity().getUserId();
                    id = this.identityManager.getOrCreateIdentity("organization", profilePageOwner);
                }
                String actorId = id.getId();
                List<ProfileReputation> badgesByProgram = this.realizationService.getScorePerProgramByIdentityId(actorId);
                allBadges = this.buildallBadges(badgesByProgram, url);
                return Response.ok().cacheControl(this.cacheControl).entity((Object)allBadges.toString()).build();
            }
            catch (Exception e) {
                LOG.error("Error loading badges belong to user : {} ", new Object[]{profilePageOwner, e});
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error loading user's badges").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    private JSONArray buildProfileNextBadges(List<ProfileReputation> reputationLis) {
        JSONArray allBadges = new JSONArray();
        if (reputationLis != null && !reputationLis.isEmpty()) {
            for (ProfileReputation rep : reputationLis) {
                this.buildnextWinBadges(rep.getProgramId(), rep.getScore(), allBadges);
            }
        }
        return allBadges;
    }

    private JSONArray buildallBadges(List<ProfileReputation> reputationLis, @QueryParam(value="url") String url) {
        Identity id;
        ConversationState conversationState = ConversationState.getCurrent();
        JSONArray allBadges = new JSONArray();
        String profilePageOwner = conversationState.getIdentity().getUserId();
        if (url != null && (profilePageOwner = GamificationUtils.extractProfileOwnerFromUrl(url, "/")).equals("profile")) {
            profilePageOwner = conversationState.getIdentity().getUserId();
        }
        if ((id = this.identityManager.getOrCreateIdentity("organization", profilePageOwner)) == null) {
            profilePageOwner = conversationState.getIdentity().getUserId();
            id = this.identityManager.getOrCreateIdentity("organization", profilePageOwner);
        }
        if (conversationState != null && reputationLis != null && !reputationLis.isEmpty()) {
            for (ProfileReputation rep : reputationLis) {
                this.buildWonBadges(rep.getProgramId(), rep.getScore(), allBadges);
            }
        }
        return allBadges;
    }

    private JSONArray buildProfilBadges(List<ProfileReputation> reputationLis) {
        JSONArray allBadges = new JSONArray();
        if (reputationLis != null && !reputationLis.isEmpty()) {
            for (ProfileReputation rep : reputationLis) {
                this.buildWonBadges(rep.getProgramId(), rep.getScore(), allBadges);
            }
        }
        return allBadges;
    }

    private void buildnextWinBadges(long programId, long score, JSONArray userBadges) {
        List<BadgeDTO> allBadges = this.badgeService.findEnabledBadgesByProgramId(programId);
        JSONObject reputation = null;
        int i = 0;
        int k = 0;
        for (BadgeDTO badgeDTO : allBadges) {
            if ((long)badgeDTO.getNeededScore() <= score) continue;
            reputation = new JSONObject();
            try {
                String iconUrl = "/portal/rest/gamification/reputation/badge/" + badgeDTO.getId() + "/avatar";
                reputation.put("url", (Object)iconUrl);
                reputation.put("description", (Object)badgeDTO.getDescription());
                reputation.put("id", (Object)badgeDTO.getId());
                reputation.put("title", (Object)badgeDTO.getTitle());
                reputation.put("zone", (Object)badgeDTO.getProgram().getTitle());
                reputation.put("level", ++k);
                reputation.put("startScore", badgeDTO.getNeededScore());
                reputation.put("endScore", (Object)this.computeLevel(allBadges, i + 1));
                userBadges.put((Object)reputation);
                ++i;
            }
            catch (Exception exception) {}
        }
    }
}

