/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.storage.mapper;

import io.meeds.gamification.entity.EventEntity;
import io.meeds.gamification.model.EventDTO;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class EventMapper {
    private EventMapper() {
    }

    public static EventEntity toEntity(EventDTO eventDTO) {
        if (eventDTO == null) {
            return null;
        }
        EventEntity eventEntity = new EventEntity();
        if (eventDTO.getId() > 0L) {
            eventEntity.setId(eventDTO.getId());
        }
        if (StringUtils.isNotBlank((CharSequence)eventDTO.getTitle())) {
            eventEntity.setTitle(eventDTO.getTitle());
        }
        if (StringUtils.isNotBlank((CharSequence)eventDTO.getType())) {
            eventEntity.setType(eventDTO.getType());
        }
        if (StringUtils.isNotBlank((CharSequence)eventDTO.getTrigger())) {
            eventEntity.setTrigger(eventDTO.getTrigger());
        }
        if (eventDTO.getProperties() != null) {
            eventEntity.setProperties(eventDTO.getProperties());
        }
        return eventEntity;
    }

    public static EventDTO fromEntity(EventEntity eventEntity) {
        if (eventEntity == null) {
            return null;
        }
        return new EventDTO(eventEntity.getId() != null ? eventEntity.getId() : 0L, eventEntity.getTitle(), eventEntity.getType(), eventEntity.getTrigger(), null, eventEntity.getProperties());
    }

    public static List<EventDTO> fromEntities(List<EventEntity> eventEntities) {
        return eventEntities.stream().filter(Objects::nonNull).map(EventMapper::fromEntity).toList();
    }
}

