/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.storage;

import io.meeds.gamification.dao.ConnectorAccountDAO;
import io.meeds.gamification.entity.ConnectorAccountEntity;
import io.meeds.gamification.model.ConnectorAccount;
import io.meeds.gamification.storage.mapper.ConnectorMapper;
import org.exoplatform.commons.ObjectAlreadyExistsException;

public class ConnectorAccountStorage {
    private ConnectorAccountDAO connectorAccountDAO;

    public ConnectorAccountStorage(ConnectorAccountDAO connectorAccountDAO) {
        this.connectorAccountDAO = connectorAccountDAO;
    }

    public String getConnectorRemoteId(String connectorName, long userId) {
        return this.connectorAccountDAO.getConnectorRemoteId(connectorName, userId);
    }

    public long getUserIdentityId(String connectorName, String connectorRemoteId) {
        return this.connectorAccountDAO.getAssociatedUserIdentityId(connectorName, connectorRemoteId);
    }

    public ConnectorAccount getConnectorAccount(String connectorName, long userId) {
        ConnectorAccountEntity connectorAccountEntity = this.connectorAccountDAO.getConnectorAccountByNameAndUserId(connectorName, userId);
        return ConnectorMapper.fromEntity(connectorAccountEntity);
    }

    public void saveConnectorAccount(ConnectorAccount connectorAccount) throws ObjectAlreadyExistsException {
        long userIdentityId = this.getUserIdentityId(connectorAccount.getConnectorName(), connectorAccount.getRemoteId());
        if (userIdentityId != 0L) {
            throw new ObjectAlreadyExistsException((Object)connectorAccount);
        }
        ConnectorAccountEntity connectorAccountEntity = ConnectorMapper.toEntity(connectorAccount);
        connectorAccountEntity.setId(null);
        this.connectorAccountDAO.create(connectorAccountEntity);
    }

    public ConnectorAccount deleteConnectorAccount(String connectorName, String connectorRemoteId) {
        ConnectorAccountEntity connectorAccountEntity = this.connectorAccountDAO.getConnectorAccountByNameAndRemoteId(connectorName, connectorRemoteId);
        if (connectorAccountEntity != null) {
            this.connectorAccountDAO.delete(connectorAccountEntity);
        }
        return ConnectorMapper.fromEntity(connectorAccountEntity);
    }
}

