/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.storage.mapper;

import io.meeds.gamification.constant.IdentityType;
import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.entity.RealizationEntity;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.storage.ProgramStorage;
import io.meeds.gamification.storage.RuleStorage;
import io.meeds.gamification.storage.mapper.ProgramMapper;
import io.meeds.gamification.storage.mapper.RuleMapper;
import io.meeds.gamification.utils.Utils;
import java.util.Date;

public class RealizationMapper {
    private RealizationMapper() {
    }

    public static RealizationDTO fromEntity(ProgramStorage programStorage, RealizationEntity realizationEntity) {
        if (realizationEntity == null) {
            return null;
        }
        String objectId = realizationEntity.getActivityId() != null && realizationEntity.getActivityId() != 0L ? String.valueOf(realizationEntity.getActivityId()) : realizationEntity.getObjectId();
        return new RealizationDTO(realizationEntity.getId(), realizationEntity.getEarnerId(), realizationEntity.getEarnerType().toString(), realizationEntity.getGlobalScore(), realizationEntity.getActionTitle(), realizationEntity.getDomainEntity() == null ? null : programStorage.getProgramById(realizationEntity.getDomainEntity().getId()), realizationEntity.getDomain(), realizationEntity.getContext(), realizationEntity.getActionScore(), realizationEntity.getReceiver(), objectId, realizationEntity.getObjectType(), realizationEntity.getRuleEntity() == null ? null : realizationEntity.getRuleEntity().getId(), realizationEntity.getActivityId(), realizationEntity.getComment(), realizationEntity.getCreator(), realizationEntity.getCreatedBy(), Utils.toRFC3339Date(realizationEntity.getCreatedDate()), realizationEntity.getLastModifiedBy(), Utils.toRFC3339Date(realizationEntity.getLastModifiedDate()), Utils.toRFC3339Date(realizationEntity.getSendingDate()), realizationEntity.getStatus().name(), realizationEntity.getType(), realizationEntity.getReviewerId());
    }

    public static RealizationEntity toEntity(RuleStorage ruleStorage, RealizationDTO realization) {
        if (realization == null) {
            return null;
        }
        RealizationEntity realizationEntity = new RealizationEntity();
        realizationEntity.setId(realization.getId());
        realizationEntity.setDomainEntity(ProgramMapper.toEntity(realization.getProgram()));
        realizationEntity.setDomain(realization.getProgram().getTitle());
        realizationEntity.setActionTitle(realization.getActionTitle());
        realizationEntity.setActionScore(realization.getActionScore());
        realizationEntity.setGlobalScore(realization.getGlobalScore());
        realizationEntity.setActivityId(realization.getActivityId());
        realizationEntity.setObjectId(realization.getObjectId());
        realizationEntity.setObjectType(realization.getObjectType());
        realizationEntity.setReceiver(realization.getReceiver());
        realizationEntity.setEarnerId(realization.getEarnerId());
        realizationEntity.setEarnerType(IdentityType.getType(realization.getEarnerType()));
        realizationEntity.setContext(realization.getContext());
        realizationEntity.setComment(realization.getComment());
        realizationEntity.setRuleEntity(RuleMapper.toEntity(ruleStorage.findRuleById(realization.getRuleId())));
        realizationEntity.setCreator(realization.getCreator());
        realizationEntity.setStatus(RealizationStatus.valueOf(realization.getStatus()));
        realizationEntity.setType(realization.getType());
        if (realization.getCreatedDate() != null) {
            realizationEntity.setCreatedDate(Utils.parseRFC3339Date(realization.getCreatedDate()));
        } else {
            realizationEntity.setCreatedDate(new Date());
        }
        if (realization.getLastModifiedDate() != null) {
            realizationEntity.setLastModifiedDate(Utils.parseRFC3339Date(realization.getLastModifiedDate()));
        }
        if (realization.getSendingDate() != null) {
            realizationEntity.setSendingDate(Utils.parseRFC3339Date(realization.getSendingDate()));
        }
        if (realization.getReviewerId() != null) {
            realizationEntity.setReviewerId(realization.getReviewerId());
        }
        realizationEntity.setCreatedBy(realization.getCreatedBy() != null ? realization.getCreatedBy() : "SYSTEM");
        realizationEntity.setLastModifiedBy(realization.getLastModifiedBy() != null ? realization.getLastModifiedBy() : "SYSTEM");
        return realizationEntity;
    }
}

