/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service.injection;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.gamification.model.ProgramDescriptor;
import io.meeds.gamification.service.injection.ProgramTranslationImportService$AjcClosure1;
import io.meeds.gamification.service.injection.ProgramTranslationImportService$AjcClosure3;
import io.meeds.social.translation.service.TranslationService;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProgramTranslationImportService {
    private static final Log LOG;
    @Autowired
    private TranslationService translationService;
    @Autowired
    private LocaleConfigService localeConfigService;
    @Autowired
    private ResourceBundleService resourceBundleService;
    private final Map<String, List<Runnable>> postImportProcessors = new ConcurrentHashMap<String, List<Runnable>>();
    private final Map<Locale, ResourceBundle> bundles = new ConcurrentHashMap<Locale, ResourceBundle>();
    private final ExecutorService executorService = Executors.newFixedThreadPool(1);
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    @PreDestroy
    protected void destroy() {
        this.executorService.shutdownNow();
    }

    public void saveProgramDescriptionTranslationLabels(long programId, List<ProgramDescriptor.Description> descriptions) {
        this.postImportProcessors.computeIfAbsent("program", k -> new ArrayList()).add(() -> this.saveProgramDescriptionTranslationLabelsForAllLanguages(programId, descriptions));
    }

    public void saveTranslationLabels(String objectType, long objectId, String fieldName, Map<String, String> labels, String appendEmoji) {
        this.postImportProcessors.computeIfAbsent(objectType, k -> new ArrayList()).add(() -> this.saveTranslationLabelsForAllLanguages(objectType, objectId, fieldName, labels, appendEmoji, this.getI18NLabel((String)labels.get("en"), Locale.ENGLISH)));
    }

    public void postImport(String objectType) {
        this.postImportProcessors.computeIfAbsent(objectType, k -> new ArrayList()).forEach(this.executorService::execute);
        this.postImportProcessors.remove(objectType);
        this.bundles.clear();
    }

    public String getI18NLabel(String label, Locale locale) {
        return this.getI18NLabel(label, locale, null);
    }

    public String getProgramDescriptionLabel(List<ProgramDescriptor.Description> descriptions, Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        if (CollectionUtils.isNotEmpty(descriptions)) {
            for (ProgramDescriptor.Description description : descriptions) {
                String i18nKey = description.getInstruction().get("en");
                stringBuilder.append("<div>").append(description.getEmoji()).append(" ").append(this.getI18NLabel(i18nKey, locale)).append("</div>\n");
            }
            stringBuilder.append("<div><br>").append(this.getI18NLabel("gamification.defaultProgram.label.seeDocumentation", locale).replace("$DOCUMENTATION", "https://docs.meeds.io/meeds-guides")).append("</div>\n");
        }
        return stringBuilder.toString();
    }

    @ContainerTransactional
    private void saveProgramDescriptionTranslationLabelsForAllLanguages(long objectId, List<ProgramDescriptor.Description> descriptions) {
        long l = objectId;
        List<ProgramDescriptor.Description> list = descriptions;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)Conversions.longObject((long)l), list);
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), list, joinPoint};
        ProgramTranslationImportService$AjcClosure1 programTranslationImportService$AjcClosure1 = new ProgramTranslationImportService$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(programTranslationImportService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @ContainerTransactional
    private void saveTranslationLabelsForAllLanguages(String objectType, long objectId, String fieldName, Map<String, String> labels, String appendEmoji, String defaultLabel) {
        String string = objectType;
        long l = objectId;
        String string2 = fieldName;
        Map<String, String> map = labels;
        String string3 = appendEmoji;
        String string4 = defaultLabel;
        Object[] objectArray = new Object[]{string, Conversions.longObject((long)l), string2, map, string3, string4};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, Conversions.longObject((long)l), string2, map, string3, string4, joinPoint};
        ProgramTranslationImportService$AjcClosure3 programTranslationImportService$AjcClosure3 = new ProgramTranslationImportService$AjcClosure3(objectArray2);
        ContainerTransactionalAspect.aspectOf().around(programTranslationImportService$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    private String getI18NLabel(String label, Locale locale, String defaultLabel) {
        try {
            ResourceBundle resourceBundle = this.getResourceBundle(locale);
            if (resourceBundle != null && resourceBundle.containsKey(label)) {
                return resourceBundle.getString(label);
            }
        }
        catch (Exception e) {
            LOG.debug("Resource Bundle not found with locale {}", new Object[]{locale, e});
        }
        return defaultLabel == null ? label : defaultLabel;
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        return this.bundles.computeIfAbsent(locale, l -> this.resourceBundleService.getResourceBundle("locale.addon.Gamification", l, PortalContainer.getInstance().getPortalClassLoader()));
    }

    static {
        ProgramTranslationImportService.ajc$preClinit();
        LOG = ExoLogger.getLogger(ProgramTranslationImportService.class);
    }

    static /* synthetic */ void saveProgramDescriptionTranslationLabelsForAllLanguages_aroundBody0(ProgramTranslationImportService ajc$this, long objectId, List descriptions, JoinPoint joinPoint) {
        HashMap translations = new HashMap();
        ajc$this.localeConfigService.getLocalConfigs().stream().filter(config -> !StringUtils.equals((CharSequence)config.getLocale().toLanguageTag(), (CharSequence)"ma")).forEach(config -> translations.put(config.getLocale(), this.getProgramDescriptionLabel(descriptions, config.getLocale())));
        ajc$this.translationService.saveTranslationLabels("program", objectId, "description", translations);
    }

    static /* synthetic */ void saveTranslationLabelsForAllLanguages_aroundBody2(ProgramTranslationImportService ajc$this, String objectType, long objectId, String fieldName, Map labels, String appendEmoji, String defaultLabel, JoinPoint joinPoint) {
        String i18nKey = (String)labels.get("en");
        HashMap translations = new HashMap();
        ajc$this.localeConfigService.getLocalConfigs().stream().filter(config -> !StringUtils.equals((CharSequence)config.getLocale().toLanguageTag(), (CharSequence)"ma")).forEach(config -> translations.put(config.getLocale(), appendEmoji != null ? this.getI18NLabel(i18nKey, config.getLocale(), defaultLabel) + " " + appendEmoji : this.getI18NLabel(i18nKey, config.getLocale(), defaultLabel)));
        ajc$this.translationService.saveTranslationLabels(objectType, objectId, fieldName, translations);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ProgramTranslationImportService.java", ProgramTranslationImportService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "saveProgramDescriptionTranslationLabelsForAllLanguages", "io.meeds.gamification.service.injection.ProgramTranslationImportService", "long:java.util.List", "objectId:descriptions", "", "void"), 122);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "saveTranslationLabelsForAllLanguages", "io.meeds.gamification.service.injection.ProgramTranslationImportService", "java.lang.String:long:java.lang.String:java.util.Map:java.lang.String:java.lang.String", "objectType:objectId:fieldName:labels:appendEmoji:defaultLabel", "", "void"), 142);
    }
}

