/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.rest.builder;

import io.meeds.gamification.model.RemoteConnector;
import io.meeds.gamification.rest.model.ConnectorRestEntity;
import io.meeds.gamification.service.ConnectorService;
import io.meeds.gamification.service.ConnectorSettingService;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ConnectorBuilder {
    private ConnectorBuilder() {
    }

    public static ConnectorRestEntity toRestEntity(ConnectorService connectorService, ConnectorSettingService connectorSettingService, RemoteConnector remoteConnector, List<String> expandFields, String username) {
        if (remoteConnector == null) {
            return null;
        }
        String identifier = null;
        String secretKey = null;
        if (CollectionUtils.isNotEmpty(expandFields)) {
            if (expandFields.contains("userIdentifier")) {
                identifier = connectorService.getConnectorRemoteId(remoteConnector.getName(), username);
            }
            if (expandFields.contains("secretKey")) {
                secretKey = connectorSettingService.getConnectorSecretKey(remoteConnector.getName());
            }
        }
        return new ConnectorRestEntity(remoteConnector.getName(), remoteConnector.getApiKey(), remoteConnector.getRedirectUrl(), StringUtils.isNotBlank((CharSequence)identifier) ? identifier : null, StringUtils.isNotBlank((CharSequence)secretKey) ? secretKey : null, remoteConnector.isEnabled());
    }

    public static List<ConnectorRestEntity> toRestEntities(ConnectorService connectorService, ConnectorSettingService connectorSettingService, Collection<RemoteConnector> remoteConnectors, List<String> expandFields, String username) {
        return remoteConnectors.stream().map(remoteConnector -> ConnectorBuilder.toRestEntity(connectorService, connectorSettingService, remoteConnector, expandFields, username)).toList();
    }
}

