/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.entity;

import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.constant.IdentityType;
import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.entity.AbstractAuditingEntity;
import io.meeds.gamification.entity.ProgramEntity;
import io.meeds.gamification.entity.RuleEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedNativeQueries;
import jakarta.persistence.NamedNativeQuery;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.Date;
import lombok.Generated;

@Entity(name="RealizationEntity")
@Table(name="GAMIFICATION_ACTIONS_HISTORY")
@NamedNativeQueries(value={@NamedNativeQuery(name="RealizationEntity.getLeaderboardRank", query="SELECT LEADERBOARD.rankIndex FROM ( SELECT earnerId, ROW_NUMBER() OVER() rankIndex FROM  (SELECT g.EARNER_ID earnerId, SUM(g.ACTION_SCORE) total FROM GAMIFICATION_ACTIONS_HISTORY g WHERE g.EARNER_TYPE = :earnerType AND g.STATUS = :status  GROUP BY g.EARNER_ID ORDER BY total DESC, earnerId DESC) GROUPED_LEADERBOARD) LEADERBOARD WHERE LEADERBOARD.earnerId = :earnerId"), @NamedNativeQuery(name="RealizationEntity.getLeaderboardRankByDateAndProgramId", query="SELECT LEADERBOARD.rankIndex FROM ( SELECT earnerId, ROW_NUMBER() OVER() rankIndex FROM  (SELECT g.EARNER_ID earnerId, SUM(g.ACTION_SCORE) total FROM GAMIFICATION_ACTIONS_HISTORY g WHERE g.CREATED_DATE >= :date AND g.DOMAIN_ID = :domainId AND g.EARNER_TYPE = :earnerType AND g.STATUS = :status  GROUP BY g.EARNER_ID ORDER BY total DESC, earnerId DESC) GROUPED_LEADERBOARD ) LEADERBOARD WHERE LEADERBOARD.earnerId = :earnerId"), @NamedNativeQuery(name="RealizationEntity.getLeaderboardRankByProgramId", query="SELECT LEADERBOARD.rankIndex FROM ( SELECT earnerId, ROW_NUMBER() OVER() rankIndex FROM  (SELECT g.EARNER_ID earnerId, SUM(g.ACTION_SCORE) total FROM GAMIFICATION_ACTIONS_HISTORY g WHERE g.DOMAIN_ID = :domainId AND g.EARNER_TYPE = :earnerType AND g.STATUS = :status  GROUP BY g.EARNER_ID ORDER BY total DESC, earnerId DESC) GROUPED_LEADERBOARD) LEADERBOARD WHERE LEADERBOARD.earnerId = :earnerId"), @NamedNativeQuery(name="RealizationEntity.getLeaderboardRankByDate", query="SELECT LEADERBOARD.rankIndex FROM ( SELECT earnerId, ROW_NUMBER() OVER() rankIndex FROM  (SELECT g.EARNER_ID earnerId, SUM(g.ACTION_SCORE) total FROM GAMIFICATION_ACTIONS_HISTORY g WHERE g.CREATED_DATE >= :date AND g.EARNER_TYPE = :earnerType AND g.STATUS = :status  GROUP BY g.EARNER_ID ORDER BY total DESC, earnerId DESC) GROUPED_LEADERBOARD) LEADERBOARD WHERE LEADERBOARD.earnerId = :earnerId")})
@NamedQueries(value={@NamedQuery(name="RealizationEntity.getLeaderboard", query="SELECT new io.meeds.gamification.model.StandardLeaderboard(g.earnerId as earnerId, SUM(g.actionScore) as total) FROM RealizationEntity g WHERE g.earnerType = :earnerType AND g.status = :status GROUP BY g.earnerId ORDER BY total DESC, earnerId DESC"), @NamedQuery(name="RealizationEntity.getLeaderboardByDateAndProgramId", query="SELECT new io.meeds.gamification.model.StandardLeaderboard(g.earnerId as earnerId, SUM(g.actionScore) as total) FROM RealizationEntity g WHERE g.createdDate >= :date AND g.domainEntity.id = :domainId AND g.earnerType = :earnerType AND g.status = :status GROUP BY  g.earnerId ORDER BY total DESC, earnerId DESC"), @NamedQuery(name="RealizationEntity.getLeaderboardByProgramId", query="SELECT new io.meeds.gamification.model.StandardLeaderboard(g.earnerId as earnerId, SUM(g.actionScore) as total) FROM RealizationEntity g WHERE g.domainEntity.id = :domainId AND g.earnerType = :earnerType AND g.status = :status GROUP BY g.earnerId ORDER BY total DESC, earnerId DESC"), @NamedQuery(name="RealizationEntity.getLeaderboardByDate", query="SELECT new io.meeds.gamification.model.StandardLeaderboard(g.earnerId as earnerId, SUM(g.actionScore) as total) FROM RealizationEntity g WHERE g.createdDate >= :date AND g.earnerType = :earnerType AND g.status = :status GROUP BY g.earnerId ORDER BY total DESC, earnerId DESC"), @NamedQuery(name="RealizationEntity.getLeaderboardStatsByIdentityId", query="SELECT new io.meeds.gamification.model.PiechartLeaderboard(g.domainEntity.id as domainId, SUM(g.actionScore) as total) FROM RealizationEntity g WHERE g.earnerId = :earnerId AND g.domainEntity IS NOT NULL AND g.actionScore > 0 AND g.status = :status GROUP BY g.domainEntity.id ORDER BY total DESC, domainId DESC"), @NamedQuery(name="RealizationEntity.getLeaderboardStatsByIdentityIdAndDates", query="SELECT new io.meeds.gamification.model.PiechartLeaderboard(g.domainEntity.id as domainId, SUM(g.actionScore) as total) FROM RealizationEntity g WHERE g.earnerId = :earnerId AND g.domainEntity IS NOT NULL AND g.actionScore > 0 AND g.status = :status AND g.createdDate >= :fromDate AND g.createdDate < :toDate GROUP BY  g.domainEntity.id ORDER BY total DESC, domainId DESC"), @NamedQuery(name="RealizationEntity.getScoreByIdentityId", query=" SELECT SUM(g.actionScore) FROM RealizationEntity g WHERE g.earnerId = :earnerId AND g.status = :status"), @NamedQuery(name="RealizationEntity.getScorePerProgramByIdentityId", query="SELECT new io.meeds.gamification.model.ProfileReputation(g.domainEntity.id,SUM(g.actionScore)) FROM RealizationEntity g WHERE g.earnerId = :earnerId AND g.status = :status AND g.domainEntity IS NOT NULL GROUP BY g.domainEntity.id"), @NamedQuery(name="RealizationEntity.getScoreByIdentityIdAndBetweenDates", query="SELECT SUM(g.actionScore) as total FROM RealizationEntity g  WHERE g.earnerId = :earnerId AND g.status = :status AND g.createdDate >= :fromDate AND g.createdDate < :toDate"), @NamedQuery(name="RealizationEntity.getScoreByIdentityIdsAndBetweenDates", query="SELECT g.earnerId,SUM(g.actionScore) as total FROM RealizationEntity g  WHERE g.earnerId IN :earnersId AND g.status = :status AND g.createdDate >= :fromDate AND g.createdDate < :toDate GROUP BY g.earnerId"), @NamedQuery(name="RealizationEntity.countRealizationsInPeriod", query="SELECT COUNT(a) FROM RealizationEntity a WHERE a.ruleEntity.id = :ruleId AND a.earnerId = :earnerId AND a.status IN (:status) AND (a.sendingDate >= :date OR (a.sendingDate IS NULL AND a.createdDate >= :date))"), @NamedQuery(name="RealizationEntity.countRealizationsByRuleIdAndEarnerId", query="SELECT COUNT(a) FROM RealizationEntity a WHERE a.ruleEntity.id = :ruleId AND a.earnerId = :earnerId AND a.status = :status"), @NamedQuery(name="RealizationEntity.findRealizationsByRuleIdAndEarnerIdAndReceiverAndObjectId", query="SELECT g.id FROM RealizationEntity g WHERE g.ruleEntity.id = :ruleId AND g.earnerId = :earnerId AND g.receiver = :receiverId AND g.objectId = :objectId AND g.objectType = :objectType AND g.status IN (:status) ORDER BY g.id DESC"), @NamedQuery(name="RealizationEntity.getRealizationsByObjectIdAndObjectType", query="SELECT g.id FROM RealizationEntity g WHERE g.objectId = :objectId AND g.objectType = :objectType"), @NamedQuery(name="RealizationEntity.countParticipantsBetweenDates", query="SELECT COUNT(DISTINCT g.earnerId) FROM RealizationEntity g WHERE g.createdDate >= :fromDate AND g.createdDate < :toDate AND g.earnerType = :earnerType AND g.status = :status")})
public class RealizationEntity
extends AbstractAuditingEntity
implements Serializable {
    private static final long serialVersionUID = 2554394120711454093L;
    @Id
    @SequenceGenerator(name="SEQ_GAMIFICATION_SCORE_HISTORY_ID", sequenceName="SEQ_GAMIFICATION_SCORE_HISTORY_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_GAMIFICATION_SCORE_HISTORY_ID")
    @Column(name="ID")
    protected Long id;
    @Column(name="EARNER_ID", nullable=false)
    private String earnerId;
    @Column(name="EARNER_TYPE", nullable=false)
    private IdentityType earnerType;
    @Column(name="GLOBAL_SCORE", nullable=false)
    protected long globalScore;
    @Column(name="ACTION_TITLE", nullable=false)
    private String actionTitle;
    @Column(name="DOMAIN", nullable=false)
    private String domain;
    @Column(name="CONTEXT", nullable=true)
    private String context;
    @Column(name="ACTION_SCORE", nullable=false)
    private long actionScore;
    @Column(name="RECEIVER", nullable=false)
    private String receiver;
    @Column(name="OBJECT_ID")
    private String objectId;
    @Column(name="OBJECT_TYPE")
    private String objectType;
    @ManyToOne
    @JoinColumn(name="DOMAIN_ID")
    private ProgramEntity domainEntity;
    @ManyToOne
    @JoinColumn(name="RULE_ID")
    private RuleEntity ruleEntity;
    @Column(name="ACTIVITY_ID")
    private Long activityId;
    @Column(name="COMMENT")
    private String comment;
    @Column(name="CREATOR_ID")
    private Long creator;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="STATUS", nullable=false)
    private RealizationStatus status;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="TYPE", nullable=false)
    private EntityType type;
    @Column(name="SENDING_DATE")
    protected Date sendingDate;
    @Column(name="REVIEWER_ID")
    private Long reviewerId;

    @Generated
    public RealizationEntity() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getEarnerId() {
        return this.earnerId;
    }

    @Generated
    public IdentityType getEarnerType() {
        return this.earnerType;
    }

    @Generated
    public long getGlobalScore() {
        return this.globalScore;
    }

    @Generated
    public String getActionTitle() {
        return this.actionTitle;
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public String getContext() {
        return this.context;
    }

    @Generated
    public long getActionScore() {
        return this.actionScore;
    }

    @Generated
    public String getReceiver() {
        return this.receiver;
    }

    @Generated
    public String getObjectId() {
        return this.objectId;
    }

    @Generated
    public String getObjectType() {
        return this.objectType;
    }

    @Generated
    public ProgramEntity getDomainEntity() {
        return this.domainEntity;
    }

    @Generated
    public RuleEntity getRuleEntity() {
        return this.ruleEntity;
    }

    @Generated
    public Long getActivityId() {
        return this.activityId;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public Long getCreator() {
        return this.creator;
    }

    @Generated
    public RealizationStatus getStatus() {
        return this.status;
    }

    @Generated
    public EntityType getType() {
        return this.type;
    }

    @Generated
    public Date getSendingDate() {
        return this.sendingDate;
    }

    @Generated
    public Long getReviewerId() {
        return this.reviewerId;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEarnerId(String earnerId) {
        this.earnerId = earnerId;
    }

    @Generated
    public void setEarnerType(IdentityType earnerType) {
        this.earnerType = earnerType;
    }

    @Generated
    public void setGlobalScore(long globalScore) {
        this.globalScore = globalScore;
    }

    @Generated
    public void setActionTitle(String actionTitle) {
        this.actionTitle = actionTitle;
    }

    @Generated
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Generated
    public void setContext(String context) {
        this.context = context;
    }

    @Generated
    public void setActionScore(long actionScore) {
        this.actionScore = actionScore;
    }

    @Generated
    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    @Generated
    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    @Generated
    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    @Generated
    public void setDomainEntity(ProgramEntity domainEntity) {
        this.domainEntity = domainEntity;
    }

    @Generated
    public void setRuleEntity(RuleEntity ruleEntity) {
        this.ruleEntity = ruleEntity;
    }

    @Generated
    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public void setCreator(Long creator) {
        this.creator = creator;
    }

    @Generated
    public void setStatus(RealizationStatus status) {
        this.status = status;
    }

    @Generated
    public void setType(EntityType type) {
        this.type = type;
    }

    @Generated
    public void setSendingDate(Date sendingDate) {
        this.sendingDate = sendingDate;
    }

    @Generated
    public void setReviewerId(Long reviewerId) {
        this.reviewerId = reviewerId;
    }

    @Override
    @Generated
    public String toString() {
        return "RealizationEntity(id=" + this.getId() + ", earnerId=" + this.getEarnerId() + ", earnerType=" + String.valueOf((Object)this.getEarnerType()) + ", globalScore=" + this.getGlobalScore() + ", actionTitle=" + this.getActionTitle() + ", domain=" + this.getDomain() + ", context=" + this.getContext() + ", actionScore=" + this.getActionScore() + ", receiver=" + this.getReceiver() + ", objectId=" + this.getObjectId() + ", objectType=" + this.getObjectType() + ", domainEntity=" + String.valueOf(this.getDomainEntity()) + ", ruleEntity=" + String.valueOf(this.getRuleEntity()) + ", activityId=" + this.getActivityId() + ", comment=" + this.getComment() + ", creator=" + this.getCreator() + ", status=" + String.valueOf((Object)this.getStatus()) + ", type=" + String.valueOf((Object)this.getType()) + ", sendingDate=" + String.valueOf(this.getSendingDate()) + ", reviewerId=" + this.getReviewerId() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RealizationEntity)) {
            return false;
        }
        RealizationEntity other = (RealizationEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getGlobalScore() != other.getGlobalScore()) {
            return false;
        }
        if (this.getActionScore() != other.getActionScore()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$activityId = this.getActivityId();
        Long other$activityId = other.getActivityId();
        if (this$activityId == null ? other$activityId != null : !((Object)this$activityId).equals(other$activityId)) {
            return false;
        }
        Long this$creator = this.getCreator();
        Long other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !((Object)this$creator).equals(other$creator)) {
            return false;
        }
        Long this$reviewerId = this.getReviewerId();
        Long other$reviewerId = other.getReviewerId();
        if (this$reviewerId == null ? other$reviewerId != null : !((Object)this$reviewerId).equals(other$reviewerId)) {
            return false;
        }
        String this$earnerId = this.getEarnerId();
        String other$earnerId = other.getEarnerId();
        if (this$earnerId == null ? other$earnerId != null : !this$earnerId.equals(other$earnerId)) {
            return false;
        }
        IdentityType this$earnerType = this.getEarnerType();
        IdentityType other$earnerType = other.getEarnerType();
        if (this$earnerType == null ? other$earnerType != null : !((Object)((Object)this$earnerType)).equals((Object)other$earnerType)) {
            return false;
        }
        String this$actionTitle = this.getActionTitle();
        String other$actionTitle = other.getActionTitle();
        if (this$actionTitle == null ? other$actionTitle != null : !this$actionTitle.equals(other$actionTitle)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        String this$context = this.getContext();
        String other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        String this$receiver = this.getReceiver();
        String other$receiver = other.getReceiver();
        if (this$receiver == null ? other$receiver != null : !this$receiver.equals(other$receiver)) {
            return false;
        }
        String this$objectId = this.getObjectId();
        String other$objectId = other.getObjectId();
        if (this$objectId == null ? other$objectId != null : !this$objectId.equals(other$objectId)) {
            return false;
        }
        String this$objectType = this.getObjectType();
        String other$objectType = other.getObjectType();
        if (this$objectType == null ? other$objectType != null : !this$objectType.equals(other$objectType)) {
            return false;
        }
        ProgramEntity this$domainEntity = this.getDomainEntity();
        ProgramEntity other$domainEntity = other.getDomainEntity();
        if (this$domainEntity == null ? other$domainEntity != null : !((Object)this$domainEntity).equals(other$domainEntity)) {
            return false;
        }
        RuleEntity this$ruleEntity = this.getRuleEntity();
        RuleEntity other$ruleEntity = other.getRuleEntity();
        if (this$ruleEntity == null ? other$ruleEntity != null : !((Object)this$ruleEntity).equals(other$ruleEntity)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        RealizationStatus this$status = this.getStatus();
        RealizationStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        EntityType this$type = this.getType();
        EntityType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Date this$sendingDate = this.getSendingDate();
        Date other$sendingDate = other.getSendingDate();
        return !(this$sendingDate == null ? other$sendingDate != null : !((Object)this$sendingDate).equals(other$sendingDate));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RealizationEntity;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $globalScore = this.getGlobalScore();
        result = result * 59 + (int)($globalScore >>> 32 ^ $globalScore);
        long $actionScore = this.getActionScore();
        result = result * 59 + (int)($actionScore >>> 32 ^ $actionScore);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $activityId = this.getActivityId();
        result = result * 59 + ($activityId == null ? 43 : ((Object)$activityId).hashCode());
        Long $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : ((Object)$creator).hashCode());
        Long $reviewerId = this.getReviewerId();
        result = result * 59 + ($reviewerId == null ? 43 : ((Object)$reviewerId).hashCode());
        String $earnerId = this.getEarnerId();
        result = result * 59 + ($earnerId == null ? 43 : $earnerId.hashCode());
        IdentityType $earnerType = this.getEarnerType();
        result = result * 59 + ($earnerType == null ? 43 : ((Object)((Object)$earnerType)).hashCode());
        String $actionTitle = this.getActionTitle();
        result = result * 59 + ($actionTitle == null ? 43 : $actionTitle.hashCode());
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        String $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        String $receiver = this.getReceiver();
        result = result * 59 + ($receiver == null ? 43 : $receiver.hashCode());
        String $objectId = this.getObjectId();
        result = result * 59 + ($objectId == null ? 43 : $objectId.hashCode());
        String $objectType = this.getObjectType();
        result = result * 59 + ($objectType == null ? 43 : $objectType.hashCode());
        ProgramEntity $domainEntity = this.getDomainEntity();
        result = result * 59 + ($domainEntity == null ? 43 : ((Object)$domainEntity).hashCode());
        RuleEntity $ruleEntity = this.getRuleEntity();
        result = result * 59 + ($ruleEntity == null ? 43 : ((Object)$ruleEntity).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        RealizationStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        EntityType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Date $sendingDate = this.getSendingDate();
        result = result * 59 + ($sendingDate == null ? 43 : ((Object)$sendingDate).hashCode());
        return result;
    }
}

