/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.rest;

import io.meeds.gamification.constant.DateFilterType;
import io.meeds.gamification.constant.EntityFilterType;
import io.meeds.gamification.constant.EntityStatusType;
import io.meeds.gamification.constant.PeriodType;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.RulePublication;
import io.meeds.gamification.model.filter.ProgramFilter;
import io.meeds.gamification.model.filter.RuleFilter;
import io.meeds.gamification.rest.builder.RuleBuilder;
import io.meeds.gamification.rest.model.ProgramWithRulesRestEntity;
import io.meeds.gamification.rest.model.RuleList;
import io.meeds.gamification.rest.model.RuleRestEntity;
import io.meeds.gamification.service.ProgramService;
import io.meeds.gamification.service.RealizationService;
import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.utils.Utils;
import io.meeds.portal.security.service.SecuritySettingService;
import io.meeds.social.translation.service.TranslationService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.rest.http.PATCH;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.common.xmlprocessor.XMLProcessor;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.metadata.favorite.FavoriteService;

@Path(value="/gamification/rules")
@Tag(name="/gamification/rules", description="Manages rules")
public class RuleRest
implements ResourceContainer {
    private final CacheControl cacheControl = new CacheControl();
    protected ProgramService programService;
    protected RuleService ruleService;
    protected RealizationService realizationService;
    protected TranslationService translationService;
    protected FavoriteService favoriteService;
    protected IdentityManager identityManager;
    protected SecuritySettingService securitySettingService;
    protected ActivityManager activityManager;
    protected XMLProcessor xmlProcessor;
    protected UserACL userAcl;

    public RuleRest(ProgramService programService, RuleService ruleService, RealizationService realizationService, TranslationService translationService, FavoriteService favoriteService, IdentityManager identityManager, SecuritySettingService securitySettingService, ActivityManager activityManager, XMLProcessor xmlProcessor, UserACL userAcl) {
        this.cacheControl.setNoCache(true);
        this.cacheControl.setNoStore(true);
        this.programService = programService;
        this.ruleService = ruleService;
        this.realizationService = realizationService;
        this.translationService = translationService;
        this.favoriteService = favoriteService;
        this.identityManager = identityManager;
        this.securitySettingService = securitySettingService;
        this.activityManager = activityManager;
        this.userAcl = userAcl;
        this.xmlProcessor = xmlProcessor;
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Retrieves the list of available rules", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getRules(@Context HttpServletRequest request, @Parameter(description="Offset of results to retrieve") @QueryParam(value="offset") @DefaultValue(value="0") int offset, @Parameter(description="Limit of results to retrieve") @QueryParam(value="limit") @DefaultValue(value="20") int limit, @Parameter(description="Used to filter rules by program") @QueryParam(value="programId") long programId, @Parameter(description="Used to filter rules by space audience") @QueryParam(value="spaceId") List<Long> spaceIds, @Parameter(description="Used to filter rules by event name") @QueryParam(value="eventName") String eventName, @Parameter(description="Rules type filtering, possible values: AUTOMATIC, MANUAL and ALL. Default value = ALL.") @QueryParam(value="type") @DefaultValue(value="ALL") EntityFilterType ruleType, @Parameter(description="Programs status filtering, possible values: ENABLED, DISABLED and ALL. Default value = ENABLED.") @QueryParam(value="programStatus") @DefaultValue(value="ALL") EntityStatusType programStatus, @Parameter(description="Rules status filtering, possible values: ENABLED, DISABLED and ALL. Default value = ALL.") @QueryParam(value="status") @DefaultValue(value="ALL") EntityStatusType ruleStatus, @Parameter(description="Rule period filtering. Possible values: STARTED, NOT_STARTED, ENDED, ALL") @Schema(defaultValue="ALL") @DefaultValue(value="ALL") @QueryParam(value="dateFilter") DateFilterType dateFilter, @Parameter(description="term to search rules with") @QueryParam(value="term") String term, @Parameter(description="Whether to search in favorites only or not") @DefaultValue(value="false") @QueryParam(value="favorites") boolean favorites, @Parameter(description="Whether to search in favorites only or not") @QueryParam(value="tags") List<String> tagNames, @Parameter(description="Sort field. Possible values: createdDate, startDate, endDate or score.") @QueryParam(value="sortBy") @DefaultValue(value="score") String sortField, @Parameter(description="Whether to retrieve results sorted descending or not") @QueryParam(value="sortDescending") @DefaultValue(value="true") boolean sortDescending, @Parameter(description="If true, this will return the filtered rules including deleted ones. Possible values = true or false. Default value = false.") @QueryParam(value="includeDeleted") @DefaultValue(value="false") boolean includeDeleted, @Parameter(description="Accepted users realizations count") @Schema(defaultValue="0") @QueryParam(value="realizationsLimit") int realizationsLimit, @Parameter(description="Group rules by program") @Schema(defaultValue="false") @QueryParam(value="groupByProgram") boolean groupByProgram, @Parameter(description="Whether Sort by popular rules or not") @DefaultValue(value="false") @QueryParam(value="orderByRealizations") boolean orderByRealizations, @Parameter(description="Excluded rule Ids") @QueryParam(value="excludedRuleIds") List<Long> excludedRuleIds, @Parameter(description="Rule period filtering. Possible values: WEEK, MONTH, YEAR, ALL") @Schema(defaultValue="ALL") @DefaultValue(value="ALL") @QueryParam(value="period") PeriodType periodType, @Parameter(description="If true, this will return the total count of filtered programs. Possible values = true or false. Default value = false.") @QueryParam(value="returnSize") @DefaultValue(value="false") boolean returnSize, @Parameter(description="Used to retrieve the title and description in requested language") @QueryParam(value="lang") String lang, @Parameter(description="Asking for a full representation of a specific subresource, ex: userRealizations") @QueryParam(value="expand") String expand) {
        if (offset < 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Offset must be 0 or positive").build();
        }
        if (limit < 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Limit must be positive").build();
        }
        if (!Utils.canAccessAnonymousResources(this.securitySettingService)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Locale locale = this.getLocale(lang);
        String currentUser = Utils.getCurrentUser();
        RuleFilter ruleFilter = new RuleFilter();
        ruleFilter.setTerm(term);
        ruleFilter.setFavorites(favorites);
        ruleFilter.setTagNames(tagNames);
        ruleFilter.setLocale(locale);
        ruleFilter.setDateFilterType(dateFilter == null ? DateFilterType.ALL : dateFilter);
        ruleFilter.setType(ruleType == null ? EntityFilterType.ALL : ruleType);
        ruleFilter.setStatus(ruleStatus == null ? EntityStatusType.ALL : ruleStatus);
        ruleFilter.setProgramStatus(programStatus == null ? EntityStatusType.ALL : programStatus);
        ruleFilter.setOrderByRealizations(orderByRealizations);
        ruleFilter.setExcludedRuleIds(excludedRuleIds);
        ruleFilter.setProgramId(programId);
        ruleFilter.setSpaceIds(spaceIds);
        ruleFilter.setEventName(eventName);
        ruleFilter.setIdentityId(Utils.getCurrentUserIdentityId());
        ruleFilter.setExcludeNoSpace(CollectionUtils.isNotEmpty(spaceIds));
        ruleFilter.setSortBy(sortField);
        ruleFilter.setSortDescending(sortDescending);
        ruleFilter.setIncludeDeleted(includeDeleted);
        List<String> expandFields = Utils.getExpandOptions(expand);
        try {
            Response.ResponseBuilder responseBuilder = Response.status((int)200);
            if (!groupByProgram || programId > 0L) {
                RuleList ruleList = new RuleList();
                List<RuleRestEntity> ruleEntities = this.getRules(responseBuilder, ruleFilter, periodType, locale, expandFields, currentUser, offset, limit, realizationsLimit, programId > 0L);
                ruleList.setRules(ruleEntities);
                ruleList.setOffset(offset);
                ruleList.setLimit(limit);
                if (returnSize) {
                    ruleList.setSize(this.ruleService.countRules(ruleFilter, currentUser));
                }
                return responseBuilder.entity((Object)ruleList).build();
            }
            ProgramFilter programFilter = new ProgramFilter();
            programFilter.setStatus(programStatus);
            List<ProgramDTO> programs = this.programService.getPrograms(programFilter, currentUser, 0, -1);
            ArrayList<ProgramWithRulesRestEntity> programsWithRules = new ArrayList<ProgramWithRulesRestEntity>();
            for (ProgramDTO program : programs) {
                ProgramWithRulesRestEntity programWithRule = new ProgramWithRulesRestEntity(program);
                ruleFilter.setProgramId(program.getId());
                List<RuleRestEntity> ruleEntities = this.getRules(responseBuilder, ruleFilter, periodType, locale, expandFields, currentUser, offset, limit, realizationsLimit, true);
                programWithRule.setRules(ruleEntities);
                programWithRule.setOffset(offset);
                programWithRule.setLimit(limit);
                if (returnSize) {
                    programWithRule.setSize(this.ruleService.countRules(ruleFilter, currentUser));
                }
                programsWithRules.add(programWithRule);
            }
            return responseBuilder.entity(programsWithRules).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @Operation(summary="Retrieves the list of available rules", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Object not found"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getRule(@Context HttpServletRequest request, @Parameter(description="Rule technical identifier") @PathParam(value="id") long id, @Parameter(description="Accepted users realizations count") @Schema(defaultValue="0") @QueryParam(value="realizationsLimit") int realizationsLimit, @Parameter(description="Used to retrieve the title and description in requested language") @QueryParam(value="lang") String lang, @Parameter(description="Asking for a full representation of a specific subresource, ex: countRealizations") @QueryParam(value="expand") String expand) {
        if (!Utils.canAccessAnonymousResources(this.securitySettingService)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        String currentUser = Utils.getCurrentUser();
        try {
            RuleDTO rule = this.ruleService.findRuleById(id, currentUser);
            List<String> expandFields = Utils.getExpandOptions(expand);
            RuleRestEntity ruleEntity = RuleBuilder.toRestEntity(this.programService, this.ruleService, this.realizationService, this.translationService, this.favoriteService, this.identityManager, this.activityManager, this.xmlProcessor, this.userAcl, rule, this.getLocale(lang), expandFields, realizationsLimit, false, Utils.isAnonymous(), PeriodType.ALL);
            return Response.ok((Object)ruleEntity).build();
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Creates a rule", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createRule(@Context HttpServletRequest request, @RequestBody(description="rule object to save", required=true) RulePublication rule) {
        if (rule == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Rule object is mandatory").build();
        }
        String username = Utils.getCurrentUser();
        try {
            RuleDTO createdRule = this.ruleService.createRule(rule, username);
            return Response.ok().cacheControl(this.cacheControl).entity((Object)this.toRestEntity(createdRule, this.getLocale(request))).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Updates a rule", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Object not found"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateRule(@Context HttpServletRequest request, @RequestBody(description="rule object to update", required=true) RulePublication rule) {
        String username = Utils.getCurrentUser();
        if (rule == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Rule object is mandatory").build();
        }
        try {
            RuleDTO updatedRule = this.ruleService.updateRule(rule, username);
            return Response.ok().cacheControl(this.cacheControl).entity((Object)this.toRestEntity(updatedRule, this.getLocale(request))).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @Path(value="{ruleId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Deletes a rule", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Object not found"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteRule(@Context HttpServletRequest request, @Parameter(description="Rule technical identifier", required=true) @PathParam(value="ruleId") long ruleId) {
        if (ruleId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Rule technical identifier must be positive").build();
        }
        String username = Utils.getCurrentUser();
        try {
            RuleDTO rule = this.ruleService.deleteRuleById(ruleId, username);
            return Response.ok().cacheControl(this.cacheControl).entity((Object)this.toRestEntity(rule, this.getLocale(request))).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
    }

    @PATCH
    @Path(value="{ruleId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Change enablement status of rule", description="Change enablement status rule", method="PATCH")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled")})
    public Response updateRuleStatus(@Context HttpServletRequest request, @Parameter(description="Rule Id", required=true) @PathParam(value="ruleId") long ruleId) {
        if (ruleId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Rule technical identifier must be positive").build();
        }
        try {
            this.ruleService.updateRuleStatus(ruleId, request.getRemoteUser());
            return Response.noContent().build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
    }

    private Locale getLocale(String lang) {
        return StringUtils.isBlank((CharSequence)lang) ? null : Locale.forLanguageTag(lang);
    }

    private Locale getLocale(HttpServletRequest request) {
        return request == null ? null : request.getLocale();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RuleRestEntity> getRules(Response.ResponseBuilder responseBuilder, RuleFilter filter, PeriodType periodType, Locale locale, List<String> expandFields, String username, int offset, int limit, int realizationsLimit, boolean noProgram) {
        ArrayList<CallSite> times = new ArrayList<CallSite>();
        long startTime = System.currentTimeMillis();
        List<RuleDTO> rules = this.ruleService.getRules(filter, username, offset, limit);
        times.add((CallSite)((Object)("list;dur=" + (System.currentTimeMillis() - startTime))));
        startTime = System.currentTimeMillis();
        try {
            List<RuleRestEntity> list = rules.stream().map(rule -> {
                long mapStartTime = System.currentTimeMillis();
                try {
                    RuleRestEntity ruleRestEntity = RuleBuilder.toRestEntity(this.programService, this.ruleService, this.realizationService, this.translationService, this.favoriteService, this.identityManager, this.activityManager, this.xmlProcessor, this.userAcl, rule, locale, expandFields, realizationsLimit, noProgram, Utils.isAnonymous(), periodType);
                    return ruleRestEntity;
                }
                finally {
                    times.add((CallSite)((Object)("rule-mapping-" + rule.getId() + ";dur=" + (System.currentTimeMillis() - mapStartTime))));
                }
            }).toList();
            return list;
        }
        finally {
            times.add((CallSite)((Object)("all-rules-mappings;dur=" + (System.currentTimeMillis() - startTime))));
            responseBuilder.header("Server-Timing", (Object)StringUtils.join(times, (String)","));
        }
    }

    private RuleRestEntity toRestEntity(RuleDTO rule, Locale locale) {
        return RuleBuilder.toRestEntity(this.programService, this.ruleService, this.realizationService, this.translationService, this.favoriteService, this.identityManager, this.activityManager, this.xmlProcessor, this.userAcl, rule, locale, null, 0, false, Utils.isAnonymous(), PeriodType.ALL);
    }
}

