/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.test;

import io.meeds.gamification.service.AnnouncementService;
import io.meeds.gamification.service.ProgramService;
import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.test.AbstractServiceTest;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.api.notification.service.setting.PluginContainer;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.settings.ExoFeatureService;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.social.notification.mock.MockNotificationService;

public abstract class AbstractPluginTest
extends AbstractServiceTest {
    public static final String ADMIN_USER = "root1";
    public static final String SIMPLE_USER = "root5";
    protected Locale initialDefaultLocale;
    protected UserSettingService userSettingService;
    protected PluginContainer pluginService;
    protected MockNotificationService notificationService;
    protected PluginSettingService pluginSettingService;
    protected ExoFeatureService exoFeatureService;

    public abstract BaseNotificationPlugin getPlugin();

    @Override
    public void setUp() throws Exception {
        User user;
        super.setUp();
        this.userSettingService = (UserSettingService)this.getContainer().getComponentInstanceOfType(UserSettingService.class);
        this.pluginService = (PluginContainer)this.getContainer().getComponentInstanceOfType(PluginContainer.class);
        this.notificationService = (MockNotificationService)this.getContainer().getComponentInstanceOfType(MockNotificationService.class);
        this.pluginSettingService = (PluginSettingService)this.getContainer().getComponentInstanceOfType(PluginSettingService.class);
        this.exoFeatureService = (ExoFeatureService)this.getContainer().getComponentInstanceOfType(ExoFeatureService.class);
        this.programService = (ProgramService)this.getContainer().getComponentInstanceOfType(ProgramService.class);
        this.ruleService = (RuleService)this.getContainer().getComponentInstanceOfType(RuleService.class);
        this.announcementService = (AnnouncementService)this.getContainer().getComponentInstanceOfType(AnnouncementService.class);
        this.initialDefaultLocale = Locale.getDefault();
        Locale.setDefault(new Locale("en", "US"));
        this.turnON(this.getPlugin());
        this.notificationService.clearAll();
        CacheService cacheService = (CacheService)ExoContainerContext.getService(CacheService.class);
        cacheService.getCacheInstance("commons.UserSettingService").clearCache();
        OrganizationService organizationService = (OrganizationService)ExoContainerContext.getService(OrganizationService.class);
        UserHandler userHandler = organizationService.getUserHandler();
        if (userHandler.findUserByName(ADMIN_USER) == null) {
            user = userHandler.createUserInstance(ADMIN_USER);
            user.setFirstName(ADMIN_USER);
            user.setLastName(ADMIN_USER);
            user.setEmail("root1@meeds.io");
            userHandler.createUser(user, false);
        }
        if (userHandler.findUserByName(SIMPLE_USER) == null) {
            user = userHandler.createUserInstance(SIMPLE_USER);
            user.setFirstName(SIMPLE_USER);
            user.setLastName(SIMPLE_USER);
            user.setEmail("root5@meeds.io");
            userHandler.createUser(user, false);
        }
    }

    @Override
    public void tearDown() {
        this.turnOFF(this.getPlugin());
        if (this.initialDefaultLocale != null) {
            Locale.setDefault(this.initialDefaultLocale);
        }
        super.tearDown();
    }

    protected NotificationInfo getNotificationInfo(String username) {
        List list = this.notificationService.storeDigest(username);
        AbstractPluginTest.assertFalse((boolean)list.isEmpty());
        return (NotificationInfo)list.get(0);
    }

    protected List<NotificationInfo> getNotificationInfos(String username) {
        return this.notificationService.storeDigest(username);
    }

    protected void assertSubject(MessageInfo message, String validatedString) {
        AbstractPluginTest.assertEquals((String)TemplateUtils.getExcerptSubject((String)validatedString), (String)message.getSubject());
    }

    protected void assertBody(MessageInfo message, String includedString) {
        AbstractPluginTest.assertTrue((String)("body = '" + message.getBody() + "' \r\n doesn't contain\r\n " + includedString), (message.getBody().indexOf(includedString) > 0 ? 1 : 0) != 0);
    }

    protected void assertDigest(Writer writer, String includedString) {
        AbstractPluginTest.assertEquals((String)includedString, (String)writer.toString().replaceAll("\\<.*?>", ""));
    }

    protected void assertMadeMailDigestNotifications(int number) {
        UserSetting setting = this.userSettingService.get(this.rootIdentity.getRemoteId());
        if (setting.isInDaily(this.getPlugin().getKey().getId())) {
            AbstractPluginTest.assertEquals((int)number, (int)this.notificationService.sizeOfStoredDigest());
        }
    }

    protected List<NotificationInfo> assertMadeMailDigestNotifications(String username, int number) {
        UserSetting setting = this.userSettingService.get(username);
        List got = this.notificationService.storeDigest(username);
        if (setting.isActive("MAIL_CHANNEL", this.getPlugin().getKey().getId())) {
            got = this.notificationService.storeInstantly(username);
            AbstractPluginTest.assertEquals((int)number, (int)got.size());
        }
        return got;
    }

    protected void assertMadeWebNotifications(int number) {
        UserSetting setting = this.userSettingService.get(this.rootIdentity.getRemoteId());
        if (setting.isActive("WEB_CHANNEL", this.getPlugin().getKey().getId())) {
            AbstractPluginTest.assertEquals((int)number, (int)this.notificationService.sizeOfWebNotifs());
        }
    }

    protected List<NotificationInfo> assertMadeWebNotifications(String username, int number) {
        UserSetting setting = this.userSettingService.get(username);
        AbstractPluginTest.assertTrue((boolean)setting.isActive("WEB_CHANNEL", this.getPlugin().getKey().getId()));
        List got = this.notificationService.storeWebNotifs(username);
        AbstractPluginTest.assertEquals((int)number, (int)got.size());
        return got;
    }

    protected void turnON(BaseNotificationPlugin plugin) {
        this.pluginSettingService.saveActivePlugin("MAIL_CHANNEL", plugin.getId(), true);
    }

    protected void turnOFF(BaseNotificationPlugin plugin) {
        this.pluginSettingService.saveActivePlugin("MAIL_CHANNEL", plugin.getId(), false);
    }

    protected void turnFeatureOn() {
        this.exoFeatureService.saveActiveFeature("notification", true);
    }

    protected void turnFeatureOff() {
        this.exoFeatureService.saveActiveFeature("notification", false);
    }

    protected void setInstantlySettings(String userId, List<String> settings) {
        UserSetting userSetting = this.userSettingService.get(userId);
        if (userSetting == null) {
            userSetting = UserSetting.getInstance();
            userSetting.setUserId(userId);
        }
        userSetting.setChannelActive("MAIL_CHANNEL");
        userSetting.setChannelPlugins("MAIL_CHANNEL", settings);
        this.userSettingService.save(userSetting);
    }

    protected void setDailySetting(String userId, List<String> settings) {
        UserSetting userSetting = this.userSettingService.get(userId);
        if (userSetting == null) {
            userSetting = UserSetting.getInstance();
            userSetting.setUserId(userId);
        }
        userSetting.setChannelActive("MAIL_CHANNEL");
        userSetting.setDailyPlugins(settings);
        this.userSettingService.save(userSetting);
    }

    protected void setWeeklySetting(String userId, List<String> settings) {
        UserSetting userSetting = this.userSettingService.get(userId);
        if (userSetting == null) {
            userSetting = UserSetting.getInstance();
            userSetting.setUserId(userId);
        }
        userSetting.setChannelActive("MAIL_CHANNEL");
        userSetting.setWeeklyPlugins(settings);
        this.userSettingService.save(userSetting);
    }

    protected AbstractTemplateBuilder getTemplateBuilder(NotificationContext ctx) {
        AbstractChannel channel = ctx.getChannelManager().getChannel(ChannelKey.key((String)"MAIL_CHANNEL"));
        AbstractPluginTest.assertNotNull((Object)channel);
        return channel.getTemplateBuilder(ctx.getNotificationInfo().getKey());
    }

    protected MessageInfo buildMessageInfo(NotificationContext ctx) {
        AbstractTemplateBuilder templateBuilder = this.getTemplateBuilder();
        if (templateBuilder == null) {
            templateBuilder = this.getTemplateBuilder(ctx);
        }
        MessageInfo massage = templateBuilder.buildMessage(ctx);
        AbstractPluginTest.assertNotNull((Object)massage);
        return massage;
    }

    protected void buildDigest(NotificationContext ctx, Writer writer) {
        AbstractTemplateBuilder templateBuilder = this.getTemplateBuilder();
        if (templateBuilder == null) {
            templateBuilder = this.getTemplateBuilder(ctx);
        }
        templateBuilder.buildDigest(ctx, writer);
    }

    public abstract AbstractTemplateBuilder getTemplateBuilder();
}

