/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.storage;

import io.meeds.gamification.constant.EntityFilterType;
import io.meeds.gamification.constant.EntityStatusType;
import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.filter.ProgramFilter;
import io.meeds.gamification.test.AbstractServiceTest;
import io.meeds.gamification.utils.Utils;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class ProgramStorageTest
extends AbstractServiceTest {
    @Test
    public void testSaveDomain() {
        ProgramStorageTest.assertEquals((int)0, (int)this.programDAO.findAll().size());
        ProgramDTO domain = new ProgramDTO();
        domain.setTitle("TeamWork");
        domain.setDescription("Description");
        domain.setCreatedBy("1");
        domain.setLastModifiedBy("1");
        domain.setDeleted(false);
        domain.setEnabled(true);
        domain.setLastModifiedDate(Utils.toRFC3339Date((Date)new Date()));
        domain.setType(EntityType.AUTOMATIC.name());
        domain.setCreatedDate(Utils.toRFC3339Date((Date)new Date()));
        domain.setBudget(20L);
        domain.setOwnerIds(Collections.singleton(1L));
        domain.setCoverFileId(1L);
        ProgramDTO savedDomain = this.domainStorage.saveProgram(domain);
        ProgramStorageTest.assertNotNull((Object)savedDomain);
        Assert.assertNotEquals((long)0L, (long)savedDomain.getId());
        domain.setCoverUploadId("1");
        Assert.assertThrows(IllegalStateException.class, () -> this.domainStorage.saveProgram(domain));
    }

    @Test
    public void testGetAllDomains() {
        ProgramFilter filter = new ProgramFilter();
        filter.setType(EntityFilterType.ALL);
        filter.setStatus(EntityStatusType.ENABLED);
        filter.setAllSpaces(true);
        ProgramStorageTest.assertEquals((int)0, (int)this.domainStorage.getProgramIdsByFilter(filter, 0, 10).size());
        this.newDomain(EntityType.MANUAL, "domain1", true, new HashSet<Long>());
        this.newDomain(EntityType.MANUAL, "domain2", true, new HashSet<Long>());
        this.newDomain(EntityType.AUTOMATIC, "domain3", true, new HashSet<Long>());
        this.newDomain(EntityType.AUTOMATIC, "domain4", true, new HashSet<Long>());
        ProgramStorageTest.assertEquals((int)4, (int)this.domainStorage.getProgramIdsByFilter(filter, 0, 10).size());
        filter.setType(EntityFilterType.AUTOMATIC);
        ProgramStorageTest.assertEquals((int)2, (int)this.domainStorage.getProgramIdsByFilter(filter, 0, 10).size());
        this.newDomain(EntityType.AUTOMATIC, "domain5", false, new HashSet<Long>());
        ProgramStorageTest.assertEquals((int)2, (int)this.domainStorage.getProgramIdsByFilter(filter, 0, 10).size());
        filter.setType(EntityFilterType.MANUAL);
        ProgramStorageTest.assertEquals((int)2, (int)this.domainStorage.getProgramIdsByFilter(filter, 0, 10).size());
        this.newDomain(EntityType.MANUAL, "domain6", false, new HashSet<Long>());
        ProgramStorageTest.assertEquals((int)2, (int)this.domainStorage.getProgramIdsByFilter(filter, 0, 10).size());
        filter.setStatus(EntityStatusType.ALL);
        filter.setType(EntityFilterType.ALL);
        ProgramStorageTest.assertEquals((int)6, (int)this.domainStorage.getProgramIdsByFilter(filter, 0, 10).size());
        filter.setStatus(EntityStatusType.DISABLED);
        ProgramStorageTest.assertEquals((int)2, (int)this.domainStorage.getProgramIdsByFilter(filter, 0, 10).size());
        filter.setType(EntityFilterType.AUTOMATIC);
        ProgramStorageTest.assertEquals((int)1, (int)this.domainStorage.getProgramIdsByFilter(filter, 0, 10).size());
        filter.setType(EntityFilterType.MANUAL);
        ProgramStorageTest.assertEquals((int)1, (int)this.domainStorage.getProgramIdsByFilter(filter, 0, 10).size());
    }

    @Test
    public void testCountDomains() {
        ProgramFilter filter = new ProgramFilter();
        filter.setType(EntityFilterType.ALL);
        filter.setStatus(EntityStatusType.ENABLED);
        filter.setAllSpaces(true);
        ProgramStorageTest.assertEquals((int)0, (int)this.domainStorage.countPrograms(filter));
        this.newDomain(EntityType.MANUAL, "domain1", true, new HashSet<Long>());
        this.newDomain(EntityType.MANUAL, "domain2", true, new HashSet<Long>());
        this.newDomain(EntityType.AUTOMATIC, "domain3", true, new HashSet<Long>());
        this.newDomain(EntityType.AUTOMATIC, "domain4", true, new HashSet<Long>());
        ProgramStorageTest.assertEquals((int)4, (int)this.domainStorage.countPrograms(filter));
        filter.setType(EntityFilterType.AUTOMATIC);
        ProgramStorageTest.assertEquals((int)2, (int)this.domainStorage.countPrograms(filter));
        this.newDomain(EntityType.AUTOMATIC, "domain5", false, new HashSet<Long>());
        ProgramStorageTest.assertEquals((int)2, (int)this.domainStorage.countPrograms(filter));
        filter.setType(EntityFilterType.MANUAL);
        ProgramStorageTest.assertEquals((int)2, (int)this.domainStorage.countPrograms(filter));
        this.newDomain(EntityType.MANUAL, "domain6", false, new HashSet<Long>());
        ProgramStorageTest.assertEquals((int)2, (int)this.programDAO.countPrograms(filter));
        filter.setStatus(EntityStatusType.ALL);
        filter.setType(EntityFilterType.ALL);
        ProgramStorageTest.assertEquals((int)6, (int)this.domainStorage.countPrograms(filter));
        filter.setStatus(EntityStatusType.DISABLED);
        ProgramStorageTest.assertEquals((int)2, (int)this.domainStorage.countPrograms(filter));
        filter.setType(EntityFilterType.AUTOMATIC);
        ProgramStorageTest.assertEquals((int)1, (int)this.domainStorage.countPrograms(filter));
        filter.setType(EntityFilterType.MANUAL);
        ProgramStorageTest.assertEquals((int)1, (int)this.domainStorage.countPrograms(filter));
    }
}

