/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service;

import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.constant.IdentityType;
import io.meeds.gamification.constant.Period;
import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.constant.RecurrenceType;
import io.meeds.gamification.entity.ProgramEntity;
import io.meeds.gamification.entity.RealizationEntity;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.StandardLeaderboard;
import io.meeds.gamification.model.filter.LeaderboardFilter;
import io.meeds.gamification.model.filter.RealizationFilter;
import io.meeds.gamification.plugin.EventPlugin;
import io.meeds.gamification.test.AbstractServiceTest;
import io.meeds.gamification.utils.Utils;
import java.io.InputStream;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.junit.Assert;

public class RealizationServiceTest
extends AbstractServiceTest {
    private static final String INTERNAL_USER = "root50";
    private static final String SPACE_HOST_USER = "root5";
    private static final String SPACE_MEMBER_USER = "root10";
    private static final String ADMIN_USER = "root1";
    private Identity adminAclIdentity;
    private String adminIdentityId;
    private Identity spaceMemberAclIdentity;
    private String spaceMemberIdentityId;
    private Identity spaceHostAclIdentity;
    private String spaceHostIdentityId;
    private Identity internalUserAclIdentity;
    private String internalUserIdentityId;
    private static final List<RealizationStatus> REJECTED_STATUS = Collections.singletonList(RealizationStatus.REJECTED);
    private static final List<RealizationStatus> ACCEPTED_STATUS = Collections.singletonList(RealizationStatus.ACCEPTED);
    private static final List<RealizationStatus> CANCELED_STATUS = Collections.singletonList(RealizationStatus.CANCELED);

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.adminAclIdentity = this.registerAdministratorUser(ADMIN_USER);
        this.adminIdentityId = this.identityManager.getOrCreateUserIdentity(ADMIN_USER).getId();
        this.spaceHostAclIdentity = this.registerInternalUser(SPACE_HOST_USER);
        this.spaceHostIdentityId = this.identityManager.getOrCreateUserIdentity(SPACE_HOST_USER).getId();
        this.spaceMemberAclIdentity = this.registerInternalUser(SPACE_MEMBER_USER);
        this.spaceMemberIdentityId = this.identityManager.getOrCreateUserIdentity(SPACE_MEMBER_USER).getId();
        this.internalUserAclIdentity = this.registerInternalUser(INTERNAL_USER);
        this.internalUserIdentityId = this.identityManager.getOrCreateUserIdentity(INTERNAL_USER).getId();
    }

    public void testCreateRealizationsByAdmin() {
        List realizations = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)0);
        RuleDTO rule = this.newRuleDTO();
        RealizationDTO realization = (RealizationDTO)this.realizationService.createRealizations(rule.getEvent().getTitle(), null, this.adminIdentityId, this.adminIdentityId, "245590", "activity").getFirst();
        RealizationServiceTest.assertNotNull((Object)realization);
        RealizationServiceTest.assertTrue((realization.getId() > 0L ? 1 : 0) != 0);
        realizations = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)1);
        RealizationEntity realizationEntity = (RealizationEntity)realizations.getFirst();
        RealizationServiceTest.assertEquals((String)this.adminIdentityId, (String)String.valueOf(realizationEntity.getEarnerId()));
        RealizationServiceTest.assertEquals((String)this.adminIdentityId, (String)realizationEntity.getReceiver());
        RealizationServiceTest.assertEquals((String)"245590", (String)realizationEntity.getObjectId());
        RealizationServiceTest.assertEquals((Object)IdentityType.USER, (Object)realizationEntity.getEarnerType());
        realization = (RealizationDTO)this.realizationService.createRealizations(rule.getEvent().getTitle(), null, "150", this.adminIdentityId, "245590", "activity").getFirst();
        RealizationServiceTest.assertNotNull((Object)realization);
        RealizationServiceTest.assertTrue((realization.getId() > 0L ? 1 : 0) != 0);
        realizations = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)2);
        realizationEntity = (RealizationEntity)realizations.get(1);
        RealizationServiceTest.assertEquals((String)"150", (String)String.valueOf(realizationEntity.getEarnerId()));
        RealizationServiceTest.assertEquals((String)this.adminIdentityId, (String)realizationEntity.getReceiver());
        RealizationServiceTest.assertEquals((String)"245590", (String)realizationEntity.getObjectId());
        RealizationServiceTest.assertEquals((Object)IdentityType.SPACE, (Object)realizationEntity.getEarnerType());
    }

    public void testCreateRealizationsBySpaceHost() {
        List realizations = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)0);
        RuleDTO ruleDTO = this.newRuleDTO();
        RealizationDTO realization = (RealizationDTO)this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, this.spaceHostIdentityId, this.spaceMemberIdentityId, "245590", "activity").getFirst();
        RealizationServiceTest.assertNotNull((Object)realization);
        RealizationServiceTest.assertTrue((realization.getId() > 0L ? 1 : 0) != 0);
        realizations = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)1);
        RealizationEntity realizationEntity = (RealizationEntity)realizations.getFirst();
        RealizationServiceTest.assertEquals((String)this.spaceHostIdentityId, (String)String.valueOf(realizationEntity.getEarnerId()));
        RealizationServiceTest.assertEquals((String)this.spaceMemberIdentityId, (String)realizationEntity.getReceiver());
        RealizationServiceTest.assertEquals((String)"245590", (String)realizationEntity.getObjectId());
        RealizationServiceTest.assertEquals((Object)IdentityType.USER, (Object)realizationEntity.getEarnerType());
        realization = (RealizationDTO)this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "150", this.spaceHostIdentityId, "245590", "activity").getFirst();
        RealizationServiceTest.assertNotNull((Object)realization);
        RealizationServiceTest.assertTrue((realization.getId() > 0L ? 1 : 0) != 0);
        realizations = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)2);
        realizationEntity = (RealizationEntity)realizations.get(1);
        RealizationServiceTest.assertEquals((String)"150", (String)String.valueOf(realizationEntity.getEarnerId()));
        RealizationServiceTest.assertEquals((String)this.spaceHostIdentityId, (String)realizationEntity.getReceiver());
        RealizationServiceTest.assertEquals((String)"245590", (String)realizationEntity.getObjectId());
        RealizationServiceTest.assertEquals((Object)IdentityType.SPACE, (Object)realizationEntity.getEarnerType());
    }

    public void testCountParticipantsBetweenDates() {
        List realizations = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)0);
        RuleDTO ruleDTO = this.newRuleDTO();
        RealizationDTO realization = (RealizationDTO)this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, this.spaceHostIdentityId, this.spaceMemberIdentityId, "245590", "activity").getFirst();
        RealizationServiceTest.assertNotNull((Object)realization);
        RealizationServiceTest.assertTrue((realization.getId() > 0L ? 1 : 0) != 0);
        realizations = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)1);
        Date fromDate = Date.from(ZonedDateTime.now().minusMinutes(1L).toInstant());
        Date toDate = Date.from(ZonedDateTime.now().plusMinutes(1L).toInstant());
        RealizationServiceTest.assertEquals((long)1L, (long)this.realizationService.countParticipantsBetweenDates(fromDate, toDate));
        realization = (RealizationDTO)this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "150", this.spaceHostIdentityId, "245590", "activity").getFirst();
        RealizationServiceTest.assertNotNull((Object)realization);
        RealizationServiceTest.assertTrue((realization.getId() > 0L ? 1 : 0) != 0);
        realizations = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)2);
        RealizationServiceTest.assertEquals((long)1L, (long)this.realizationService.countParticipantsBetweenDates(fromDate, toDate));
    }

    public void testCreateRealizationsBySpaceMember() {
        List realizations = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)0);
        RuleDTO ruleDTO = this.newRuleDTO();
        RealizationDTO realization = (RealizationDTO)this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, this.spaceMemberIdentityId, this.spaceHostIdentityId, "245590", "activity").getFirst();
        RealizationServiceTest.assertNotNull((Object)realization);
        RealizationServiceTest.assertTrue((realization.getId() > 0L ? 1 : 0) != 0);
        realizations = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)1);
        RealizationEntity realizationEntity = (RealizationEntity)realizations.getFirst();
        RealizationServiceTest.assertEquals((String)this.spaceMemberIdentityId, (String)String.valueOf(realizationEntity.getEarnerId()));
        RealizationServiceTest.assertEquals((String)this.spaceHostIdentityId, (String)realizationEntity.getReceiver());
        RealizationServiceTest.assertEquals((String)"245590", (String)realizationEntity.getObjectId());
        RealizationServiceTest.assertEquals((Object)IdentityType.USER, (Object)realizationEntity.getEarnerType());
        realization = (RealizationDTO)this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "150", this.spaceMemberIdentityId, "245590", "activity").getFirst();
        RealizationServiceTest.assertNotNull((Object)realization);
        RealizationServiceTest.assertTrue((realization.getId() > 0L ? 1 : 0) != 0);
        realizations = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)2);
        realizationEntity = (RealizationEntity)realizations.get(1);
        RealizationServiceTest.assertEquals((String)"150", (String)String.valueOf(realizationEntity.getEarnerId()));
        RealizationServiceTest.assertEquals((String)this.spaceMemberIdentityId, (String)realizationEntity.getReceiver());
        RealizationServiceTest.assertEquals((String)"245590", (String)realizationEntity.getObjectId());
        RealizationServiceTest.assertEquals((Object)IdentityType.SPACE, (Object)realizationEntity.getEarnerType());
    }

    public void testGetRealizationBySpaceMember() throws IllegalAccessException, ObjectNotFoundException {
        List realizations = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)0);
        RuleDTO ruleDTO = this.newRuleDTO();
        RealizationDTO realization = (RealizationDTO)this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, this.spaceHostIdentityId, this.spaceMemberIdentityId, "245590", "activity").getFirst();
        RealizationServiceTest.assertNotNull((Object)realization);
        RealizationServiceTest.assertTrue((realization.getId() > 0L ? 1 : 0) != 0);
        realizations = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)1);
        RealizationEntity realizationEntity = (RealizationEntity)realizations.getFirst();
        RealizationServiceTest.assertEquals((String)this.spaceHostIdentityId, (String)String.valueOf(realizationEntity.getEarnerId()));
        RealizationServiceTest.assertEquals((String)this.spaceMemberIdentityId, (String)realizationEntity.getReceiver());
        RealizationServiceTest.assertEquals((String)"245590", (String)realizationEntity.getObjectId());
        RealizationServiceTest.assertEquals((Object)IdentityType.USER, (Object)realizationEntity.getEarnerType());
        realization = (RealizationDTO)this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "150", this.spaceHostIdentityId, "245590", "activity").getFirst();
        RealizationServiceTest.assertNotNull((Object)realization);
        RealizationServiceTest.assertTrue((realization.getId() > 0L ? 1 : 0) != 0);
        realizations = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)2);
        RealizationDTO spaceMemberAccessedRealization = this.realizationService.getRealizationById(realization.getId().longValue(), this.spaceMemberAclIdentity);
        RealizationServiceTest.assertNotNull((Object)spaceMemberAccessedRealization);
        RealizationServiceTest.assertEquals((Object)realization.getId(), (Object)spaceMemberAccessedRealization.getId());
    }

    public void testCreateRealizationsByInternalUserInSpaceRule() {
        RuleDTO ruleDTO = this.newRuleDTO();
        List realizations = this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, this.internalUserIdentityId, this.spaceHostIdentityId, "245590", "activity");
        RealizationServiceTest.assertTrue((boolean)realizations.isEmpty());
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationDAO.count().intValue());
        realizations = this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "150", this.internalUserIdentityId, "245590", "activity");
        RealizationServiceTest.assertNotNull((Object)realizations);
        RealizationServiceTest.assertEquals((int)1, (int)realizations.size());
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)this.realizationDAO.count().intValue());
        RealizationDTO realization = (RealizationDTO)realizations.getFirst();
        RealizationServiceTest.assertEquals((String)"150", (String)realization.getEarnerId());
        RealizationServiceTest.assertEquals((String)this.internalUserIdentityId, (String)realization.getReceiver());
        RealizationServiceTest.assertEquals((String)"245590", (String)realization.getObjectId());
        RealizationServiceTest.assertEquals((String)IdentityType.SPACE.name(), (String)realization.getEarnerType());
    }

    public void testCreateRealizationsByInternalUser() {
        List realizations = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)0);
        ProgramEntity openProgram = this.newOpenProgram("testProgram");
        RuleDTO ruleDTO = this.newRuleDTO("testRule", openProgram.getId());
        RealizationDTO realization = (RealizationDTO)this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, this.internalUserIdentityId, this.spaceHostIdentityId, "245590", "activity").getFirst();
        RealizationServiceTest.assertNotNull((Object)realization);
        RealizationServiceTest.assertTrue((realization.getId() > 0L ? 1 : 0) != 0);
        realizations = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)1);
        RealizationEntity realizationEntity = (RealizationEntity)realizations.getFirst();
        RealizationServiceTest.assertEquals((String)this.internalUserIdentityId, (String)String.valueOf(realizationEntity.getEarnerId()));
        RealizationServiceTest.assertEquals((String)this.spaceHostIdentityId, (String)realizationEntity.getReceiver());
        RealizationServiceTest.assertEquals((String)"245590", (String)realizationEntity.getObjectId());
        RealizationServiceTest.assertEquals((Object)IdentityType.USER, (Object)realizationEntity.getEarnerType());
        realization = (RealizationDTO)this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "150", this.internalUserIdentityId, "245590", "activity").getFirst();
        RealizationServiceTest.assertNotNull((Object)realization);
        RealizationServiceTest.assertTrue((realization.getId() > 0L ? 1 : 0) != 0);
        realizations = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)2);
        realizationEntity = (RealizationEntity)realizations.get(1);
        RealizationServiceTest.assertEquals((String)"150", (String)String.valueOf(realizationEntity.getEarnerId()));
        RealizationServiceTest.assertEquals((String)this.internalUserIdentityId, (String)realizationEntity.getReceiver());
        RealizationServiceTest.assertEquals((String)"245590", (String)realizationEntity.getObjectId());
        RealizationServiceTest.assertEquals((Object)IdentityType.SPACE, (Object)realizationEntity.getEarnerType());
    }

    public void testCancelRealizations() {
        List realizations = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)0);
        RuleDTO ruleDTO = this.newRuleDTO();
        List createdRealizations = this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, this.adminIdentityId, this.spaceMemberIdentityId, "245590", "activity");
        RealizationDTO realization = (RealizationDTO)createdRealizations.getFirst();
        RealizationServiceTest.assertNotNull((Object)realization);
        RealizationServiceTest.assertTrue((realization.getId() > 0L ? 1 : 0) != 0);
        realizations = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)1);
        List canceledRealizations = this.realizationService.cancelRealizations(ruleDTO.getEvent().getTitle(), this.adminIdentityId, this.spaceMemberIdentityId, "245590", "activity");
        RealizationServiceTest.assertNotNull((Object)canceledRealizations);
        RealizationServiceTest.assertEquals((int)createdRealizations.size(), (int)canceledRealizations.size());
        RealizationDTO canceledRealization = (RealizationDTO)canceledRealizations.getFirst();
        RealizationServiceTest.assertEquals((Object)canceledRealization.getId(), (Object)realization.getId());
        RealizationServiceTest.assertEquals((String)canceledRealization.getStatus(), (String)RealizationStatus.CANCELED.name());
    }

    public void testHadOwnedProgram() throws IllegalAccessException, ObjectNotFoundException {
        RealizationServiceTest.assertFalse((boolean)this.realizationService.isRealizationManager(this.spaceMemberAclIdentity.getUserId()));
        RealizationServiceTest.assertTrue((boolean)this.realizationService.isRealizationManager(this.adminAclIdentity.getUserId()));
        RealizationServiceTest.assertFalse((boolean)this.realizationService.isRealizationManager(this.spaceHostAclIdentity.getUserId()));
        ProgramDTO program = this.newProgram();
        RealizationServiceTest.assertTrue((boolean)this.realizationService.isRealizationManager(this.spaceHostAclIdentity.getUserId()));
        org.exoplatform.social.core.identity.model.Identity regularUserIdentity = this.identityManager.getOrCreateUserIdentity(this.spaceMemberAclIdentity.getUserId());
        program.setOwnerIds(Collections.singleton(Long.parseLong(regularUserIdentity.getId())));
        this.programService.updateProgram(program, this.adminAclIdentity);
        RealizationServiceTest.assertTrue((boolean)this.realizationService.isRealizationManager(this.spaceMemberAclIdentity.getUserId()));
        this.programService.deleteProgramById(program.getId(), this.adminAclIdentity);
        RealizationServiceTest.assertTrue((boolean)this.realizationService.isRealizationManager(this.spaceMemberAclIdentity.getUserId()));
    }

    public void testCreateRealizationsOnOutdatedRules() throws ObjectNotFoundException {
        RealizationServiceTest.assertEquals((long)0L, (long)this.realizationDAO.count());
        RuleDTO rule = this.newRuleDTO();
        rule.setEndDate(Utils.toSimpleDateFormat((Date)new Date(System.currentTimeMillis() - 86400000L)));
        this.ruleService.updateRule(rule);
        List realizations = this.realizationService.createRealizations(rule.getEvent().getTitle(), null, this.adminIdentityId, this.spaceMemberIdentityId, "245590", "activity");
        RealizationServiceTest.assertNotNull((Object)realizations);
        RealizationServiceTest.assertTrue((boolean)realizations.isEmpty());
        RealizationServiceTest.assertEquals((long)0L, (long)this.realizationDAO.count());
        rule.setEndDate(null);
        rule.setStartDate(Utils.toSimpleDateFormat((Date)new Date(System.currentTimeMillis() + 86400000L)));
        this.ruleService.updateRule(rule);
        realizations = this.realizationService.createRealizations(rule.getEvent().getTitle(), null, this.adminIdentityId, this.spaceMemberIdentityId, "245590", "activity");
        RealizationServiceTest.assertNotNull((Object)realizations);
        RealizationServiceTest.assertTrue((boolean)realizations.isEmpty());
        RealizationServiceTest.assertEquals((long)0L, (long)this.realizationDAO.count());
        rule.setStartDate(Utils.toSimpleDateFormat((Date)new Date(System.currentTimeMillis() - 172800000L)));
        rule.setEndDate(Utils.toSimpleDateFormat((Date)new Date(System.currentTimeMillis() - 86400000L)));
        this.ruleService.updateRule(rule);
        realizations = this.realizationService.createRealizations(rule.getEvent().getTitle(), null, this.adminIdentityId, this.spaceMemberIdentityId, "245590", "activity");
        RealizationServiceTest.assertNotNull((Object)realizations);
        RealizationServiceTest.assertTrue((boolean)realizations.isEmpty());
        RealizationServiceTest.assertEquals((long)0L, (long)this.realizationDAO.count());
        rule.setEndDate(Utils.toSimpleDateFormat((Date)new Date(System.currentTimeMillis() + 86400000L)));
        this.ruleService.updateRule(rule);
        ProgramDTO program = this.programService.getProgramById(rule.getProgramId());
        program.setEnabled(true);
        this.programService.updateProgram(program);
        realizations = this.realizationService.createRealizations(rule.getEvent().getTitle(), null, this.adminIdentityId, this.spaceMemberIdentityId, "245590", "activity");
        RealizationServiceTest.assertNotNull((Object)realizations);
        RealizationServiceTest.assertEquals((int)1, (int)realizations.size());
        RealizationServiceTest.assertEquals((long)1L, (long)this.realizationDAO.count());
        RealizationDTO realization = (RealizationDTO)realizations.getFirst();
        RealizationServiceTest.assertEquals((String)this.adminIdentityId, (String)realization.getEarnerId());
        RealizationServiceTest.assertEquals((String)this.spaceMemberIdentityId, (String)realization.getReceiver());
        RealizationServiceTest.assertEquals((String)"245590", (String)realization.getObjectId());
        RealizationServiceTest.assertEquals((String)"activity", (String)realization.getObjectType());
        RealizationServiceTest.assertEquals((long)rule.getScore(), (long)realization.getActionScore());
    }

    public void testCreateRealizationOnOnceRule() throws ObjectNotFoundException {
        this.makeRecurrenceTypeChecks(RecurrenceType.ONCE);
        RealizationServiceTest.assertEquals((int)2, (int)this.realizationDAO.count().intValue());
    }

    public void testCreateRealizationOnDailyRule() throws ObjectNotFoundException {
        this.makeRecurrenceTypeChecks(RecurrenceType.DAILY);
        RealizationServiceTest.assertEquals((int)2, (int)this.realizationDAO.count().intValue());
    }

    public void testCreateRealizationOnWeeklyRule() throws ObjectNotFoundException {
        this.makeRecurrenceTypeChecks(RecurrenceType.WEEKLY);
        RealizationServiceTest.assertEquals((int)2, (int)this.realizationDAO.count().intValue());
    }

    public void testCreateRealizationOnMonthlyRule() throws ObjectNotFoundException {
        this.makeRecurrenceTypeChecks(RecurrenceType.MONTHLY);
        RealizationServiceTest.assertEquals((int)2, (int)this.realizationDAO.count().intValue());
    }

    public void testCreateRealizationForBlacklistUser() {
        List realizationEntities = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)0, (int)realizationEntities.size());
        RuleDTO ruleDTO = this.newRuleDTO();
        List realizations = this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, this.spaceMemberIdentityId, this.adminIdentityId, "245590", "activity");
        RealizationServiceTest.assertEquals((int)1, (int)realizations.size());
        this.spaceMemberAclIdentity.setMemberships(Arrays.asList(new MembershipEntry("/platform/externals"), new MembershipEntry("/leaderboard-blacklist-users")));
        this.identityRegistry.register(this.spaceMemberAclIdentity);
        realizations = this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, this.spaceMemberIdentityId, this.adminIdentityId, "245590", "activity");
        RealizationServiceTest.assertEquals((int)0, (int)realizations.size());
    }

    public void testCreateRealizationWithPrerequisiteRule() throws ObjectNotFoundException, IllegalAccessException {
        List realizationEntities = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)0, (int)realizationEntities.size());
        RuleDTO rule = this.newRuleDTO();
        RuleDTO prerequisiteRule1 = this.newRuleDTO();
        prerequisiteRule1.setEvent(this.newEventDTO("prerequisiteEvent1"));
        prerequisiteRule1 = this.ruleService.updateRule(prerequisiteRule1);
        RuleDTO prerequisiteRule2 = this.newRuleDTO();
        prerequisiteRule2.setEvent(this.newEventDTO("prerequisiteEvent2"));
        prerequisiteRule2 = this.ruleService.updateRule(prerequisiteRule2);
        rule.setPrerequisiteRuleIds(new HashSet<Long>(Arrays.asList(prerequisiteRule1.getId(), prerequisiteRule2.getId())));
        rule = this.ruleService.updateRule(rule);
        this.realizationService.createRealizations(rule.getEvent().getTitle(), null, this.adminIdentityId, this.spaceMemberIdentityId, "245590", "activity");
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationDAO.count().intValue());
        this.realizationService.createRealizations(prerequisiteRule1.getEvent().getTitle(), null, this.adminIdentityId, this.spaceMemberIdentityId, "245590", "activity");
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationDAO.count().intValue());
        this.realizationService.createRealizations(rule.getEvent().getTitle(), null, this.adminIdentityId, this.spaceMemberIdentityId, "245590", "activity");
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationDAO.count().intValue());
        this.realizationService.createRealizations(prerequisiteRule2.getEvent().getTitle(), null, this.adminIdentityId, this.spaceMemberIdentityId, "245590", "activity");
        RealizationServiceTest.assertEquals((int)2, (int)this.realizationDAO.count().intValue());
        this.realizationService.createRealizations(rule.getEvent().getTitle(), null, this.adminIdentityId, this.spaceMemberIdentityId, "245590", "activity");
        RealizationServiceTest.assertEquals((int)3, (int)this.realizationDAO.count().intValue());
        this.ruleService.deleteRuleById(prerequisiteRule2.getId().longValue(), ADMIN_USER);
        this.realizationService.createRealizations(rule.getEvent().getTitle(), null, this.adminIdentityId, this.spaceMemberIdentityId, "245590", "activity");
        RealizationServiceTest.assertEquals((int)4, (int)this.realizationDAO.count().intValue());
        this.ruleService.deleteRuleById(prerequisiteRule1.getId().longValue(), ADMIN_USER);
        this.realizationService.createRealizations(rule.getEvent().getTitle(), null, this.adminIdentityId, this.spaceMemberIdentityId, "245590", "activity");
        RealizationServiceTest.assertEquals((int)5, (int)this.realizationDAO.count().intValue());
    }

    public void testGetRealizations() throws IllegalAccessException, ObjectNotFoundException {
        List realizations = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)0);
        RuleDTO rule = this.newRuleDTO();
        List realizationDTOList = this.realizationService.createRealizations(rule.getEvent().getTitle(), null, "test", "test", "245590", "activity");
        RealizationServiceTest.assertTrue((boolean)realizationDTOList.isEmpty());
        this.setEventPlugin();
        RealizationDTO realization = (RealizationDTO)this.realizationService.createRealizations(rule.getEvent().getTitle(), null, this.adminIdentityId, this.adminIdentityId, "245590", "activity").getFirst();
        RealizationServiceTest.assertNotNull((Object)realization);
        RealizationServiceTest.assertTrue((realization.getId() > 0L ? 1 : 0) != 0);
        realizations = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)1);
        RealizationEntity realizationEntity = (RealizationEntity)realizations.getFirst();
        RealizationServiceTest.assertEquals((String)this.adminIdentityId, (String)String.valueOf(realizationEntity.getEarnerId()));
        RealizationServiceTest.assertEquals((String)this.adminIdentityId, (String)realizationEntity.getReceiver());
        RealizationServiceTest.assertEquals((String)"245590", (String)realizationEntity.getObjectId());
        RealizationServiceTest.assertEquals((Object)IdentityType.USER, (Object)realizationEntity.getEarnerType());
        realization = (RealizationDTO)this.realizationService.createRealizations(rule.getEvent().getTitle(), null, "150", this.adminIdentityId, "245590", "activity").getFirst();
        RealizationServiceTest.assertNotNull((Object)realization);
        RealizationServiceTest.assertTrue((realization.getId() > 0L ? 1 : 0) != 0);
        realizations = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)2);
        realizationEntity = (RealizationEntity)realizations.get(1);
        RealizationServiceTest.assertEquals((String)"150", (String)String.valueOf(realizationEntity.getEarnerId()));
        RealizationServiceTest.assertEquals((String)this.adminIdentityId, (String)realizationEntity.getReceiver());
        RealizationServiceTest.assertEquals((String)"245590", (String)realizationEntity.getObjectId());
        RealizationServiceTest.assertEquals((Object)IdentityType.SPACE, (Object)realizationEntity.getEarnerType());
        RealizationFilter filter = new RealizationFilter();
        filter.setOwned(true);
        RealizationServiceTest.assertEquals((int)2, (int)this.realizationService.countRealizationsByFilter(filter, this.adminAclIdentity));
        RealizationServiceTest.assertEquals((int)2, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceHostAclIdentity));
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceMemberAclIdentity));
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, this.internalUserAclIdentity));
        filter.setOwned(false);
        RealizationServiceTest.assertEquals((int)2, (int)this.realizationService.countRealizationsByFilter(filter, this.adminAclIdentity));
        RealizationServiceTest.assertEquals((int)2, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceHostAclIdentity));
        RealizationServiceTest.assertEquals((int)2, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceMemberAclIdentity));
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, this.internalUserAclIdentity));
        filter.setEarnerIds(Collections.singletonList(this.adminIdentityId));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.adminAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceHostAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceMemberAclIdentity));
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, this.internalUserAclIdentity));
        filter.setEarnerType(IdentityType.USER);
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.adminAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceHostAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceMemberAclIdentity));
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, this.internalUserAclIdentity));
        filter.setEarnerIds(null);
        filter.setEarnerType(IdentityType.SPACE);
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.adminAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceHostAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceMemberAclIdentity));
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, this.internalUserAclIdentity));
        filter.setEarnerType(IdentityType.USER);
        filter.setProgramIds(Collections.singletonList(rule.getProgramId()));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.adminAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceHostAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceMemberAclIdentity));
        Assert.assertThrows(IllegalAccessException.class, () -> this.realizationService.countRealizationsByFilter(filter, this.internalUserAclIdentity));
        filter.setProgramIds(Collections.singletonList(5555L));
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, this.adminAclIdentity));
        Assert.assertThrows(IllegalAccessException.class, () -> this.realizationService.countRealizationsByFilter(filter, this.spaceHostAclIdentity));
        Assert.assertThrows(IllegalAccessException.class, () -> this.realizationService.countRealizationsByFilter(filter, this.spaceMemberAclIdentity));
        Assert.assertThrows(IllegalAccessException.class, () -> this.realizationService.countRealizationsByFilter(filter, this.internalUserAclIdentity));
        filter.setProgramIds(null);
        filter.setRuleIds(Collections.singletonList(rule.getId()));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.adminAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceHostAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceMemberAclIdentity));
        Assert.assertThrows(IllegalAccessException.class, () -> this.realizationService.countRealizationsByFilter(filter, this.internalUserAclIdentity));
        filter.setEarnerType(null);
        filter.setEarnerIds(null);
        filter.setRuleIds(null);
        filter.setStatuses(ACCEPTED_STATUS);
        RealizationServiceTest.assertEquals((int)2, (int)this.realizationService.countRealizationsByFilter(filter, this.adminAclIdentity));
        RealizationServiceTest.assertEquals((int)2, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceHostAclIdentity));
        RealizationServiceTest.assertEquals((int)2, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceMemberAclIdentity));
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, this.internalUserAclIdentity));
        List allRealizations = this.realizationService.getRealizationsByFilter(filter, this.spaceMemberAclIdentity, 0, 0);
        RealizationServiceTest.assertEquals((int)2, (int)allRealizations.size());
        allRealizations = this.realizationService.getRealizationsByFilter(filter, this.spaceMemberAclIdentity, 0, 1);
        RealizationServiceTest.assertEquals((int)1, (int)allRealizations.size());
        RealizationDTO lastRealization = (RealizationDTO)allRealizations.getFirst();
        RealizationServiceTest.assertNotNull((Object)lastRealization);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.realizationService.updateRealizationStatus(lastRealization.getId().longValue(), RealizationStatus.CANCELED, ADMIN_USER));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.realizationService.updateRealizationStatus(lastRealization.getId().longValue(), RealizationStatus.DELETED, ADMIN_USER));
        this.realizationService.updateRealizationStatus(lastRealization.getId().longValue(), RealizationStatus.REJECTED, SPACE_HOST_USER);
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.adminAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceHostAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceMemberAclIdentity));
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, this.internalUserAclIdentity));
        filter.setStatuses(REJECTED_STATUS);
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.adminAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceHostAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceMemberAclIdentity));
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, this.internalUserAclIdentity));
        filter.setStatuses(CANCELED_STATUS);
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, this.adminAclIdentity));
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceHostAclIdentity));
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceMemberAclIdentity));
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, this.internalUserAclIdentity));
        RealizationDTO deleted = (RealizationDTO)this.realizationService.deleteRealizations("245590", "activity").getFirst();
        Assert.assertThrows(IllegalArgumentException.class, () -> this.realizationService.updateRealizationStatus(deleted.getId().longValue(), RealizationStatus.ACCEPTED, ADMIN_USER));
    }

    public void testExportRealizations() throws Exception {
        List realizations = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)0);
        RuleDTO rule = this.newRuleDTO();
        rule.setTitle("Rule Title, with comma");
        this.ruleService.updateRule(rule);
        RealizationDTO realization1 = (RealizationDTO)this.realizationService.createRealizations(rule.getEvent().getTitle(), null, this.adminIdentityId, this.adminIdentityId, "245590", "activity").getFirst();
        realization1 = this.realizationService.getRealizationById(realization1.getId().longValue(), this.adminAclIdentity);
        RealizationDTO realization2 = (RealizationDTO)this.realizationService.createRealizations(rule.getEvent().getTitle(), null, "150", this.adminIdentityId, "245590", "activity").getFirst();
        realization2 = this.realizationService.getRealizationById(realization2.getId().longValue(), this.adminAclIdentity);
        RealizationDTO realization3 = this.realizationService.getRealizationById(this.newRealizationEntity("Test Manual", rule.getProgramId(), true).getId().longValue(), this.adminAclIdentity);
        RealizationServiceTest.assertNotNull((Object)realization3);
        realizations = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)3);
        RealizationFilter filter = new RealizationFilter();
        filter.setOwned(true);
        InputStream exportInputStream = this.realizationService.exportXlsx(filter, this.adminAclIdentity, "fileName", Locale.ENGLISH);
        RealizationServiceTest.assertNotNull((Object)exportInputStream);
        Workbook workbook = WorkbookFactory.create((InputStream)exportInputStream);
        RealizationServiceTest.assertNotNull((Object)workbook);
        Sheet sheet = workbook.getSheetAt(0);
        RealizationServiceTest.assertNotNull((Object)sheet);
        RealizationServiceTest.assertEquals((int)3, (int)sheet.getLastRowNum());
        Row header = sheet.getRow(0);
        RealizationServiceTest.assertNotNull((Object)header);
        RealizationServiceTest.assertEquals((int)7, (int)header.getLastCellNum());
        RealizationServiceTest.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)header.getCell((int)header.getFirstCellNum()).getStringCellValue()));
        RealizationServiceTest.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)header.getCell(header.getLastCellNum() - 1).getStringCellValue()));
        Row row1 = sheet.getRow(1);
        RealizationServiceTest.assertNotNull((Object)row1);
        RealizationServiceTest.assertEquals((int)7, (int)row1.getLastCellNum());
        int cellIndex = 0;
        RealizationServiceTest.assertEquals((String)realization1.getCreatedDate(), (String)row1.getCell(cellIndex++).getStringCellValue());
        RealizationServiceTest.assertEquals((String)Utils.getUserFullName((String)realization1.getEarnerId()), (String)row1.getCell(cellIndex++).getStringCellValue());
        RealizationServiceTest.assertEquals((String)rule.getType().name(), (String)row1.getCell(cellIndex++).getStringCellValue());
        RealizationServiceTest.assertEquals((String)realization1.getProgramLabel(), (String)row1.getCell(cellIndex++).getStringCellValue());
        RealizationServiceTest.assertEquals((String)realization1.getActionTitle(), (String)row1.getCell(cellIndex++).getStringCellValue());
        RealizationServiceTest.assertEquals((double)realization1.getActionScore(), (double)row1.getCell(cellIndex++).getNumericCellValue(), (double)0.0);
        RealizationServiceTest.assertEquals((String)realization1.getStatus(), (String)row1.getCell(cellIndex).getStringCellValue());
        Row row2 = sheet.getRow(2);
        RealizationServiceTest.assertNotNull((Object)row2);
        RealizationServiceTest.assertEquals((int)7, (int)row2.getLastCellNum());
        cellIndex = 0;
        RealizationServiceTest.assertEquals((String)realization2.getCreatedDate(), (String)row2.getCell(cellIndex++).getStringCellValue());
        RealizationServiceTest.assertEquals((String)Utils.getUserFullName((String)realization2.getEarnerId()), (String)row2.getCell(cellIndex++).getStringCellValue());
        RealizationServiceTest.assertEquals((String)rule.getType().name(), (String)row2.getCell(cellIndex++).getStringCellValue());
        RealizationServiceTest.assertEquals((String)realization2.getProgramLabel(), (String)row2.getCell(cellIndex++).getStringCellValue());
        RealizationServiceTest.assertEquals((String)realization2.getActionTitle(), (String)row2.getCell(cellIndex++).getStringCellValue());
        RealizationServiceTest.assertEquals((double)realization2.getActionScore(), (double)row2.getCell(cellIndex++).getNumericCellValue(), (double)0.0);
        RealizationServiceTest.assertEquals((String)realization2.getStatus(), (String)row2.getCell(cellIndex).getStringCellValue());
        Row row3 = sheet.getRow(3);
        RealizationServiceTest.assertNotNull((Object)row3);
        RealizationServiceTest.assertEquals((int)7, (int)row3.getLastCellNum());
        cellIndex = 0;
        RealizationServiceTest.assertEquals((String)realization3.getCreatedDate(), (String)row3.getCell(cellIndex++).getStringCellValue());
        RealizationServiceTest.assertEquals((String)Utils.getUserFullName((String)realization3.getEarnerId()), (String)row3.getCell(cellIndex++).getStringCellValue());
        RealizationServiceTest.assertEquals((String)EntityType.MANUAL.name(), (String)row3.getCell(cellIndex++).getStringCellValue());
        RealizationServiceTest.assertEquals((String)realization3.getProgramLabel(), (String)row3.getCell(cellIndex++).getStringCellValue());
        RealizationServiceTest.assertEquals((String)realization3.getActionTitle(), (String)row3.getCell(cellIndex++).getStringCellValue());
        RealizationServiceTest.assertEquals((double)realization3.getActionScore(), (double)row3.getCell(cellIndex++).getNumericCellValue(), (double)0.0);
        RealizationServiceTest.assertEquals((String)realization3.getStatus(), (String)row3.getCell(cellIndex).getStringCellValue());
    }

    public void testGetRealizationsOnOpenProgram() throws IllegalAccessException, ObjectNotFoundException {
        List realizations = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)0);
        ProgramEntity openProgramEntity = this.newOpenProgram("testProgram");
        ProgramDTO openProgram = this.programService.getProgramById(openProgramEntity.getId().longValue());
        openProgram.setOwnerIds(Collections.singleton(Long.parseLong(this.spaceHostIdentityId)));
        Assert.assertThrows(IllegalAccessException.class, () -> this.programService.updateProgram(openProgram, this.spaceHostAclIdentity));
        this.programService.updateProgram(openProgram, this.adminAclIdentity);
        this.programService.updateProgram(openProgram, this.spaceHostAclIdentity);
        RuleDTO rule = this.newRuleDTO("testRule", openProgram.getId());
        RealizationDTO realization = (RealizationDTO)this.realizationService.createRealizations(rule.getEvent().getTitle(), null, this.internalUserIdentityId, this.spaceMemberIdentityId, "245590", "activity").getFirst();
        RealizationServiceTest.assertNotNull((Object)realization);
        RealizationServiceTest.assertTrue((realization.getId() > 0L ? 1 : 0) != 0);
        realizations = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)1);
        RealizationEntity realizationEntity = (RealizationEntity)realizations.getFirst();
        RealizationServiceTest.assertEquals((String)this.internalUserIdentityId, (String)String.valueOf(realizationEntity.getEarnerId()));
        RealizationServiceTest.assertEquals((String)this.spaceMemberIdentityId, (String)realizationEntity.getReceiver());
        RealizationServiceTest.assertEquals((String)"245590", (String)realizationEntity.getObjectId());
        RealizationServiceTest.assertEquals((Object)IdentityType.USER, (Object)realizationEntity.getEarnerType());
        realization = (RealizationDTO)this.realizationService.createRealizations(rule.getEvent().getTitle(), null, "150", this.spaceMemberIdentityId, "245590", "activity").getFirst();
        RealizationServiceTest.assertNotNull((Object)realization);
        RealizationServiceTest.assertTrue((realization.getId() > 0L ? 1 : 0) != 0);
        realizations = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)realizations.size(), (int)2);
        realizationEntity = (RealizationEntity)realizations.get(1);
        RealizationServiceTest.assertEquals((String)"150", (String)String.valueOf(realizationEntity.getEarnerId()));
        RealizationServiceTest.assertEquals((String)this.spaceMemberIdentityId, (String)realizationEntity.getReceiver());
        RealizationServiceTest.assertEquals((String)"245590", (String)realizationEntity.getObjectId());
        RealizationServiceTest.assertEquals((Object)IdentityType.SPACE, (Object)realizationEntity.getEarnerType());
        RealizationFilter filter = new RealizationFilter();
        filter.setOwned(true);
        RealizationServiceTest.assertEquals((int)2, (int)this.realizationService.countRealizationsByFilter(filter, this.adminAclIdentity));
        RealizationServiceTest.assertEquals((int)2, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceHostAclIdentity));
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceMemberAclIdentity));
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, this.internalUserAclIdentity));
        filter.setOwned(false);
        RealizationServiceTest.assertEquals((int)2, (int)this.realizationService.countRealizationsByFilter(filter, this.adminAclIdentity));
        RealizationServiceTest.assertEquals((int)2, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceHostAclIdentity));
        RealizationServiceTest.assertEquals((int)2, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceMemberAclIdentity));
        RealizationServiceTest.assertEquals((int)2, (int)this.realizationService.countRealizationsByFilter(filter, this.internalUserAclIdentity));
        filter.setEarnerIds(Collections.singletonList(this.adminIdentityId));
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, this.adminAclIdentity));
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceHostAclIdentity));
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceMemberAclIdentity));
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, this.internalUserAclIdentity));
        filter.setEarnerIds(Collections.singletonList(this.internalUserIdentityId));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.adminAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceHostAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceMemberAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.internalUserAclIdentity));
        filter.setEarnerType(IdentityType.USER);
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.adminAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceHostAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceMemberAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.internalUserAclIdentity));
        filter.setEarnerIds(null);
        filter.setEarnerType(IdentityType.SPACE);
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.adminAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceHostAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceMemberAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.internalUserAclIdentity));
        filter.setEarnerType(IdentityType.USER);
        filter.setProgramIds(Collections.singletonList(rule.getProgramId()));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.adminAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceHostAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceMemberAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.internalUserAclIdentity));
        filter.setProgramIds(Collections.singletonList(5555L));
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, this.adminAclIdentity));
        Assert.assertThrows(IllegalAccessException.class, () -> this.realizationService.countRealizationsByFilter(filter, this.spaceHostAclIdentity));
        Assert.assertThrows(IllegalAccessException.class, () -> this.realizationService.countRealizationsByFilter(filter, this.spaceMemberAclIdentity));
        Assert.assertThrows(IllegalAccessException.class, () -> this.realizationService.countRealizationsByFilter(filter, this.internalUserAclIdentity));
        filter.setProgramIds(null);
        filter.setRuleIds(Collections.singletonList(rule.getId()));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.adminAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceHostAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceMemberAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.internalUserAclIdentity));
        filter.setEarnerType(null);
        filter.setEarnerIds(null);
        filter.setRuleIds(null);
        filter.setStatuses(ACCEPTED_STATUS);
        RealizationServiceTest.assertEquals((int)2, (int)this.realizationService.countRealizationsByFilter(filter, this.adminAclIdentity));
        RealizationServiceTest.assertEquals((int)2, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceHostAclIdentity));
        RealizationServiceTest.assertEquals((int)2, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceMemberAclIdentity));
        RealizationServiceTest.assertEquals((int)2, (int)this.realizationService.countRealizationsByFilter(filter, this.internalUserAclIdentity));
        List allRealizations = this.realizationService.getRealizationsByFilter(filter, this.spaceMemberAclIdentity, 0, 0);
        RealizationServiceTest.assertEquals((int)2, (int)allRealizations.size());
        allRealizations = this.realizationService.getRealizationsByFilter(filter, this.spaceMemberAclIdentity, 0, 1);
        RealizationServiceTest.assertEquals((int)1, (int)allRealizations.size());
        RealizationDTO lastRealization = (RealizationDTO)allRealizations.getFirst();
        RealizationServiceTest.assertNotNull((Object)lastRealization);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.realizationService.updateRealizationStatus(lastRealization.getId().longValue(), RealizationStatus.CANCELED, ADMIN_USER));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.realizationService.updateRealizationStatus(lastRealization.getId().longValue(), RealizationStatus.DELETED, ADMIN_USER));
        Assert.assertThrows(IllegalAccessException.class, () -> this.realizationService.updateRealizationStatus(lastRealization.getId().longValue(), RealizationStatus.REJECTED, INTERNAL_USER));
        Assert.assertThrows(IllegalAccessException.class, () -> this.realizationService.updateRealizationStatus(lastRealization.getId().longValue(), RealizationStatus.REJECTED, SPACE_MEMBER_USER));
        this.realizationService.updateRealizationStatus(lastRealization.getId().longValue(), RealizationStatus.REJECTED, SPACE_HOST_USER);
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.adminAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceHostAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceMemberAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.internalUserAclIdentity));
        filter.setStatuses(REJECTED_STATUS);
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.adminAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceHostAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceMemberAclIdentity));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.countRealizationsByFilter(filter, this.internalUserAclIdentity));
        filter.setStatuses(CANCELED_STATUS);
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, this.adminAclIdentity));
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceHostAclIdentity));
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, this.spaceMemberAclIdentity));
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, this.internalUserAclIdentity));
    }

    public void testLeaderboardRank() throws IllegalAccessException {
        ProgramDTO program = this.newProgram();
        RuleDTO rule = this.newRuleDTO("createNewTask", program.getId());
        this.realizationService.createRealizations(rule.getEvent().getTitle(), null, this.adminIdentityId, this.spaceMemberIdentityId, "245590", "activity");
        this.realizationService.createRealizations(rule.getEvent().getTitle(), null, this.adminIdentityId, this.spaceMemberIdentityId, "245590", "activity");
        this.realizationService.createRealizations(rule.getEvent().getTitle(), null, this.spaceMemberIdentityId, this.spaceMemberIdentityId, "245590", "activity");
        this.realizationService.createRealizations(rule.getEvent().getTitle(), null, "150", this.spaceMemberIdentityId, "245590", "activity");
        this.realizationService.createRealizations(rule.getEvent().getTitle(), null, "150", this.spaceMemberIdentityId, "245590", "activity");
        this.realizationService.createRealizations(rule.getEvent().getTitle(), null, "150", this.spaceMemberIdentityId, "245590", "activity");
        this.realizationService.createRealizations(rule.getEvent().getTitle(), null, "152", this.spaceMemberIdentityId, "245590", "activity");
        this.realizationService.createRealizations(rule.getEvent().getTitle(), null, "152", this.spaceMemberIdentityId, "245590", "activity");
        this.realizationService.createRealizations(rule.getEvent().getTitle(), null, "152", this.spaceMemberIdentityId, "245590", "activity");
        this.realizationService.createRealizations(rule.getEvent().getTitle(), null, "152", this.spaceMemberIdentityId, "245590", "activity");
        Date date = Date.from(LocalDate.now().with(DayOfWeek.MONDAY).atStartOfDay(ZoneId.systemDefault()).toInstant());
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.getLeaderboardRank(this.adminIdentityId, date, null, null, Long.valueOf(program.getId())));
        LeaderboardFilter leaderboardFilter = new LeaderboardFilter();
        leaderboardFilter.setIdentityType(IdentityType.USER);
        leaderboardFilter.setProgramId(Long.valueOf(program.getId()));
        leaderboardFilter.setPeriod("WEEK");
        RealizationServiceTest.assertEquals((int)2, (int)this.realizationService.getLeaderboard(leaderboardFilter, null).size());
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.getLeaderboardRank(this.adminIdentityId, date, null, null, Long.valueOf(program.getId())));
        RealizationServiceTest.assertEquals((int)2, (int)this.realizationService.getLeaderboardRank(this.spaceMemberIdentityId, date, null, null, Long.valueOf(program.getId())));
        leaderboardFilter = new LeaderboardFilter();
        leaderboardFilter.setIdentityType(IdentityType.SPACE);
        leaderboardFilter.setProgramId(Long.valueOf(program.getId()));
        leaderboardFilter.setPeriod("WEEK");
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.getLeaderboard(leaderboardFilter, ADMIN_USER).size());
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationService.getLeaderboardRank("152", date, null, null, Long.valueOf(program.getId())));
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.getLeaderboardRank("150", date, null, null, Long.valueOf(program.getId())));
    }

    public void testFindUserReputationBySocialId() {
        RuleDTO ruleDTO = this.newRuleDTO();
        RealizationServiceTest.assertEquals((long)this.realizationService.getScoreByIdentityId(this.adminIdentityId), (long)0L);
        this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, this.adminIdentityId, this.adminIdentityId, "245590", "activity");
        this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "150", this.adminIdentityId, "245590", "activity");
        RealizationServiceTest.assertTrue((this.realizationService.getScoreByIdentityId(this.adminIdentityId) > 0L ? 1 : 0) != 0);
        RealizationServiceTest.assertTrue((this.realizationService.getScoreByIdentityId("150") > 0L ? 1 : 0) != 0);
    }

    public void testBuildDomainScoreByUserId() {
        RuleDTO ruleDTO = this.newRuleDTO();
        RealizationServiceTest.assertEquals((int)0, (int)this.realizationService.getScorePerProgramByIdentityId(this.adminIdentityId).size());
        this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, this.adminIdentityId, this.adminIdentityId, "245590", "activity");
        RealizationServiceTest.assertEquals((int)1, (int)this.realizationService.getScorePerProgramByIdentityId(this.adminIdentityId).size());
    }

    public void testFilterByDomainId() throws IllegalAccessException {
        RuleDTO ruleDTO = this.newRuleDTO();
        LeaderboardFilter filter = new LeaderboardFilter();
        filter.setPeriod(Period.ALL.name());
        filter.setIdentityType(IdentityType.USER);
        filter.setLimit(3);
        filter.setProgramId(Long.valueOf(ruleDTO.getProgram().getId()));
        List filteredLeaderboard = this.realizationService.getLeaderboard(filter, null);
        RealizationServiceTest.assertEquals((int)0, (int)filteredLeaderboard.size());
        this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, this.adminIdentityId, this.adminIdentityId, "245590", "activity");
        filteredLeaderboard = this.realizationService.getLeaderboard(filter, null);
        RealizationServiceTest.assertEquals((int)1, (int)filteredLeaderboard.size());
        StandardLeaderboard userLeaderboard = (StandardLeaderboard)filteredLeaderboard.getFirst();
        RealizationServiceTest.assertEquals((String)this.adminIdentityId, (String)userLeaderboard.getEarnerId());
        RealizationServiceTest.assertEquals((long)ruleDTO.getScore(), (long)userLeaderboard.getReputationScore());
        filter.setPeriod(Period.WEEK.name());
        filteredLeaderboard = this.realizationService.getLeaderboard(filter, null);
        RealizationServiceTest.assertEquals((int)1, (int)filteredLeaderboard.size());
        userLeaderboard = (StandardLeaderboard)filteredLeaderboard.getFirst();
        RealizationServiceTest.assertEquals((String)this.adminIdentityId, (String)userLeaderboard.getEarnerId());
        RealizationServiceTest.assertEquals((long)ruleDTO.getScore(), (long)userLeaderboard.getReputationScore());
        filter.setPeriod(Period.MONTH.name());
        filteredLeaderboard = this.realizationService.getLeaderboard(filter, null);
        RealizationServiceTest.assertEquals((int)1, (int)filteredLeaderboard.size());
        userLeaderboard = (StandardLeaderboard)filteredLeaderboard.getFirst();
        RealizationServiceTest.assertEquals((String)this.adminIdentityId, (String)userLeaderboard.getEarnerId());
        RealizationServiceTest.assertEquals((long)ruleDTO.getScore(), (long)userLeaderboard.getReputationScore());
        filter.setIdentityType(IdentityType.SPACE);
        Assert.assertThrows(IllegalAccessException.class, () -> this.realizationService.getLeaderboard(filter, null));
        filteredLeaderboard = this.realizationService.getLeaderboard(filter, "1");
        RealizationServiceTest.assertEquals((int)0, (int)filteredLeaderboard.size());
    }

    public void testDeleteHistory() {
        ProgramDTO program = this.newProgram();
        RuleDTO ruleDTO = this.newRuleDTO("createNewTask", program.getId());
        this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, this.adminIdentityId, this.adminIdentityId, "245590", "activity");
        this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, this.adminIdentityId, this.adminIdentityId, "245590", "activity");
        RealizationFilter identityFilter = new RealizationFilter();
        identityFilter.setEarnerIds(Collections.singletonList(this.adminIdentityId));
        List realizations = this.realizationService.getRealizationsByFilter(identityFilter, 0, 1);
        RealizationServiceTest.assertNotNull((Object)realizations);
        RealizationServiceTest.assertEquals((int)1, (int)realizations.size());
        RealizationDTO lastRealization = (RealizationDTO)realizations.getFirst();
        RealizationServiceTest.assertEquals((String)RealizationStatus.ACCEPTED.name(), (String)lastRealization.getStatus());
        realizations = this.realizationService.getRealizationsByFilter(identityFilter, 0, 1);
        RealizationServiceTest.assertNotNull((Object)realizations);
        RealizationServiceTest.assertEquals((int)1, (int)realizations.size());
        lastRealization = (RealizationDTO)realizations.getFirst();
        RealizationServiceTest.assertEquals((String)RealizationStatus.ACCEPTED.name(), (String)lastRealization.getStatus());
        this.realizationService.deleteRealizations("245590", "activity");
        realizations = this.realizationService.getRealizationsByFilter(identityFilter, 0, 1);
        RealizationServiceTest.assertNotNull((Object)realizations);
        RealizationServiceTest.assertEquals((int)1, (int)realizations.size());
        lastRealization = (RealizationDTO)realizations.getFirst();
        RealizationServiceTest.assertEquals((String)RealizationStatus.DELETED.name(), (String)lastRealization.getStatus());
        identityFilter.setStatuses(ACCEPTED_STATUS);
        realizations = this.realizationService.getRealizationsByFilter(identityFilter, 0, 1);
        RealizationServiceTest.assertNotNull((Object)realizations);
        RealizationServiceTest.assertEquals((int)0, (int)realizations.size());
    }

    private void makeRecurrenceTypeChecks(RecurrenceType recurrenceType) throws ObjectNotFoundException {
        List realizationEntities = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)0, (int)realizationEntities.size());
        RuleDTO ruleDTO = this.newRuleDTO();
        ruleDTO.setRecurrence(recurrenceType);
        ruleDTO = this.ruleService.updateRule(ruleDTO);
        RealizationDTO realization = (RealizationDTO)this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, this.adminIdentityId, this.adminIdentityId, "245590", "activity").getFirst();
        RealizationServiceTest.assertNotNull((Object)realization);
        RealizationServiceTest.assertTrue((realization.getId() > 0L ? 1 : 0) != 0);
        realizationEntities = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)1, (int)realizationEntities.size());
        List realizations = this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, this.adminIdentityId, this.adminIdentityId, "245590", "activity");
        RealizationServiceTest.assertNotNull((Object)realizations);
        RealizationServiceTest.assertTrue((boolean)realizations.isEmpty());
        realizationEntities = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)1, (int)realizationEntities.size());
        RealizationEntity realizationEntity = (RealizationEntity)realizationEntities.getFirst();
        realizationEntity.setCreatedDate(new Date(Objects.requireNonNull(recurrenceType.getPeriodStartDate()).getTime() - 1L));
        this.realizationDAO.update((Object)realizationEntity);
        realizations = this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "150", this.adminIdentityId, "245590", "activity");
        RealizationServiceTest.assertNotNull((Object)realizations);
        RealizationServiceTest.assertEquals((int)1, (int)realizations.size());
        realizationEntities = this.realizationDAO.findAll();
        RealizationServiceTest.assertEquals((int)2, (int)realizationEntities.size());
    }

    private void removeEventPlugin() {
        this.eventService.removePlugin("createNewTask");
    }

    private void setEventPlugin() {
        this.removeEventPlugin();
        EventPlugin eventPlugin = new EventPlugin(this){

            public String getEventType() {
                return "createNewTask";
            }

            public List<String> getTriggers() {
                return List.of("createNewTask");
            }

            public boolean isValidEvent(Map<String, String> eventProperties, String triggerDetails) {
                return true;
            }
        };
        eventPlugin.setName("createNewTask");
        this.eventService.addPlugin(eventPlugin);
    }
}

