/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.listener;

import io.meeds.gamification.listener.ProgramSpaceListener;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.filter.ProgramFilter;
import io.meeds.gamification.service.ProgramService;
import java.util.Collections;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ProgramSpaceListenerTest {
    private static final long SPACE_ID = 2L;
    private static final long PROGRAM_ID = 5L;
    @Mock
    ProgramService programService;
    @Mock
    Space space;
    @Mock
    ProgramDTO program;
    @Mock
    SpaceLifeCycleEvent event;

    @Test
    public void testSpaceRemoved() throws ObjectNotFoundException {
        ProgramSpaceListener programSpaceListener = new ProgramSpaceListener(this.programService);
        Mockito.when((Object)this.event.getSpace()).thenReturn((Object)this.space);
        Mockito.when((Object)this.space.getId()).thenReturn((Object)String.valueOf(2L));
        Mockito.when((Object)this.programService.getProgramIds((ProgramFilter)ArgumentMatchers.argThat(filter -> filter.getSpacesIds().equals(Collections.singletonList(2L)) && filter.isExcludeOpen()), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn(Collections.singletonList(5L));
        Mockito.when((Object)this.programService.getProgramById(5L)).thenReturn((Object)this.program);
        Mockito.when((Object)this.program.getSpaceId()).thenReturn((Object)2L);
        programSpaceListener.removePrograms(this.event);
        ((ProgramDTO)Mockito.verify((Object)this.program, (VerificationMode)Mockito.times((int)1))).setEnabled(false);
        ((ProgramService)Mockito.verify((Object)this.programService, (VerificationMode)Mockito.times((int)1))).updateProgram(this.program);
    }
}

