/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.search;

import io.meeds.gamification.model.filter.RuleFilter;
import io.meeds.gamification.utils.Utils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.es.ElasticSearchException;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class RuleSearchConnector {
    private static final Log LOG = ExoLogger.getLogger(RuleSearchConnector.class);
    private static final String SEARCH_QUERY_FILE_PATH_PARAM = "query.file.path";
    private static final String LANG = "@lang@";
    private static final String KEYWORD_FILTERING_QUERY = "      {\n        \"query_string\": {\n          \"query\": \"title:(*@term@*) OR title_@lang@:(*@term@*) OR description:(@term_query@) OR description_@lang@:(@term_query@)\",\n          \"default_operator\": \"AND\",\n          \"fuzziness\": 1,\n          \"phrase_slop\": 1\n        }\n      }\n";
    private static final String TERMS_FILTERING_QUERY = "      {\n        \"terms\": {\n          \"@field_name@\" : [\"@field_values@\"]\n        }\n      }\n";
    private static final String MATCH_FILTERING_QUERY = "      {\n         \"match\":{\n            \"@field_name@\": \"@field_value@\"\n         }\n      }\n";
    private static final String ILLEGAL_SEARCH_CHARACTERS = "\\!?^()+-=<>{}[]:\"*~&|#%@";
    private final ConfigurationManager configurationManager;
    private final ElasticSearchingClient client;
    private String index;
    private String searchQueryFilePath;
    private String searchQuery;

    public RuleSearchConnector(ConfigurationManager configurationManager, ElasticSearchingClient client, InitParams initParams) {
        this.configurationManager = configurationManager;
        this.client = client;
        PropertiesParam param = initParams.getPropertiesParam("constructor.params");
        this.index = param.getProperty("index");
        if (initParams.containsKey((Object)SEARCH_QUERY_FILE_PATH_PARAM)) {
            this.searchQueryFilePath = initParams.getValueParam(SEARCH_QUERY_FILE_PATH_PARAM).getValue();
            try {
                this.retrieveSearchQuery();
            }
            catch (Exception e) {
                LOG.error("Can't read elasticsearch search query from path {}", new Object[]{this.searchQueryFilePath, e});
            }
        }
    }

    public List<Long> search(RuleFilter filter, long offset, long limit) {
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset must be positive");
        }
        if (limit < 0L) {
            throw new IllegalArgumentException("Limit must be positive");
        }
        if (filter.getLocale() == null) {
            throw new IllegalArgumentException("Filter locale is mandatory");
        }
        String esQuery = this.buildQueryStatement(filter, offset, limit);
        if (StringUtils.isBlank((CharSequence)esQuery)) {
            return Collections.emptyList();
        }
        String jsonResponse = this.client.sendRequest(esQuery, this.index);
        return this.buildSearchResult(jsonResponse);
    }

    private String buildQueryStatement(RuleFilter filter, long offset, long limit) {
        String queryTemplate = this.retrieveSearchQuery();
        String filterQuery = this.computeFilterQuery(filter);
        return queryTemplate.replace(LANG, filter.getLocale().toLanguageTag()).replace("@search_filtering@", filterQuery).replace("@offset@", String.valueOf(offset)).replace("@limit@", String.valueOf(limit));
    }

    private String computeFilterQuery(RuleFilter filter) {
        StringBuilder searchFiltering = new StringBuilder();
        this.appendKeywordQuery(filter, searchFiltering);
        this.appendFavoriteQuery(filter, searchFiltering);
        this.appendTagsQuery(filter, searchFiltering);
        this.appendAudienceQuery(filter, searchFiltering);
        this.appendProgramQuery(filter, searchFiltering);
        return searchFiltering.toString();
    }

    private void appendKeywordQuery(RuleFilter filter, StringBuilder searchFiltering) {
        if (StringUtils.isBlank((CharSequence)filter.getTerm())) {
            return;
        }
        String term = StringUtils.lowerCase((String)Utils.removeSpecialCharacters(filter.getTerm()));
        term = RuleSearchConnector.escapeIllegalCharacterInQuery(term);
        String termQuery = "";
        if (StringUtils.isNotBlank((CharSequence)term)) {
            term = term.trim();
            List<String> termsQuery = Arrays.stream(term.split(" ")).filter(StringUtils::isNotBlank).map(word -> {
                if (((String)(word = ((String)word).trim())).length() > 4) {
                    word = (String)word + "~1";
                }
                return word;
            }).toList();
            termQuery = StringUtils.join(termsQuery, (String)" AND ");
            searchFiltering.append(KEYWORD_FILTERING_QUERY.replace("@term@", term).replace("@term_query@", termQuery).replace(LANG, filter.getLocale().toLanguageTag()));
        }
    }

    private void appendAudienceQuery(RuleFilter filter, StringBuilder query) {
        if (CollectionUtils.isEmpty(filter.getSpaceIds())) {
            return;
        }
        Set spaceList = Optional.ofNullable(filter.getSpaceIds()).map(HashSet::new).orElse(new HashSet());
        query.append(query.isEmpty() ? "" : ",").append(TERMS_FILTERING_QUERY.replace("@field_name@", "audience").replace("@field_values@", StringUtils.join((Iterable)spaceList, (String)"\",\"")));
    }

    private void appendTagsQuery(RuleFilter filter, StringBuilder query) {
        if (CollectionUtils.isEmpty(filter.getTagNames())) {
            return;
        }
        query.append(query.isEmpty() ? "" : ",").append(TERMS_FILTERING_QUERY.replace("@field_name@", "metadatas.tags.metadataName.keyword").replace("@field_values@", StringUtils.join(filter.getTagNames(), (String)"\",\"")));
    }

    private void appendFavoriteQuery(RuleFilter filter, StringBuilder query) {
        if (!this.isFavoriteQuery(filter)) {
            return;
        }
        query.append(query.isEmpty() ? "" : ",").append(TERMS_FILTERING_QUERY.replace("@field_name@", "metadatas.favorites.metadataName.keyword").replace("@field_values@", String.valueOf(filter.getIdentityId())));
    }

    private void appendProgramQuery(RuleFilter filter, StringBuilder query) {
        if (filter.getProgramId() <= 0L) {
            return;
        }
        query.append(query.isEmpty() ? "" : ",").append(MATCH_FILTERING_QUERY.replace("@field_name@", "domainId").replace("@field_value@", String.valueOf(filter.getProgramId())));
    }

    private List<Long> buildSearchResult(String jsonResponse) {
        ArrayList<Long> results = new ArrayList<Long>();
        JSONParser parser = new JSONParser();
        Map json = null;
        try {
            json = (Map)parser.parse(jsonResponse);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
        JSONObject jsonResult = (JSONObject)json.get("hits");
        if (jsonResult == null) {
            return results;
        }
        JSONArray jsonHits = (JSONArray)jsonResult.get((Object)"hits");
        for (Object jsonHit : jsonHits) {
            try {
                JSONObject jsonHitObject = (JSONObject)jsonHit;
                JSONObject hitSource = (JSONObject)jsonHitObject.get((Object)"_source");
                long id = this.parseLong(hitSource, "id");
                results.add(id);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error processing rules search result item, ignore it from results", (Throwable)e);
            }
        }
        return results;
    }

    private boolean isFavoriteQuery(RuleFilter filter) {
        return filter.isFavorites() && filter.getIdentityId() > 0L;
    }

    private long parseLong(JSONObject hitSource, String key) {
        String value = (String)hitSource.get((Object)key);
        return StringUtils.isBlank((CharSequence)value) ? 0L : Long.parseLong(value);
    }

    private static String escapeIllegalCharacterInQuery(String query) {
        if (StringUtils.isBlank((CharSequence)query)) {
            return null;
        }
        for (char c : ILLEGAL_SEARCH_CHARACTERS.toCharArray()) {
            query = query.replace("" + c, "");
        }
        return query;
    }

    private String retrieveSearchQuery() {
        if (StringUtils.isBlank((CharSequence)this.searchQuery) || PropertyManager.isDevelopping()) {
            try {
                InputStream queryFileIS = this.configurationManager.getInputStream(this.searchQueryFilePath);
                this.searchQuery = IOUtil.getStreamContentAsString((InputStream)queryFileIS);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error retrieving search query from file: " + this.searchQueryFilePath, e);
            }
        }
        return this.searchQuery;
    }
}

