/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.search;

import io.meeds.gamification.model.EventDTO;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.storage.RuleStorage;
import io.meeds.gamification.utils.Utils;
import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.service.TranslationService;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.search.DocumentWithMetadata;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataObject;

public class RuleIndexingServiceConnector
extends ElasticIndexingServiceConnector {
    public static final String RULE_OBJECT_TYPE = "rule";
    public static final String INDEX = "rules";
    private static final Log LOG = ExoLogger.getLogger(RuleIndexingServiceConnector.class);
    private TranslationService translationService;
    private RuleStorage ruleStorage;
    private MetadataService metadataService;
    private LocaleConfigService localeConfigService;
    private IdentityManager identityManager;

    public RuleIndexingServiceConnector(RuleStorage ruleStorage, TranslationService translationService, IdentityManager identityManager, LocaleConfigService localeConfigService, MetadataService metadataService, InitParams initParams) {
        super(initParams);
        this.ruleStorage = ruleStorage;
        this.translationService = translationService;
        this.identityManager = identityManager;
        this.localeConfigService = localeConfigService;
        this.metadataService = metadataService;
    }

    public String getConnectorName() {
        return INDEX;
    }

    public Document create(String id) {
        return this.getDocument(id);
    }

    public Document update(String id) {
        return this.getDocument(id);
    }

    public List<String> getAllIds(int offset, int limit) {
        throw new UnsupportedOperationException();
    }

    private Document getDocument(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("id is mandatory");
        }
        LOG.debug("Index document for rule with id={}", new Object[]{id});
        Long ruleId = Long.valueOf(id);
        RuleDTO rule = this.ruleStorage.findRuleById(Long.valueOf(id));
        if (rule == null) {
            throw new IllegalStateException("rule with id '" + id + "' not found");
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("id", Long.toString(ruleId));
        this.addTranslationLabels(ruleId, "title", fields, rule.getTitle());
        this.addTranslationLabels(ruleId, "description", fields, rule.getDescription());
        fields.put("score", String.valueOf(rule.getScore()));
        EventDTO event = rule.getEvent();
        if (event != null) {
            fields.put("event", event.getTitle());
        }
        fields.put("startDate", this.toMilliSecondsString(rule.getStartDate()));
        fields.put("endDate", this.toMilliSecondsString(rule.getEndDate()));
        fields.put("createdBy", this.getUserIdentityId(rule.getCreatedBy()));
        fields.put("createdDate", this.toMilliSecondsString(rule.getCreatedDate()));
        fields.put("lastModifiedBy", this.getUserIdentityId(rule.getLastModifiedBy()));
        fields.put("lastModifiedDate", this.toMilliSecondsString(rule.getLastModifiedDate()));
        fields.put("type", rule.getType().name());
        DocumentWithMetadata document = new DocumentWithMetadata();
        document.setId(id);
        document.setLastUpdatedDate(new Date());
        document.setFields(fields);
        document.setPermissions(Collections.emptySet());
        ProgramDTO program = rule.getProgram();
        if (program == null) {
            document.addField("domainId", "");
            document.addField("audience", "");
            document.addListField("managers", Collections.emptyList());
        } else {
            document.addField("domainId", String.valueOf(program.getId()));
            document.addField("audience", String.valueOf(program.getSpaceId()));
            if (CollectionUtils.isNotEmpty(program.getOwnerIds())) {
                document.addListField("managers", program.getOwnerIds().stream().map(String::valueOf).toList());
            } else {
                document.addListField("managers", Collections.emptyList());
            }
        }
        this.addDocumentMetadata(document, new MetadataObject(RULE_OBJECT_TYPE, id, null, rule.getSpaceId()));
        return document;
    }

    private void addDocumentMetadata(DocumentWithMetadata document, MetadataObject metadataObject) {
        List metadataItems = this.metadataService.getMetadataItemsByObject(metadataObject);
        document.setMetadataItems(metadataItems);
    }

    private void addTranslationLabels(Long ruleId, String fieldName, Map<String, String> fields, String defaultLabel) {
        try {
            TranslationField translationField = this.translationService.getTranslationField(RULE_OBJECT_TYPE, ruleId.longValue(), fieldName);
            translationField.getLabels().forEach((locale, label) -> this.addLocalizedLabel(fields, fieldName, (Locale)locale, (String)label));
            List<Locale> supportedLocales = this.localeConfigService.getLocalConfigs().stream().map(LocaleConfig::getLocale).toList();
            supportedLocales.stream().filter(locale -> !translationField.getLabels().containsKey(locale)).forEach(locale -> this.addLocalizedLabel(fields, fieldName, (Locale)locale, defaultLabel));
        }
        catch (ObjectNotFoundException e) {
            LOG.warn("Error retrieving Translation Labels of rule {}", new Object[]{ruleId, e});
        }
    }

    private String addLocalizedLabel(Map<String, String> fields, String fieldName, Locale locale, String label) {
        return fields.put(fieldName + "_" + locale.toLanguageTag(), StringUtils.lowerCase((String)Utils.removeSpecialCharacters(label)));
    }

    private String getUserIdentityId(String username) {
        Identity identity;
        String userIdentityId = "0";
        if (StringUtils.isNotBlank((CharSequence)username) && (identity = this.identityManager.getOrCreateUserIdentity(username)) != null) {
            userIdentityId = identity.getId();
        }
        return userIdentityId;
    }

    private String toMilliSecondsString(String date) {
        return date != null ? String.valueOf(Utils.parseSimpleDate(date).getTime()) : "0";
    }
}

