/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.meeds.gamification.model.TriggerProperties;
import io.meeds.gamification.service.TriggerService;
import io.meeds.gamification.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;

public class TriggerServiceImpl
implements TriggerService {
    private static final Context CONNECTOR_TRIGGER_CONTEXT = Context.GLOBAL.id("ConnectorTrigger");
    private static final Scope TRIGGER_SETTING_SCOPE = Scope.APPLICATION.id("TriggerSettings");
    private final SettingService settingService;

    public TriggerServiceImpl(SettingService settingService) {
        this.settingService = settingService;
    }

    @Override
    public TriggerProperties getTriggerProperties(String triggerName) {
        SettingValue settingValue = this.settingService.get(CONNECTOR_TRIGGER_CONTEXT, TRIGGER_SETTING_SCOPE, triggerName);
        if (settingValue == null || settingValue.getValue() == null || StringUtils.isBlank((CharSequence)settingValue.getValue().toString())) {
            return new TriggerProperties(new ArrayList<Long>(), new ArrayList<String>());
        }
        return TriggerServiceImpl.fromString(settingValue.getValue().toString());
    }

    @Override
    public void setTriggerEnabledForAccount(String triggerName, long accountId, boolean enabled, String currentUser) throws IllegalAccessException {
        if (!Utils.isRewardingManager(currentUser)) {
            throw new IllegalAccessException("The user is not authorized to enable/disable trigger");
        }
        TriggerProperties triggerProperties = this.getTriggerProperties(triggerName);
        if (enabled) {
            triggerProperties.getDisabledAccounts().remove(accountId);
        } else {
            triggerProperties.getDisabledAccounts().add(accountId);
        }
        this.settingService.set(CONNECTOR_TRIGGER_CONTEXT, TRIGGER_SETTING_SCOPE, triggerName, SettingValue.create((String)TriggerServiceImpl.toString(triggerProperties)));
    }

    @Override
    public boolean isTriggerEnabledForAccount(String triggerName, long accountId) {
        TriggerProperties triggerProperties = this.getTriggerProperties(triggerName);
        return !triggerProperties.getDisabledAccounts().contains(accountId);
    }

    private static TriggerProperties fromString(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return (TriggerProperties)objectMapper.readValue(value, TriggerProperties.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error creating object from string : " + value, e);
        }
    }

    private static String toString(TriggerProperties triggerProperties) {
        if (triggerProperties == null) {
            return null;
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.writeValueAsString((Object)triggerProperties);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error creating string from object : " + String.valueOf(triggerProperties), e);
        }
    }
}

