/*
 * This file is part of the Meeds project (https://meeds.io/).
 * Copyright (C) 2020 Meeds Association
 * contact@meeds.io
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package io.meeds.gamification.model.filter;

import io.meeds.gamification.constant.IdentityType;
import io.meeds.gamification.constant.Period;
import lombok.Data;

@Data
public class LeaderboardFilter {

  private Long         spaceId    = null;

  private Long         programId    = null;

  private Long         identityId   = null;

  private IdentityType identityType = IdentityType.USER;

  private Period       period       = Period.WEEK;

  private long         medianDateInSeconds;

  private int          offset       = 0;

  private int          limit        = 10;

  public String getPeriod() {
    return period.name();
  }

  public void setPeriod(String period) {
    this.period = Period.valueOf(period.toUpperCase());
  }

}
