/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.rest.builder;

import io.meeds.gamification.model.Trigger;
import io.meeds.gamification.model.TriggerProperties;
import io.meeds.gamification.rest.model.TriggerRestEntity;
import io.meeds.gamification.service.TriggerService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class TriggerBuilder {
    private TriggerBuilder() {
    }

    public static TriggerRestEntity toRestEntity(TriggerService triggerService, Trigger trigger, List<String> expandFields) {
        if (trigger == null) {
            return null;
        }
        List<Long> disabledAccounts = null;
        List<String> permissions = null;
        if (CollectionUtils.isNotEmpty(expandFields)) {
            TriggerProperties triggerProperties = triggerService.getTriggerProperties(trigger.getTitle());
            if (expandFields.contains("disabledAccounts")) {
                disabledAccounts = triggerProperties.getDisabledAccounts();
            }
            if (expandFields.contains("permissions")) {
                permissions = triggerProperties.getPermissions();
            }
        }
        return new TriggerRestEntity(trigger.getTitle(), trigger.getType(), trigger.getCanceller(), trigger.isCanVariableRewarding(), CollectionUtils.isNotEmpty(disabledAccounts) ? disabledAccounts : Collections.emptyList(), CollectionUtils.isNotEmpty(permissions) ? permissions : Collections.emptyList());
    }

    public static List<TriggerRestEntity> toRestEntities(TriggerService triggerService, Collection<Trigger> triggers, List<String> expandFields) {
        return triggers.stream().map(trigger -> TriggerBuilder.toRestEntity(triggerService, trigger, expandFields)).toList();
    }
}

