/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service.impl;

import io.meeds.gamification.model.RemoteConnectorSettings;
import io.meeds.gamification.plugin.ConnectorPlugin;
import io.meeds.gamification.service.ConnectorService;
import io.meeds.gamification.service.ConnectorSettingService;
import io.meeds.gamification.utils.Utils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.services.security.Identity;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.exoplatform.web.security.security.TokenServiceInitializationException;

public class ConnectorSettingServiceImpl
implements ConnectorSettingService {
    public static final String CONNECTOR_SETTINGS_KEY_NAME = "CONNECTOR_SETTINGS";
    private SettingService settingService;
    private CodecInitializer codecInitializer;

    public ConnectorSettingServiceImpl(SettingService settingService, CodecInitializer codecInitializer) {
        this.settingService = settingService;
        this.codecInitializer = codecInitializer;
    }

    @Override
    public void saveConnectorSettings(RemoteConnectorSettings remoteConnectorSettings, Identity aclIdentity) throws IllegalAccessException {
        if (!this.canManageConnectorSettings(aclIdentity)) {
            throw new IllegalAccessException("The user is not authorized to save or update connector settings");
        }
        Scope connectorSettingScope = Scope.APPLICATION.id(StringUtils.capitalize((String)remoteConnectorSettings.getName()));
        try {
            remoteConnectorSettings.setSecretKey(this.codecInitializer.getCodec().encode(remoteConnectorSettings.getSecretKey()));
        }
        catch (TokenServiceInitializationException e) {
            throw new IllegalStateException("Error encrypting Secret Key", e);
        }
        remoteConnectorSettings.setApiKey(remoteConnectorSettings.getApiKey());
        String settingsString = Utils.toJsonString(remoteConnectorSettings);
        this.settingService.set(Context.GLOBAL, connectorSettingScope, CONNECTOR_SETTINGS_KEY_NAME, SettingValue.create((String)settingsString));
    }

    @Override
    public void deleteConnectorSettings(String connectorName, Identity aclIdentity) throws IllegalAccessException {
        if (!this.canManageConnectorSettings(aclIdentity)) {
            throw new IllegalAccessException("The user is not authorized to delete connector settings");
        }
        Scope connectorSettingScope = Scope.APPLICATION.id(StringUtils.capitalize((String)connectorName));
        this.settingService.remove(Context.GLOBAL, connectorSettingScope, CONNECTOR_SETTINGS_KEY_NAME);
    }

    @Override
    public RemoteConnectorSettings getConnectorSettings(String connectorName, Identity aclIdentity) throws IllegalAccessException {
        if (!this.canManageConnectorSettings(aclIdentity)) {
            throw new IllegalAccessException("The user is not authorized to access connector settings");
        }
        return this.getConnectorSettings(connectorName);
    }

    @Override
    public RemoteConnectorSettings getConnectorSettings(String connectorName) {
        RemoteConnectorSettings remoteConnectorSettings;
        String settingsValueString;
        Scope connectorSettingScope = Scope.APPLICATION.id(StringUtils.capitalize((String)connectorName));
        SettingValue settingsValue = this.settingService.get(Context.GLOBAL, connectorSettingScope, CONNECTOR_SETTINGS_KEY_NAME);
        String string = settingsValueString = settingsValue == null || settingsValue.getValue() == null ? null : settingsValue.getValue().toString();
        if (settingsValueString == null) {
            remoteConnectorSettings = new RemoteConnectorSettings();
            remoteConnectorSettings.setName(connectorName);
            remoteConnectorSettings.setEnabled(false);
        } else {
            remoteConnectorSettings = Utils.fromJsonString(settingsValueString, RemoteConnectorSettings.class);
            if (remoteConnectorSettings != null) {
                remoteConnectorSettings.setSecretKey(null);
            }
        }
        return remoteConnectorSettings;
    }

    @Override
    public String getConnectorSecretKey(String connectorName) {
        String settingsValueString;
        Scope connectorSettingScope = Scope.APPLICATION.id(StringUtils.capitalize((String)connectorName));
        SettingValue settingsValue = this.settingService.get(Context.GLOBAL, connectorSettingScope, CONNECTOR_SETTINGS_KEY_NAME);
        String string = settingsValueString = settingsValue == null || settingsValue.getValue() == null ? null : settingsValue.getValue().toString();
        if (settingsValueString != null) {
            RemoteConnectorSettings remoteConnectorSettings = Utils.fromJsonString(settingsValueString, RemoteConnectorSettings.class);
            try {
                String decryptedSecretKey = this.codecInitializer.getCodec().decode(remoteConnectorSettings.getSecretKey());
                return decryptedSecretKey;
            }
            catch (TokenServiceInitializationException e) {
                throw new IllegalStateException("Error decrypting connector settings", e);
            }
        }
        return null;
    }

    @Override
    public List<RemoteConnectorSettings> getConnectorsSettings(ConnectorService connectorService, Identity aclIdentity) throws IllegalAccessException {
        if (!this.canManageConnectorSettings(aclIdentity)) {
            throw new IllegalAccessException("The user is not authorized to access connectors settings");
        }
        return connectorService.getConnectorPlugins().stream().map(ConnectorPlugin::getConnectorName).map(this::getConnectorSettings).toList();
    }

    @Override
    public boolean canManageConnectorSettings(Identity aclIdentity) {
        return aclIdentity != null && Utils.isRewardingManager(aclIdentity.getUserId());
    }
}

