/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.listener;

import io.meeds.gamification.listener.AnnouncementActivityUpdater;
import io.meeds.gamification.model.Announcement;
import io.meeds.gamification.service.AnnouncementService;
import io.meeds.gamification.service.RealizationService;
import java.util.Date;
import java.util.HashMap;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.manager.ActivityManager;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class AnnouncementActivityUpdaterTest {
    @Mock
    private ActivityManager activityManager;
    @Mock
    private AnnouncementService announcementService;
    @Mock
    private RealizationService realizationService;

    @Test
    public void testUpdateActivity() throws ObjectNotFoundException {
        AnnouncementActivityUpdater announcementActivityUpdater = new AnnouncementActivityUpdater(this.activityManager, this.announcementService, this.realizationService);
        Announcement announcement = new Announcement(1L, Long.valueOf(1L), "challenge title", Long.valueOf(1L), "announcement comment", Long.valueOf(1L), new Date().toString(), null);
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setType("not announcement activity");
        ActivityLifeCycleEvent activityLifeCycleEvent = new ActivityLifeCycleEvent(ActivityLifeCycleEvent.Type.UPDATE_ACTIVITY, (ExoSocialActivity)activity);
        announcementActivityUpdater.updateActivity(activityLifeCycleEvent);
        ((AnnouncementService)Mockito.verify((Object)this.announcementService, (VerificationMode)Mockito.times((int)0))).getAnnouncementById(ArgumentMatchers.anyLong());
        ExoSocialActivityImpl announcementActivity = new ExoSocialActivityImpl();
        announcementActivity.setType("gamificationActionAnnouncement");
        announcementActivity.setTitle(announcement.getComment());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("announcementId", String.valueOf(announcement.getId()));
        params.put("announcementComment", "new announcement comment ");
        announcementActivity.setTemplateParams(params);
        ActivityLifeCycleEvent announcementActivityLifeCycleEvent = new ActivityLifeCycleEvent(ActivityLifeCycleEvent.Type.UPDATE_ACTIVITY, (ExoSocialActivity)announcementActivity);
        announcementActivityUpdater.updateActivity(announcementActivityLifeCycleEvent);
        ((AnnouncementService)Mockito.verify((Object)this.announcementService, (VerificationMode)Mockito.times((int)1))).updateAnnouncementComment(announcement.getId(), announcement.getComment());
        ((ActivityManager)Mockito.verify((Object)this.activityManager, (VerificationMode)Mockito.times((int)1))).updateActivity((ExoSocialActivity)ArgumentMatchers.any(ExoSocialActivity.class), ArgumentMatchers.anyBoolean());
        ((AnnouncementService)Mockito.doThrow(ObjectNotFoundException.class).when((Object)this.announcementService)).updateAnnouncementComment(announcement.getId(), announcement.getComment());
        announcementActivityUpdater.updateActivity(announcementActivityLifeCycleEvent);
        ((AnnouncementService)Mockito.verify((Object)this.announcementService, (VerificationMode)Mockito.times((int)2))).updateAnnouncementComment(announcement.getId(), announcement.getComment());
        ((ActivityManager)Mockito.verify((Object)this.activityManager, (VerificationMode)Mockito.times((int)2))).updateActivity((ExoSocialActivity)ArgumentMatchers.any(ExoSocialActivity.class), ArgumentMatchers.anyBoolean());
    }
}

