/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service;

import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.filter.ProgramFilter;
import java.io.InputStream;
import java.util.List;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.security.Identity;

public interface ProgramService {
    public static final String PROGRAM_UPDATED_LISTENER = "program.updated";
    public static final String PROGRAM_CREATED_LISTENER = "program.created";
    public static final String PROGRAM_DELETED_LISTENER = "program.deleted";
    public static final String PROGRAM_DISABLED_LISTENER = "program.disabled";
    public static final String PROGRAM_ENABLED_LISTENER = "program.enabled";
    public static final String PROGRAM_AUDIENCE_UPDATED_EVENT = "program.audience.updated";

    public List<ProgramDTO> getPrograms(ProgramFilter var1, String var2, int var3, int var4) throws IllegalAccessException;

    public List<Long> getProgramIds(ProgramFilter var1, String var2, int var3, int var4) throws IllegalAccessException;

    public List<Long> getProgramIds(ProgramFilter var1, int var2, int var3);

    public List<Long> getOwnedProgramIds(String var1, int var2, int var3);

    public List<Long> getMemberProgramIds(String var1, int var2, int var3);

    public List<Long> getPublicProgramIds(int var1, int var2);

    public ProgramDTO getProgramByTitle(String var1);

    public ProgramDTO createProgram(ProgramDTO var1, Identity var2) throws IllegalAccessException;

    public ProgramDTO createProgram(ProgramDTO var1);

    public ProgramDTO updateProgram(ProgramDTO var1, Identity var2) throws ObjectNotFoundException, IllegalAccessException;

    public ProgramDTO updateProgram(ProgramDTO var1) throws ObjectNotFoundException;

    public void updateProgramDate(long var1);

    public ProgramDTO deleteProgramById(long var1, Identity var3) throws ObjectNotFoundException, IllegalAccessException;

    public void deleteProgramCoverById(long var1, Identity var3) throws ObjectNotFoundException, IllegalAccessException;

    public void deleteProgramAvatarById(long var1, Identity var3) throws ObjectNotFoundException, IllegalAccessException;

    public ProgramDTO getProgramById(long var1);

    public ProgramDTO getProgramById(long var1, String var3) throws IllegalAccessException, ObjectNotFoundException;

    public int countPrograms(ProgramFilter var1, String var2) throws IllegalAccessException;

    public int countPrograms(ProgramFilter var1);

    public int countOwnedPrograms(String var1);

    public int countMemberPrograms(String var1);

    public int countPublicPrograms();

    public InputStream getProgramCoverStream(long var1) throws ObjectNotFoundException;

    public InputStream getProgramAvatarStream(long var1) throws ObjectNotFoundException;

    public boolean canAddProgram(Identity var1);

    public boolean canUseProgramColor(long var1, String var3);

    public boolean isProgramOwner(long var1, String var3);

    public boolean isProgramOwner(long var1, String var3, boolean var4);

    public boolean isProgramMember(long var1, String var3);

    public boolean isProgramMember(long var1, String var3, boolean var4);

    public boolean canViewProgram(long var1, String var3);

    public boolean canEditProgram(long var1, String var3);

    public List<String> getAdministrators();
}

