/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.dao;

import io.meeds.gamification.entity.BadgeEntity;
import io.meeds.gamification.entity.ProgramEntity;
import io.meeds.gamification.test.AbstractServiceTest;
import org.junit.Test;

public class BadgeDAOTest
extends AbstractServiceTest {
    @Test
    public void testFindBadgeByTitle() {
        BadgeDAOTest.assertNull((Object)this.badgeStorage.findBadgeByTitle("TeamLeader"));
        this.newBadge(1L);
        BadgeDAOTest.assertNotNull((Object)this.badgeStorage.findBadgeByTitle("TeamLeader"));
    }

    @Test
    public void testFindBadgesByDomain() {
        ProgramEntity domainEntity = this.newDomain();
        BadgeDAOTest.assertEquals((int)this.badgeStorage.findBadgesByProgramId(domainEntity.getId().longValue()).size(), (int)0);
        this.newBadge(domainEntity.getId());
        BadgeDAOTest.assertEquals((int)this.badgeStorage.findBadgesByProgramId(domainEntity.getId().longValue()).size(), (int)1);
    }

    @Test
    public void testFindEnabledBadgesByDomain() {
        ProgramEntity domainEntity = this.newDomain();
        BadgeDAOTest.assertEquals((int)this.badgeStorage.findEnabledBadgesByProgramId(domainEntity.getId().longValue()).size(), (int)0);
        BadgeEntity badgeEntity = this.newBadge(domainEntity.getId());
        BadgeDAOTest.assertEquals((int)this.badgeStorage.findEnabledBadgesByProgramId(domainEntity.getId().longValue()).size(), (int)1);
        badgeEntity.setEnabled(false);
        this.badgeStorage.update((Object)badgeEntity);
        BadgeDAOTest.assertEquals((int)this.badgeStorage.findEnabledBadgesByProgramId(domainEntity.getId().longValue()).size(), (int)0);
    }

    @Test
    public void testGetAllBadges() {
        ProgramEntity domainEntity1 = this.newDomain();
        ProgramEntity domainEntity2 = this.newDomain();
        BadgeDAOTest.assertEquals((int)this.badgeStorage.getAllBadges().size(), (int)0);
        this.newBadge("badge1", domainEntity1.getId());
        this.newBadge("badge2", domainEntity1.getId());
        this.newBadge("badge3", domainEntity2.getId());
        this.newBadge("badge4", domainEntity2.getId());
        this.newBadge("badge5", domainEntity2.getId());
        BadgeDAOTest.assertEquals((int)this.badgeStorage.getAllBadges().size(), (int)5);
    }
}

